/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.projectile;

import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.mutant.MutantSkeletonEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class MutantArrowEntity
extends Entity {
    private static final DataParameter<Integer> TARGET_X = EntityDataManager.func_187226_a(MutantArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TARGET_Y = EntityDataManager.func_187226_a(MutantArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TARGET_Z = EntityDataManager.func_187226_a(MutantArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SPEED = EntityDataManager.func_187226_a(MutantArrowEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> CLONES = EntityDataManager.func_187226_a(MutantArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int damage;
    private final List<Entity> pointedEntities;
    private EffectInstance effectInstance;
    private LivingEntity shooter;

    public MutantArrowEntity(EntityType<? extends MutantArrowEntity> type, World world) {
        super(type, world);
        this.damage = 10 + this.field_70146_Z.nextInt(3);
        this.pointedEntities = new ArrayList<Entity>();
        this.field_70145_X = true;
    }

    public MutantArrowEntity(World world, LivingEntity shooter, LivingEntity target) {
        this(MBEntityType.MUTANT_ARROW, world);
        this.shooter = shooter;
        if (!world.field_72995_K) {
            this.setTargetX(target.func_226277_ct_());
            this.setTargetY(target.func_226278_cu_());
            this.setTargetZ(target.func_226281_cx_());
        }
        double yPos = shooter.func_226280_cw_();
        if (shooter instanceof MutantSkeletonEntity) {
            yPos = shooter.func_226278_cu_() + 1.28;
        }
        this.func_70107_b(shooter.func_226277_ct_(), yPos, shooter.func_226281_cx_());
        double x = this.getTargetX() - this.func_226277_ct_();
        double y = this.getTargetY() - this.func_226278_cu_();
        double z = this.getTargetZ() - this.func_226281_cx_();
        double d = Math.sqrt(x * x + z * z);
        this.field_70177_z = 180.0f + (float)Math.toDegrees(Math.atan2(x, z));
        this.field_70125_A = (float)Math.toDegrees(Math.atan2(y, d));
    }

    public MutantArrowEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        this(MBEntityType.MUTANT_ARROW, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TARGET_X, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_Y, (Object)0);
        this.field_70180_af.func_187214_a(TARGET_Z, (Object)0);
        this.field_70180_af.func_187214_a(SPEED, (Object)Float.valueOf(12.0f));
        this.field_70180_af.func_187214_a(CLONES, (Object)10);
    }

    public double getTargetX() {
        return (double)((Integer)this.field_70180_af.func_187225_a(TARGET_X)).intValue() / 10000.0;
    }

    public void setTargetX(double targetX) {
        this.field_70180_af.func_187227_b(TARGET_X, (Object)((int)(targetX * 10000.0)));
    }

    public double getTargetY() {
        return (double)((Integer)this.field_70180_af.func_187225_a(TARGET_Y)).intValue() / 10000.0;
    }

    public void setTargetY(double targetY) {
        this.field_70180_af.func_187227_b(TARGET_Y, (Object)((int)(targetY * 10000.0)));
    }

    public double getTargetZ() {
        return (double)((Integer)this.field_70180_af.func_187225_a(TARGET_Z)).intValue() / 10000.0;
    }

    public void setTargetZ(double targetZ) {
        this.field_70180_af.func_187227_b(TARGET_Z, (Object)((int)(targetZ * 10000.0)));
    }

    public float getSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(SPEED)).floatValue() / 10.0f;
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_187227_b(SPEED, (Object)Float.valueOf(speed * 10.0f));
    }

    public int getClones() {
        return (Integer)this.field_70180_af.func_187225_a(CLONES);
    }

    public void setClones(int clones) {
        this.field_70180_af.func_187227_b(CLONES, (Object)clones);
    }

    public void randomize(float scale) {
        this.setTargetX(this.getTargetX() + (double)((this.field_70146_Z.nextFloat() - 0.5f) * scale * 2.0f));
        this.setTargetY(this.getTargetY() + (double)((this.field_70146_Z.nextFloat() - 0.5f) * scale * 2.0f));
        this.setTargetZ(this.getTargetZ() + (double)((this.field_70146_Z.nextFloat() - 0.5f) * scale * 2.0f));
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public void setPotionEffect(EffectInstance effectInstance) {
        this.effectInstance = effectInstance;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        double x = this.getTargetX() - this.func_226277_ct_();
        double y = this.getTargetY() - this.func_226278_cu_();
        double z = this.getTargetZ() - this.func_226281_cx_();
        double d = Math.sqrt(x * x + z * z);
        this.field_70177_z = 180.0f + (float)Math.toDegrees(Math.atan2(x, z));
        if (this.field_70177_z > 360.0f) {
            this.field_70177_z -= 360.0f;
        }
        this.field_70125_A = (float)Math.toDegrees(Math.atan2(y, d));
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa == 2) {
                this.hitEntities(0);
            }
            if (this.field_70173_aa == 3) {
                this.hitEntities(32);
            }
            if (this.field_70173_aa == 4) {
                this.handleEntities();
            }
        }
        if (this.field_70173_aa > 10) {
            this.func_70106_y();
        }
    }

    protected void hitEntities(int offset) {
        double targetX = this.getTargetX();
        double targetY = this.getTargetY();
        double targetZ = this.getTargetZ();
        double d3 = this.func_226277_ct_() - targetX;
        double d4 = this.func_226278_cu_() - targetY;
        double d5 = this.func_226281_cx_() - targetZ;
        double dist = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
        double dx = (targetX - this.func_226277_ct_()) / dist;
        double dy = (targetY - this.func_226278_cu_()) / dist;
        double dz = (targetZ - this.func_226281_cx_()) / dist;
        for (int i = offset; i < offset + 200; ++i) {
            double x = this.func_226277_ct_() + dx * (double)i * 0.5;
            double y = this.func_226278_cu_() + dy * (double)i * 0.5;
            double z = this.func_226281_cx_() + dz * (double)i * 0.5;
            AxisAlignedBB box = new AxisAlignedBB(x, y, z, x, y, z).func_186662_g(0.3);
            this.pointedEntities.addAll(this.field_70170_p.func_175674_a((Entity)this.shooter, box, EntityPredicates.field_188444_d.and(Entity::func_70067_L)));
        }
    }

    protected void handleEntities() {
        for (Entity entity : this.pointedEntities) {
            DamageSource damageSource = new IndirectEntityDamageSource("arrow", this, (Entity)this.shooter){

                public Vector3d func_188404_v() {
                    return null;
                }
            }.func_76349_b();
            if (entity instanceof EnderDragonPartEntity) {
                damageSource.func_94540_d();
            }
            if (!entity.func_70097_a(damageSource, (float)this.damage)) continue;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_219609_bA, this.func_184176_by(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            }
            if (this.effectInstance == null || !(entity instanceof LivingEntity)) continue;
            ((LivingEntity)entity).func_195064_c(this.effectInstance);
        }
        this.pointedEntities.clear();
    }

    public void func_213281_b(CompoundNBT compound) {
    }

    public void func_70037_a(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

