/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.mutant;

import chumbanotz.mutantbeasts.entity.CreeperMinionEntity;
import chumbanotz.mutantbeasts.entity.ai.goal.AvoidDamageGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.FleeRainGoal;
import chumbanotz.mutantbeasts.entity.ai.goal.HurtByNearestTargetGoal;
import chumbanotz.mutantbeasts.entity.projectile.ThrowableBlockEntity;
import chumbanotz.mutantbeasts.pathfinding.MBGroundPathNavigator;
import chumbanotz.mutantbeasts.util.MBSoundEvents;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.ReturnToVillageGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.event.ForgeEventFactory;

public class MutantSnowGolemEntity
extends GolemEntity
implements IRangedAttackMob,
IForgeShearable {
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(MutantSnowGolemEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Byte> STATUS = EntityDataManager.func_187226_a(MutantSnowGolemEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private boolean isThrowing;
    private int throwingTick;

    public MutantSnowGolemEntity(EntityType<? extends MutantSnowGolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimJumpGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FleeRainGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.1, 30, 12.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new ThrowIceGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidDamageGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new ReturnToVillageGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByNearestTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, entity -> entity instanceof IMob && (!(entity instanceof CreeperEntity) || ((CreeperEntity)entity).func_70638_az() == this)));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MutantSnowGolemEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.26);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
        this.field_70180_af.func_187214_a(STATUS, (Object)1);
    }

    @Nullable
    public PlayerEntity getOwner() {
        return this.getOwnerId().map(arg_0 -> ((World)this.field_70170_p).func_217371_b(arg_0)).orElse(null);
    }

    public Optional<UUID> getOwnerId() {
        return (Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID);
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public boolean hasJackOLantern() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 1) != 0;
    }

    public void setJackOLantern(boolean jackOLantern) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(jackOLantern ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean getSwimJump() {
        return ((Byte)this.field_70180_af.func_187225_a(STATUS) & 4) != 0;
    }

    public void setSwimJump(boolean swimJumping) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(STATUS);
        this.field_70180_af.func_187227_b(STATUS, (Object)(swimJumping ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new MBGroundPathNavigator((MobEntity)this, worldIn);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.0f;
    }

    public boolean func_213336_c(LivingEntity target) {
        return target instanceof IMob;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        if (worldIn.func_226691_t_(pos).func_225486_c(pos) > 1.2f) {
            return -10.0f;
        }
        return worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150433_aE ? 10.0f : 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.getSwimJump()) {
            for (int i = 0; i < 6; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150433_aE.func_176223_P()), this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
        if (this.isThrowing) {
            ++this.throwingTick;
            if (this.throwingTick >= 20) {
                this.isThrowing = false;
                this.throwingTick = 0;
            }
        }
        if (this.field_70170_p.func_230315_m_().func_236040_e_() || this.field_70170_p.func_226691_t_(this.func_233580_cy_()).func_225486_c(this.func_233580_cy_()) > 1.2f) {
            if (this.field_70146_Z.nextFloat() > Math.min(80.0f, this.func_110143_aJ()) * 0.01f) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218425_n, this.func_226282_d_(0.6), this.func_226279_cv_() - 0.15, this.func_226287_g_(0.6), 0.0, 0.0, 0.0);
            }
            if (this.field_70173_aa % 60 == 0) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
        }
        if (this.field_70173_aa % 80 == 0 && this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP() && this.isSnowingAt(this.func_233580_cy_())) {
            this.func_70691_i(1.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70122_E && !this.field_70170_p.func_230315_m_().func_236040_e_() && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            int x = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            int z = MathHelper.func_76128_c((double)this.func_226281_cx_());
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                    BlockPos pos = new BlockPos(x + i, y, z + j);
                    BlockPos posDown = pos.func_177977_b();
                    BlockPos posAbove = pos.func_177984_a();
                    boolean placeSnow = this.field_70170_p.func_175623_d(pos) && this.field_70170_p.func_226691_t_(pos).func_225486_c(pos) < 0.95f && Blocks.field_150433_aE.func_176223_P().func_196955_c((IWorldReader)this.field_70170_p, pos);
                    boolean placeIce = this.field_70170_p.func_201671_F(posDown);
                    if (this.field_70170_p.func_204610_c(pos).func_206886_c() == Fluids.field_207212_b) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (this.field_70170_p.func_204610_c(posAbove).func_206886_c() == Fluids.field_207212_b) {
                        this.field_70170_p.func_175656_a(posAbove, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (placeSnow && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_70146_Z.nextInt(20) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_70146_Z.nextInt(10) != 0) || placeIce && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.field_70146_Z.nextInt(14) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.field_70146_Z.nextInt(6) != 0)) continue;
                    if (placeSnow) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150433_aE.func_176223_P());
                    }
                    if (!placeIce) continue;
                    this.field_70170_p.func_175656_a(posDown, Blocks.field_150432_aD.func_176223_P());
                }
            }
        }
    }

    private boolean isSnowingAt(BlockPos position) {
        if (!this.field_70170_p.func_72896_J()) {
            return false;
        }
        if (!this.field_70170_p.func_226660_f_(position)) {
            return false;
        }
        if (this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, position).func_177956_o() > position.func_177956_o()) {
            return false;
        }
        Biome biome = this.field_70170_p.func_226691_t_(position);
        return biome.func_201851_b() == Biome.RainType.SNOW && biome.func_225486_c(position) < 0.15f;
    }

    public boolean func_230270_dK_() {
        return true;
    }

    public boolean isShearable(ItemStack item, World world, BlockPos pos) {
        return this.func_70089_S() && this.hasJackOLantern();
    }

    public List<ItemStack> onSheared(PlayerEntity player, ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)this, SoundEvents.field_232843_op_, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!world.func_201670_d()) {
            this.setJackOLantern(false);
            return Collections.singletonList(new ItemStack((IItemProvider)Items.field_221697_cK));
        }
        return Collections.emptyList();
    }

    protected void func_70619_bc() {
        if (this.func_110167_bD()) {
            return;
        }
        PlayerEntity owner = this.getOwner();
        if (owner != null && owner.func_70089_S()) {
            this.func_213390_a(owner.func_233580_cy_(), this.func_70638_az() == null ? 8 : 16);
        } else if (this.func_213394_dL()) {
            this.func_213390_a(BlockPos.field_177992_a, -1);
        }
    }

    public boolean isThrowing() {
        return this.isThrowing;
    }

    public int getThrowingTick() {
        return this.throwingTick;
    }

    private void setThrowing(boolean isThrowing) {
        this.isThrowing = isThrowing;
        this.throwingTick = 0;
        this.field_70170_p.func_72960_a((Entity)this, isThrowing ? (byte)1 : 0);
    }

    public void func_70103_a(byte id) {
        if (id == 0 || id == 1) {
            this.isThrowing = id == 1;
            this.throwingTick = 0;
        } else {
            super.func_70103_a(id);
            if (id == 2 || id == 33 || id == 36 || id == 37 || id == 44) {
                for (int i = 0; i < 30; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150433_aE.func_176223_P()), this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
                }
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76364_f() instanceof SnowballEntity) {
            if (this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(1.0f);
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (!this.isThrowing) {
            this.setThrowing(true);
        }
    }

    public static boolean canHarm(Entity attacker, Entity target) {
        if (!(attacker instanceof MutantSnowGolemEntity)) {
            return true;
        }
        if (target instanceof CreeperMinionEntity) {
            return !((CreeperMinionEntity)target).func_70909_n();
        }
        return target instanceof IMob || target instanceof MobEntity && ((MobEntity)target).func_70638_az() == attacker || ((MutantSnowGolemEntity)attacker).func_70638_az() == target;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        ActionResultType actionresulttype = itemStack.func_111282_a_(player, (LivingEntity)this, hand);
        if (actionresulttype.func_226246_a_()) {
            return actionresulttype;
        }
        if (!(this.getOwnerId().isPresent() && player != this.getOwner() || itemStack.func_77973_b() == Items.field_151126_ay)) {
            if (!this.field_70170_p.field_72995_K) {
                this.setOwnerId(!this.getOwnerId().isPresent() ? player.func_110124_au() : null);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.9f * this.func_70047_e()), (double)this.func_213311_cf() * (double)0.2f);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l) && this.getOwner() instanceof ServerPlayerEntity) {
            this.getOwner().func_145747_a(this.func_110142_aN().func_151521_b(), Util.field_240973_b_);
        }
        super.func_70645_a(cause);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("JackOLantern", this.hasJackOLantern());
        this.getOwnerId().ifPresent(uuid -> compound.func_186854_a("Owner", uuid));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Pumpkin") || compound.func_74764_b("JackOLantern")) {
            this.setJackOLantern(compound.func_74767_n("Pumpkin") || compound.func_74767_n("JackOLantern"));
        }
        if (compound.func_186855_b("OwnerUUID")) {
            this.setOwnerId(compound.func_186857_a("OwnerUUID"));
        } else if (compound.func_186855_b("Owner")) {
            this.setOwnerId(compound.func_186857_a("Owner"));
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MBSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MBSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187815_fJ, 0.15f, 1.0f);
    }

    class ThrowIceGoal
    extends Goal {
        private LivingEntity attackTarget;

        ThrowIceGoal() {
        }

        public boolean func_75250_a() {
            this.attackTarget = MutantSnowGolemEntity.this.func_70638_az();
            return this.attackTarget != null && MutantSnowGolemEntity.this.isThrowing;
        }

        public boolean func_75253_b() {
            return MutantSnowGolemEntity.this.isThrowing && MutantSnowGolemEntity.this.throwingTick < 20;
        }

        public void func_75246_d() {
            MutantSnowGolemEntity.this.func_70661_as().func_75499_g();
            MutantSnowGolemEntity.this.field_70761_aq = MutantSnowGolemEntity.this.field_70177_z;
            if (MutantSnowGolemEntity.this.throwingTick == 7) {
                ThrowableBlockEntity block = new ThrowableBlockEntity(MutantSnowGolemEntity.this);
                double x = this.attackTarget.func_226277_ct_() - block.func_226277_ct_();
                double y = this.attackTarget.func_226278_cu_() - block.func_226278_cu_();
                double z = this.attackTarget.func_226281_cx_() - block.func_226281_cx_();
                double xz = Math.sqrt(x * x + z * z);
                block.func_70186_c(x, y + xz * (double)0.4f, z, 0.9f, 1.0f);
                MutantSnowGolemEntity.this.field_70170_p.func_217376_c((Entity)block);
            }
        }

        public void func_75251_c() {
        }
    }

    static class SwimJumpGoal
    extends Goal {
        private final MutantSnowGolemEntity golem;
        private int jumpTick = 20;
        private boolean waterReplaced;
        private BlockPos.Mutable prevPos;

        public SwimJumpGoal(MutantSnowGolemEntity golem) {
            this.golem = golem;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP));
            golem.field_70699_by.func_212239_d(true);
        }

        public boolean func_75250_a() {
            return this.golem.func_70090_H();
        }

        public void func_75249_e() {
            this.prevPos = new BlockPos.Mutable(this.golem.func_226277_ct_(), this.golem.func_174813_aQ().field_72338_b - 1.0, this.golem.func_226281_cx_());
            this.golem.func_213293_j((this.golem.field_70146_Z.nextFloat() - this.golem.field_70146_Z.nextFloat()) * 0.9f, 1.5, (this.golem.field_70146_Z.nextFloat() - this.golem.field_70146_Z.nextFloat()) * 0.9f);
            this.golem.func_70097_a(DamageSource.field_76369_e, 16.0f);
            this.golem.setSwimJump(true);
        }

        public boolean func_75253_b() {
            return this.jumpTick > 0;
        }

        public void func_75246_d() {
            --this.jumpTick;
            if (!this.waterReplaced && !this.golem.func_70090_H() && this.jumpTick < 17 && ForgeEventFactory.getMobGriefingEvent((World)this.golem.field_70170_p, (Entity)this.golem)) {
                this.prevPos.func_185336_p(this.getWaterSurfaceHeight(this.golem.field_70170_p, (BlockPos)this.prevPos));
                if ((double)this.prevPos.func_177956_o() > this.golem.func_226278_cu_()) {
                    return;
                }
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            BlockPos pos;
                            if (y != 0 && (Math.abs(x) == 2 || Math.abs(z) == 2) || !this.golem.field_70170_p.func_175623_d(pos = this.prevPos.func_177982_a(x, y, z)) && !this.golem.field_70170_p.func_201671_F(pos) || (y != 0 ? (Math.abs(x) == 1 || Math.abs(z) == 1) && this.golem.field_70146_Z.nextInt(4) == 0 : (Math.abs(x) == 2 || Math.abs(z) == 2) && this.golem.field_70146_Z.nextInt(3) == 0)) continue;
                            this.golem.field_70170_p.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                        }
                    }
                }
                BlockPos topPos = this.prevPos.func_177981_b(2);
                if (this.golem.field_70170_p.func_175623_d(topPos)) {
                    this.golem.field_70170_p.func_175656_a(topPos, Blocks.field_150432_aD.func_176223_P());
                }
                this.waterReplaced = true;
            }
        }

        public void func_75251_c() {
            this.jumpTick = 20;
            this.waterReplaced = false;
            this.golem.setSwimJump(false);
            this.prevPos = null;
        }

        private int getWaterSurfaceHeight(World world, BlockPos coord) {
            int y = coord.func_177956_o();
            while (world.func_201671_F(new BlockPos(coord.func_177958_n(), y + 1, coord.func_177952_p()))) {
                ++y;
            }
            return y;
        }
    }
}

