/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.client.renderer.entity;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.client.renderer.MBRenderType;
import chumbanotz.mutantbeasts.client.renderer.entity.model.MutantSnowGolemModel;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class MutantSnowGolemRenderer
extends MobRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> {
    static final ResourceLocation TEXTURE = MutantBeasts.getEntityTexture("mutant_snow_golem/mutant_snow_golem");
    private static final ResourceLocation JACK_O_LANTERN_TEXTURE = MutantBeasts.getEntityTexture("mutant_snow_golem/jack_o_lantern");
    private static final RenderType GLOW_RENDER_TYPE = MBRenderType.getEyes(MutantBeasts.getEntityTexture("mutant_snow_golem/glow"));

    public MutantSnowGolemRenderer(EntityRendererManager manager) {
        super(manager, (EntityModel)new MutantSnowGolemModel(), 0.7f);
        this.func_177094_a(new JackOLanternLayer((IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel>)this));
        this.func_177094_a(new HeldBlockLayer((IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel>)this));
    }

    public void render(MutantSnowGolemEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        PlayerEntity owner = entityIn.getOwner();
        if (owner != null) {
            matrixStackIn.func_227860_a_();
            if (this.func_177070_b((MobEntity)entityIn)) {
                matrixStackIn.func_227861_a_(0.0, (double)0.25875f, 0.0);
            }
            this.func_225629_a_((Entity)entityIn, (ITextComponent)owner.func_145748_c_().func_230532_e_().func_240700_a_(style -> style.func_240722_b_(Boolean.valueOf(true))), matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.func_227865_b_();
        }
    }

    public ResourceLocation getEntityTexture(MutantSnowGolemEntity entity) {
        return TEXTURE;
    }

    static class HeldBlockLayer
    extends LayerRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> {
        public HeldBlockLayer(IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantSnowGolemEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.isThrowing() && livingEntity.getThrowingTick() < 7) {
                matrixStackIn.func_227860_a_();
                boolean leftHanded = livingEntity.func_184638_cS();
                float scale = Math.min(0.8f, ((float)livingEntity.getThrowingTick() + partialTicks) / 7.0f);
                matrixStackIn.func_227861_a_(leftHanded ? -0.4 : 0.4, 0.0, 0.0);
                ((MutantSnowGolemModel)this.func_215332_c()).translateArm(leftHanded, matrixStackIn);
                matrixStackIn.func_227861_a_(0.0, 0.9, 0.0);
                matrixStackIn.func_227862_a_(-scale, -scale, scale);
                matrixStackIn.func_227861_a_(-0.5, -0.5, 0.5);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                Minecraft.func_71410_x().func_175602_ab().renderBlock(Blocks.field_150432_aD.func_176223_P(), matrixStackIn, bufferIn, packedLightIn, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                matrixStackIn.func_227865_b_();
            }
        }
    }

    static class JackOLanternLayer
    extends LayerRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> {
        public JackOLanternLayer(IEntityRenderer<MutantSnowGolemEntity, MutantSnowGolemModel> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MutantSnowGolemEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (livingEntity.hasJackOLantern()) {
                if (!livingEntity.func_82150_aj()) {
                    JackOLanternLayer.func_229141_a_((EntityModel)this.func_215332_c(), (ResourceLocation)JACK_O_LANTERN_TEXTURE, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)packedLightIn, (LivingEntity)livingEntity, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                float green = Math.max(0.0f, 0.8f + 0.05f * MathHelper.func_76134_b((float)(ageInTicks * 0.15f)));
                float blue = Math.max(0.0f, 0.15f + 0.2f * MathHelper.func_76134_b((float)(ageInTicks * 0.1f)));
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(GLOW_RENDER_TYPE);
                ((MutantSnowGolemModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, green, blue, 1.0f);
            }
        }
    }
}

