/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io.v2;

import de.javagl.jgltf.impl.v2.Buffer;
import de.javagl.jgltf.impl.v2.GlTF;
import de.javagl.jgltf.impl.v2.Image;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.impl.UriStrings;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.io.v2.GltfAssetV2;
import de.javagl.jgltf.model.io.v2.GltfUtilsV2;
import de.javagl.jgltf.model.v2.GltfModelV2;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

final class DefaultAssetCreatorV2 {
    private GltfAssetV2 gltfAsset;
    private Set<String> existingBufferUriStrings;
    private Set<String> existingImageUriStrings;

    DefaultAssetCreatorV2() {
    }

    GltfAssetV2 create(GltfModelV2 gltfModel) {
        int i;
        GlTF inputGltf = gltfModel.getGltf();
        GlTF outputGltf = GltfUtilsV2.copy(inputGltf);
        List<Buffer> buffers = Optionals.of(outputGltf.getBuffers());
        List<Image> images = Optionals.of(outputGltf.getImages());
        this.existingBufferUriStrings = DefaultAssetCreatorV2.collectUriStrings(buffers, Buffer::getUri);
        this.existingImageUriStrings = DefaultAssetCreatorV2.collectUriStrings(images, Image::getUri);
        this.gltfAsset = new GltfAssetV2(outputGltf, null);
        for (i = 0; i < buffers.size(); ++i) {
            Buffer buffer = buffers.get(i);
            this.storeBufferAsDefault(gltfModel, i, buffer);
        }
        for (i = 0; i < images.size(); ++i) {
            Image image = images.get(i);
            this.storeImageAsDefault(gltfModel, i, image);
        }
        return this.gltfAsset;
    }

    private static <T> Set<String> collectUriStrings(Collection<T> elements, Function<? super T, ? extends String> uriFunction) {
        return elements.stream().map(uriFunction).filter(Objects::nonNull).filter(uriString -> !IO.isDataUriString(uriString)).collect(Collectors.toSet());
    }

    private void storeBufferAsDefault(GltfModelV2 gltfModel, int index, Buffer buffer) {
        String oldUriString;
        BufferModel bufferModel = gltfModel.getBufferModels().get(index);
        ByteBuffer bufferData = bufferModel.getBufferData();
        String newUriString = oldUriString = buffer.getUri();
        if (oldUriString == null || IO.isDataUriString(oldUriString)) {
            newUriString = UriStrings.createBufferUriString(this.existingBufferUriStrings);
            buffer.setUri(newUriString);
            this.existingBufferUriStrings.add(newUriString);
        }
        this.gltfAsset.putReferenceData(newUriString, bufferData);
    }

    private void storeImageAsDefault(GltfModelV2 gltfModel, int index, Image image) {
        String oldUriString;
        ImageModel imageModel = gltfModel.getImageModels().get(index);
        ByteBuffer imageData = imageModel.getImageData();
        String newUriString = oldUriString = image.getUri();
        if (oldUriString == null || IO.isDataUriString(oldUriString)) {
            newUriString = UriStrings.createImageUriString(imageModel, this.existingImageUriStrings);
            image.setUri(newUriString);
            this.existingImageUriStrings.add(newUriString);
        }
        if (image.getBufferView() != null) {
            image.setBufferView(null);
        }
        this.gltfAsset.putReferenceData(newUriString, imageData);
    }
}

