/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io.v1;

import de.javagl.jgltf.impl.v1.Buffer;
import de.javagl.jgltf.impl.v1.GlTF;
import de.javagl.jgltf.impl.v1.Image;
import de.javagl.jgltf.impl.v1.Shader;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.gl.ShaderModel;
import de.javagl.jgltf.model.impl.UriStrings;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.io.v1.GltfAssetV1;
import de.javagl.jgltf.model.io.v1.GltfUtilsV1;
import de.javagl.jgltf.model.v1.BinaryGltfV1;
import de.javagl.jgltf.model.v1.GltfExtensionsV1;
import de.javagl.jgltf.model.v1.GltfModelV1;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

final class DefaultAssetCreatorV1 {
    private GltfAssetV1 gltfAsset;
    private Set<String> existingBufferUriStrings;
    private Set<String> existingImageUriStrings;
    private Set<String> existingShaderUriStrings;

    DefaultAssetCreatorV1() {
    }

    GltfAssetV1 create(GltfModelV1 gltfModel) {
        GlTF inputGltf = gltfModel.getGltf();
        GlTF outputGltf = GltfUtilsV1.copy(inputGltf);
        GltfExtensionsV1.removeExtensionUsed(outputGltf, BinaryGltfV1.getBinaryGltfExtensionName());
        this.existingBufferUriStrings = DefaultAssetCreatorV1.collectUriStrings(Optionals.of(inputGltf.getBuffers()).values(), Buffer::getUri);
        this.existingImageUriStrings = DefaultAssetCreatorV1.collectUriStrings(Optionals.of(inputGltf.getImages()).values(), Image::getUri);
        this.existingShaderUriStrings = DefaultAssetCreatorV1.collectUriStrings(Optionals.of(inputGltf.getShaders()).values(), Shader::getUri);
        this.gltfAsset = new GltfAssetV1(outputGltf, null);
        Optionals.of(outputGltf.getBuffers()).forEach((id, value) -> this.storeBufferAsDefault(gltfModel, (String)id, (Buffer)value));
        Optionals.of(outputGltf.getImages()).forEach((id, value) -> this.storeImageAsDefault(gltfModel, (String)id, (Image)value));
        Optionals.of(outputGltf.getShaders()).forEach((id, value) -> this.storeShaderAsDefault(gltfModel, (String)id, (Shader)value));
        return this.gltfAsset;
    }

    private static <T> Set<String> collectUriStrings(Collection<T> elements, Function<? super T, ? extends String> uriFunction) {
        return elements.stream().map(uriFunction).filter(Objects::nonNull).filter(uriString -> !IO.isDataUriString(uriString)).collect(Collectors.toSet());
    }

    private void storeBufferAsDefault(GltfModelV1 gltfModel, String id, Buffer buffer) {
        String oldUriString;
        BufferModel bufferModel = gltfModel.getBufferModelById(id);
        ByteBuffer bufferData = bufferModel.getBufferData();
        String newUriString = oldUriString = buffer.getUri();
        if (oldUriString == null || IO.isDataUriString(oldUriString) || BinaryGltfV1.isBinaryGltfBufferId(id)) {
            newUriString = UriStrings.createBufferUriString(this.existingBufferUriStrings);
            buffer.setUri(newUriString);
            this.existingBufferUriStrings.add(newUriString);
        }
        this.gltfAsset.putReferenceData(newUriString, bufferData);
    }

    private void storeImageAsDefault(GltfModelV1 gltfModel, String id, Image image) {
        String oldUriString;
        ImageModel imageModel = gltfModel.getImageModelById(id);
        ByteBuffer imageData = imageModel.getImageData();
        String newUriString = oldUriString = image.getUri();
        if (oldUriString == null || IO.isDataUriString(oldUriString) || BinaryGltfV1.hasBinaryGltfExtension(image)) {
            newUriString = UriStrings.createImageUriString(imageModel, this.existingImageUriStrings);
            image.setUri(newUriString);
            this.existingImageUriStrings.add(newUriString);
            image.removeExtensions(BinaryGltfV1.getBinaryGltfExtensionName());
        }
        this.gltfAsset.putReferenceData(newUriString, imageData);
    }

    private void storeShaderAsDefault(GltfModelV1 gltfModel, String id, Shader shader) {
        String oldUriString;
        ShaderModel shaderModel = gltfModel.getShaderModelById(id);
        ByteBuffer shaderData = shaderModel.getShaderData();
        String newUriString = oldUriString = shader.getUri();
        if (oldUriString == null || IO.isDataUriString(oldUriString) || BinaryGltfV1.hasBinaryGltfExtension(shader)) {
            newUriString = UriStrings.createShaderUriString(shaderModel, this.existingShaderUriStrings);
            shader.setUri(newUriString);
            this.existingShaderUriStrings.add(newUriString);
            shader.removeExtensions(BinaryGltfV1.getBinaryGltfExtensionName());
        }
        this.gltfAsset.putReferenceData(newUriString, shaderData);
    }
}

