/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.impl.creation;

import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.Accessors;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.ElementType;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.impl.DefaultBufferModel;
import de.javagl.jgltf.model.impl.DefaultBufferViewModel;
import de.javagl.jgltf.model.impl.creation.AccessorModels;
import de.javagl.jgltf.model.impl.creation.BufferStructure;
import de.javagl.jgltf.model.impl.creation.Utils;
import de.javagl.jgltf.model.io.Buffers;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class BufferStructureBuilder {
    private static final Logger logger = Logger.getLogger(BufferStructureBuilder.class.getName());
    private final BufferStructure bufferStructure = new BufferStructure();
    private final List<DefaultAccessorModel> currentAccessorModels = new ArrayList<DefaultAccessorModel>();
    private final Map<DefaultAccessorModel, ByteBuffer> rawAccessorModelByteBuffers = new LinkedHashMap<DefaultAccessorModel, ByteBuffer>();
    private final List<DefaultBufferViewModel> currentBufferViewModels = new ArrayList<DefaultBufferViewModel>();

    private DefaultAccessorModel getDefaultAccessorModel(AccessorModel accessorModel) {
        if (accessorModel instanceof DefaultAccessorModel) {
            return (DefaultAccessorModel)accessorModel;
        }
        logger.severe("AccessorModel is not a DefaultAccessorModel: " + accessorModel);
        return null;
    }

    private DefaultBufferViewModel getDefaultBufferViewModel(BufferViewModel bufferViewModel) {
        if (bufferViewModel instanceof DefaultBufferViewModel) {
            return (DefaultBufferViewModel)bufferViewModel;
        }
        logger.severe("BufferViewModel is not a DefaultBufferViewModel: " + bufferViewModel);
        return null;
    }

    private DefaultBufferModel getDefaultBufferModel(BufferModel bufferModel) {
        if (bufferModel instanceof DefaultBufferModel) {
            return (DefaultBufferModel)bufferModel;
        }
        logger.severe("BufferModel is not a DefaultBufferModel: " + bufferModel);
        return null;
    }

    public int getNumAccessorModels() {
        return this.bufferStructure.getAccessorModels().size();
    }

    public int getNumBufferViewModels() {
        return this.bufferStructure.getBufferViewModels().size();
    }

    public int getNumBufferModels() {
        return this.bufferStructure.getBufferModels().size();
    }

    public void createAccessorModel(String id, float[] data, String type) {
        ElementType elementType = ElementType.valueOf(type);
        int numComponents = elementType.getNumComponents();
        if (data.length % numComponents != 0) {
            throw new IllegalArgumentException("Invalid data for type " + type + ". The data.length is not divisble by " + numComponents);
        }
        int componentType = 5126;
        ByteBuffer byteBuffer = Buffers.createByteBufferFrom(FloatBuffer.wrap(data));
        this.createAccessorModel(id, componentType, type, byteBuffer);
    }

    public void createAccessorModel(String id, short[] data, String type) {
        ElementType elementType = ElementType.valueOf(type);
        int numComponents = elementType.getNumComponents();
        if (data.length % numComponents != 0) {
            throw new IllegalArgumentException("Invalid data for type " + type + ". The data.length is not divisble by " + numComponents);
        }
        int componentType = 5123;
        ByteBuffer byteBuffer = Buffers.createByteBufferFrom(ShortBuffer.wrap(data));
        this.createAccessorModel(id, componentType, type, byteBuffer);
    }

    public void createAccessorModel(String id, int componentType, String type, ByteBuffer byteBuffer) {
        ElementType elementType = ElementType.valueOf(type);
        int numComponents = elementType.getNumComponents();
        int numBytesPerComponent = Accessors.getNumBytesForAccessorComponentType(componentType);
        int numBytesPerElement = numComponents * numBytesPerComponent;
        int count = byteBuffer.capacity() / numBytesPerElement;
        DefaultAccessorModel accessorModel = new DefaultAccessorModel(componentType, count, elementType);
        this.bufferStructure.addAccessorModel(accessorModel, id);
        this.currentAccessorModels.add(accessorModel);
        this.rawAccessorModelByteBuffers.put(accessorModel, byteBuffer);
    }

    public void createArrayBufferViewModel(String id) {
        this.createBufferViewModel(id, 34962);
    }

    public void createArrayElementBufferViewModel(String id) {
        this.createBufferViewModel(id, 34963);
    }

    public void createBufferViewModel(String id, Integer target) {
        DefaultBufferViewModel bufferViewModel = new DefaultBufferViewModel(target);
        for (DefaultAccessorModel accessorModel : this.currentAccessorModels) {
            accessorModel.setBufferViewModel(bufferViewModel);
        }
        this.bufferStructure.addBufferViewModel(bufferViewModel, id, this.currentAccessorModels);
        this.currentBufferViewModels.add(bufferViewModel);
        this.currentAccessorModels.clear();
    }

    public void createBufferModel(String id, String uri) {
        DefaultBufferModel bufferModel = new DefaultBufferModel();
        bufferModel.setUri(uri);
        for (DefaultBufferViewModel bufferViewModel : this.currentBufferViewModels) {
            bufferViewModel.setBufferModel(bufferModel);
        }
        this.bufferStructure.addBufferModel(bufferModel, id, this.currentBufferViewModels);
        this.currentBufferViewModels.clear();
    }

    public BufferStructure build() {
        this.buildDefault();
        return this.bufferStructure;
    }

    private void buildDefault() {
        for (BufferModel bufferModel : this.bufferStructure.getBufferModels()) {
            ArrayList<ByteBuffer> bufferElements = new ArrayList<ByteBuffer>();
            List<BufferViewModel> bufferViewModels = this.bufferStructure.getBufferViewModels(bufferModel);
            int accumulatedBufferBytes = 0;
            for (BufferViewModel bufferViewModel : bufferViewModels) {
                List<AccessorModel> accessorModels = this.bufferStructure.getAccessorModels(bufferViewModel);
                int bufferViewAlignmnentBytes = AccessorModels.computeAlignmentBytes(accessorModels);
                int paddingBytesForBuffer = Utils.computePadding(accumulatedBufferBytes, bufferViewAlignmnentBytes);
                this.bufferStructure.addPaddingByteIndices(bufferModel, accumulatedBufferBytes, paddingBytesForBuffer);
                bufferElements.add(ByteBuffer.allocate(paddingBytesForBuffer));
                DefaultBufferViewModel defaultBufferViewModel = this.getDefaultBufferViewModel(bufferViewModel);
                defaultBufferViewModel.setByteOffset(accumulatedBufferBytes += paddingBytesForBuffer);
                int commonByteStride = AccessorModels.computeCommonByteStride(accessorModels);
                for (AccessorModel accessorModel : accessorModels) {
                    DefaultAccessorModel defaultAccessorModel = this.getDefaultAccessorModel(accessorModel);
                    defaultAccessorModel.setByteStride(commonByteStride);
                }
                if (accessorModels.size() > 1) {
                    defaultBufferViewModel.setByteStride(commonByteStride);
                }
                int accumulatedBufferViewBytes = 0;
                for (AccessorModel accessorModel : accessorModels) {
                    ByteBuffer rawAccessorByteBuffer;
                    int accessorAlignmentBytes = AccessorModels.computeAlignmentBytes(accessorModel);
                    int paddingBytesForBufferView = Utils.computePadding(accumulatedBufferViewBytes, accessorAlignmentBytes);
                    if (paddingBytesForBufferView != 0) {
                        logger.warning("Inserting " + paddingBytesForBufferView + " padding bytes for buffer view, due to accessor " + accessorModel);
                    }
                    this.bufferStructure.addPaddingByteIndices(bufferModel, accumulatedBufferBytes, paddingBytesForBufferView);
                    DefaultAccessorModel defaultAccessorModel = this.getDefaultAccessorModel(accessorModel);
                    defaultAccessorModel.setByteOffset(accumulatedBufferViewBytes += paddingBytesForBufferView);
                    ByteBuffer accessorByteBuffer = rawAccessorByteBuffer = this.rawAccessorModelByteBuffers.get(accessorModel);
                    int elementSizeInBytes = accessorModel.getElementSizeInBytes();
                    if (elementSizeInBytes != commonByteStride) {
                        accessorByteBuffer = BufferStructureBuilder.applyByteStride(rawAccessorByteBuffer, elementSizeInBytes, commonByteStride);
                    }
                    accumulatedBufferViewBytes += accessorByteBuffer.capacity();
                    accumulatedBufferBytes += paddingBytesForBufferView;
                    bufferElements.add(ByteBuffer.allocate(paddingBytesForBufferView));
                    accumulatedBufferBytes += accessorByteBuffer.capacity();
                    bufferElements.add(accessorByteBuffer);
                }
                defaultBufferViewModel.setByteLength(accumulatedBufferViewBytes);
            }
            this.validatePadding(bufferModel);
            ByteBuffer bufferData = Buffers.concat(bufferElements);
            DefaultBufferModel defaultBufferModel = this.getDefaultBufferModel(bufferModel);
            defaultBufferModel.setBufferData(bufferData);
        }
    }

    private static ByteBuffer applyByteStride(ByteBuffer oldByteBuffer, int oldByteStride, int newByteStride) {
        int count = oldByteBuffer.capacity() / oldByteStride;
        ByteBuffer newByteBuffer = ByteBuffer.allocate(count * newByteStride);
        for (int i = 0; i < count; ++i) {
            int srcPos = i * oldByteStride;
            int dstPos = i * newByteStride;
            Buffers.bufferCopy(oldByteBuffer, srcPos, newByteBuffer, dstPos, oldByteStride);
        }
        return newByteBuffer;
    }

    private void validatePadding(BufferModel bufferModel) {
        List<BufferViewModel> bufferViewModels = this.bufferStructure.getBufferViewModels();
        for (BufferViewModel bufferViewModel : bufferViewModels) {
            List<AccessorModel> accessorModels = this.bufferStructure.getAccessorModels(bufferViewModel);
            for (AccessorModel accessorModel : accessorModels) {
                this.validatePadding(bufferViewModel, accessorModel);
            }
        }
    }

    private void validatePadding(BufferViewModel bufferViewModel, AccessorModel accessorModel) {
        int alignmentBytes = AccessorModels.computeAlignmentBytes(accessorModel);
        int bufferViewByteOffset = bufferViewModel.getByteOffset();
        int accessorByteOffset = accessorModel.getByteOffset();
        int totalByteOffset = bufferViewByteOffset + accessorByteOffset;
        if (accessorByteOffset % alignmentBytes != 0) {
            logger.severe("Error: accessor.byteOffset is " + accessorByteOffset + " for alignment " + alignmentBytes + " in accessor " + accessorModel);
        }
        if (totalByteOffset % alignmentBytes != 0) {
            logger.severe("Error: bufferView.byteOffset+accessor.byteOffset is " + totalByteOffset + " for alignment " + alignmentBytes + " in accessor " + accessorModel);
        }
    }
}

