/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.impl.creation;

import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.impl.creation.Utils;

class AccessorModels {
    static int computeAlignmentBytes(AccessorModel accessorModel) {
        return accessorModel.getComponentSizeInBytes();
    }

    static int computeAlignmentBytes(Iterable<? extends AccessorModel> accessorModels) {
        int alignmentBytes = 1;
        for (AccessorModel accessorModel : accessorModels) {
            alignmentBytes = Utils.computeLeastCommonMultiple(alignmentBytes, AccessorModels.computeAlignmentBytes(accessorModel));
        }
        return alignmentBytes;
    }

    static int computeCommonByteStride(Iterable<? extends AccessorModel> accessorModels) {
        int commonByteStride = 1;
        for (AccessorModel accessorModel : accessorModels) {
            int elementSize = accessorModel.getElementSizeInBytes();
            commonByteStride = Math.max(commonByteStride, elementSize);
        }
        return commonByteStride;
    }

    private AccessorModels() {
    }
}

