/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.animation;

import de.javagl.jgltf.model.animation.AnimationManager;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public final class AnimationRunner {
    public static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(5, Thread::new);
    private final AnimationManager animationManager;
    private volatile boolean running = false;
    private volatile boolean blocking = false;
    private long previousNs = System.nanoTime();
    private final long stepSizeMs = 6L;

    public AnimationRunner(AnimationManager animationManager) {
        Objects.requireNonNull(animationManager, "The animationManager may not be null");
        this.animationManager = animationManager;
    }

    public AnimationRunner() {
        this.animationManager = null;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        executorService.execute(new AnimationRunnable(null));
    }

    public synchronized void start(Runnable callback) {
        if (this.isRunning()) {
            return;
        }
        executorService.execute(new AnimationRunnable(callback));
    }

    public synchronized void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void runAnimations() {
        while (this.blocking) {
        }
        this.running = true;
        this.previousNs = System.nanoTime();
        while (this.isRunning()) {
            this.blocking = true;
            long currentNs = System.nanoTime();
            long deltaNs = currentNs - this.previousNs;
            this.animationManager.performStep(deltaNs);
            this.previousNs = currentNs;
            if (this.animationManager.tipStop()) {
                this.stop();
                this.animationManager.reset();
                break;
            }
            try {
                Thread.sleep(6L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.blocking = false;
                return;
            }
        }
        this.blocking = false;
    }

    public AnimationManager getAnimationManager() {
        return this.animationManager;
    }

    static {
        for (int i = 0; i < 5; ++i) {
            executorService.execute(() -> {});
        }
    }

    public class AnimationRunnable
    implements Runnable {
        private final Runnable callback;

        public AnimationRunnable(Runnable callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            AnimationRunner.this.runAnimations();
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }
}

