/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.network.message;

import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.tac.guns.event.GunReloadEvent;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.GunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.IMessage;
import com.tac.guns.network.message.MessageGunSound;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MessageReload
implements IMessage {
    private boolean reload;

    public MessageReload() {
    }

    public MessageReload(boolean reload) {
        this.reload = reload;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.reload);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.reload = buffer.readBoolean();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && !player.func_175149_v()) {
                SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.RELOADING, (Object)this.reload);
                if (!this.reload) {
                    return;
                }
                ItemStack gun = player.func_184614_ca();
                if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Pre((PlayerEntity)player, gun))) {
                    SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.RELOADING, (Object)false);
                    return;
                }
                MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Post((PlayerEntity)player, gun));
                ResourceLocation reloadSound = ((GunItem)gun.func_77973_b()).getGun().getSounds().getCock();
                if (reloadSound != null) {
                    MessageGunSound message = new MessageGunSound(reloadSound, SoundCategory.PLAYERS, (float)player.func_226277_ct_(), (float)player.func_226278_cu_() + 1.0f, (float)player.func_226281_cx_(), 1.0f, 1.0f, player.func_145782_y(), false, true);
                    PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), 16.0, player.field_70170_p.func_234923_W_())), (Object)message);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

