/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.network.message;

import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.IMessage;
import com.tac.guns.network.message.MessageAnimationSound;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MessageAnimationRun
implements IMessage {
    private ResourceLocation animationResource;
    private ResourceLocation soundResource;
    private boolean play;
    private UUID fromWho;

    public MessageAnimationRun() {
    }

    public MessageAnimationRun(ResourceLocation animationResource, ResourceLocation soundResource, boolean play, UUID fromWho) {
        this.animationResource = animationResource;
        this.soundResource = soundResource;
        this.play = play;
        this.fromWho = fromWho;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.animationResource);
        buffer.func_192572_a(this.soundResource);
        buffer.writeBoolean(this.play);
        buffer.func_179252_a(this.fromWho);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.animationResource = buffer.func_192575_l();
        this.soundResource = buffer.func_192575_l();
        this.play = buffer.readBoolean();
        this.fromWho = buffer.func_179253_g();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            MessageAnimationSound message = new MessageAnimationSound(this.animationResource, this.soundResource, this.play, this.fromWho);
            PacketHandler.getPlayChannel().send(PacketDistributor.ALL.noArg(), (Object)message);
        });
        supplier.get().setPacketHandled(true);
    }
}

