/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item.attachment.impl;

import com.tac.guns.common.attachments.CustomModifierData;
import com.tac.guns.common.attachments.NetworkModifierManager;
import com.tac.guns.common.attachments.PerkTipsBuilder;
import com.tac.guns.common.attachments.Perks;
import com.tac.guns.interfaces.IGunModifier;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.item.transition.TimelessGunItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="tac", value={Dist.CLIENT})
public abstract class Attachment {
    public static final String CUSTOM_MODIFIER = "CustomModifier";
    private ResourceLocation defaultModifier;
    private List<ITextComponent> perks = null;

    public Attachment(ResourceLocation defaultModifier) {
        this.defaultModifier = defaultModifier;
    }

    public Attachment(IGunModifier[] modifier) {
    }

    public static boolean hasCustomModifier(ItemStack stack) {
        return stack != null && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b(CUSTOM_MODIFIER, 8);
    }

    public static CustomModifierData getCustomModifier(ItemStack stack) {
        String raw;
        ResourceLocation tmp;
        if (!(stack.func_77973_b() instanceof IAttachment)) {
            return null;
        }
        ResourceLocation loc = ((Attachment)((IAttachment)stack.func_77973_b()).getProperties()).getDefaultModifier();
        if (Attachment.hasCustomModifier(stack) && stack.func_77978_p() != null && (tmp = ResourceLocation.func_208304_a((String)(raw = stack.func_77978_p().func_74779_i(CUSTOM_MODIFIER)))) != null) {
            loc = tmp;
        }
        if (loc != null) {
            boolean side;
            boolean bl = side = Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER;
            if (side) {
                return NetworkModifierManager.getLocalCustomModifier(loc);
            }
            return NetworkModifierManager.getCustomModifier(loc);
        }
        return null;
    }

    public ResourceLocation getDefaultModifier() {
        return this.defaultModifier;
    }

    public static boolean canApplyOn(ItemStack attachment, TimelessGunItem gun) {
        if (gun.getRegistryName() == null) {
            return false;
        }
        CustomModifierData data = Attachment.getCustomModifier(attachment);
        if (data != null) {
            return data.canApplyOn(gun);
        }
        return true;
    }

    private static List<ITextComponent> getSuitableGuns(CustomModifierData modifier) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (modifier.getSuitableGuns() != null) {
            modifier.getSuitableGuns().forEach(rl -> {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
                if (item instanceof TimelessGunItem) {
                    list.add((ITextComponent)new TranslationTextComponent(item.func_77658_a()).func_240699_a_(TextFormatting.GREEN));
                }
            });
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void addInformationEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        CustomModifierData info = Attachment.getCustomModifier(stack);
        if (info != null) {
            List<ITextComponent> list;
            List<ITextComponent> perks = new PerkTipsBuilder(info).add(Perks.silencedFire).addPercentage(Perks.modifyProjectileBlastDamage).addPercentage(Perks.modifyProjectileArmorIgnore).addPercentage(Perks.modifyProjectileHeadDamage).addPercentage(Perks.modifyFireSoundRadius).add(Perks.additionalDamage).add(Perks.additionalPierce).add(Perks.additionalHeadshotDamage).addPercentage(Perks.modifyProjectileDamage).addPercentage(Perks.modifyProjectileSpeed).addPercentage(Perks.modifyProjectileSpread).addPercentage(Perks.modifyFirstShotSpread).addPercentage(Perks.modifyHipFireSpread).addPercentage(Perks.recoilModifier).addPercentage(Perks.horizontalRecoilModifier).addPercentage(Perks.modifyAimDownSightSpeed).add(Perks.additionalWeaponWeight).add(Perks.modifyWeaponWeight).build();
            if (!perks.isEmpty()) {
                tooltip.add(new TranslationTextComponent("perk.tac.title").func_240701_a_(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.BOLD}));
                tooltip.addAll(perks);
            }
            if (!info.isHideLimitInfo() && !(list = Attachment.getSuitableGuns(info)).isEmpty()) {
                tooltip.add(new TranslationTextComponent("limit.tac.title").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.BOLD}));
                tooltip.addAll(list);
            }
            if (info.getExtraTooltip() != null) {
                info.getExtraTooltip().forEach(s -> tooltip.add(new TranslationTextComponent(s)));
            }
        }
    }

    private static void addPerk(List<ITextComponent> components, String id, Object ... params) {
        components.add((ITextComponent)new TranslationTextComponent("perk.tac.entry.negative", new Object[]{new TranslationTextComponent(id, params).func_240699_a_(TextFormatting.AQUA)}));
    }

    private static void addPerkP(List<ITextComponent> components, String id, Object ... params) {
        components.add((ITextComponent)new TranslationTextComponent(id, params).func_240699_a_(TextFormatting.GREEN));
    }

    private static void addPerkN(List<ITextComponent> components, String id, Object ... params) {
        components.add((ITextComponent)new TranslationTextComponent(id, params).func_240699_a_(TextFormatting.RED));
    }
}

