/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IWeaponColorable {
    public WeaponColorSegment getColorSegment();

    default public boolean canWeaponColor(ItemStack stack) {
        return true;
    }

    default public boolean hasWeaponColor(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        boolean hasColor = false;
        for (WeaponColorSegment colorSegment : WeaponColorSegment.values()) {
            if (!tagCompound.func_150297_b(colorSegment.colorTranslationKey, 3)) continue;
            hasColor = true;
        }
        return hasColor;
    }

    default public int[] getWeaponColors(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        int[] colors = new int[WeaponColorSegment.values().length];
        int iterator = 0;
        for (WeaponColorSegment colorSegment : WeaponColorSegment.values()) {
            colors[iterator] = tagCompound.func_74762_e(colorSegment.colorTranslationKey);
        }
        return colors;
    }

    default public void setWeaponColor(ItemStack stack, WeaponColorSegment segment, int color) {
        CompoundNBT tagCompound = stack.func_196082_o();
        tagCompound.func_74768_a(segment.colorTranslationKey, color);
    }

    default public void removeWeaponColor(ItemStack stack, WeaponColorSegment segment) {
        CompoundNBT tagCompound = stack.func_196082_o();
        tagCompound.func_82580_o(segment.colorTranslationKey);
    }

    default public int getWeaponColorBySegment(ItemStack stack, WeaponColorSegment segment) {
        CompoundNBT tagCompound = stack.func_196082_o();
        return tagCompound.func_74762_e(segment.colorTranslationKey);
    }

    public static ItemStack dye(ItemStack stack, WeaponColorSegment colorSegment, List<DyeItem> dyes) {
        ItemStack resultStack = ItemStack.field_190927_a;
        int[] combinedColors = new int[3];
        int maxColor = 0;
        int colorCount = 0;
        IWeaponColorable coloredItem = null;
        if (stack.func_77973_b() instanceof IWeaponColorable && ((IWeaponColorable)stack.func_77973_b()).canWeaponColor(stack)) {
            coloredItem = (IWeaponColorable)stack.func_77973_b();
            resultStack = stack.func_77946_l();
            resultStack.func_190920_e(1);
            if (coloredItem.hasWeaponColor(stack)) {
                int color = coloredItem.getWeaponColorBySegment(resultStack, colorSegment);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                maxColor = (int)((float)maxColor + Math.max(red, Math.max(green, blue)) * 255.0f);
                combinedColors[0] = (int)((float)combinedColors[0] + red * 255.0f);
                combinedColors[1] = (int)((float)combinedColors[1] + green * 255.0f);
                combinedColors[2] = (int)((float)combinedColors[2] + blue * 255.0f);
                ++colorCount;
            }
            for (DyeItem dyeitem : dyes) {
                float[] colorComponents = dyeitem.func_195962_g().func_193349_f();
                int red = (int)(colorComponents[0] * 255.0f);
                int green = (int)(colorComponents[1] * 255.0f);
                int blue = (int)(colorComponents[2] * 255.0f);
                maxColor += Math.max(red, Math.max(green, blue));
                combinedColors[0] = combinedColors[0] + red;
                combinedColors[1] = combinedColors[1] + green;
                combinedColors[2] = combinedColors[2] + blue;
                ++colorCount;
            }
        }
        if (coloredItem == null) {
            return ItemStack.field_190927_a;
        }
        int red = combinedColors[0] / colorCount;
        int green = combinedColors[1] / colorCount;
        int blue = combinedColors[2] / colorCount;
        float averageColor = (float)maxColor / (float)colorCount;
        float maxValue = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * averageColor / maxValue);
        green = (int)((float)green * averageColor / maxValue);
        blue = (int)((float)blue * averageColor / maxValue);
        int finalColor = (red << 8) + green;
        finalColor = (finalColor << 8) + blue;
        coloredItem.setWeaponColor(resultStack, colorSegment, finalColor);
        return resultStack;
    }

    public static enum WeaponColorSegment {
        BARREL_COLOR("barrel_color"),
        IRON_SIGHTS_COLOR("iron_sights_color"),
        HANDGUARD_COLOR("handguard_color"),
        BODY_COLOR("body_color"),
        MAGAZINE_COLOR("magazine_color"),
        GRIP_COLOR("grip_color"),
        STOCK_COLOR("stock_color"),
        EXTRA_PIECES_COLOR("extra_color");

        private String colorTranslationKey;

        private WeaponColorSegment(String colorTranslationKey) {
            this.colorTranslationKey = colorTranslationKey;
        }

        public String getColorTranslationKey() {
            return this.colorTranslationKey;
        }

        @Nullable
        public static WeaponColorSegment byTagKey(String colorTranslationKey) {
            for (WeaponColorSegment colorSegment : WeaponColorSegment.values()) {
                if (!colorSegment.colorTranslationKey.equalsIgnoreCase(colorTranslationKey)) continue;
                return colorSegment;
            }
            return null;
        }
    }
}

