/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.entity;

import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.tac.guns.Config;
import com.tac.guns.common.AimingManager;
import com.tac.guns.common.BoundingBoxManager;
import com.tac.guns.common.Gun;
import com.tac.guns.common.SpreadTracker;
import com.tac.guns.common.WeaponType;
import com.tac.guns.entity.DamageSourceExplosion;
import com.tac.guns.entity.DamageSourceProjectile;
import com.tac.guns.entity.IExplosionProvider;
import com.tac.guns.event.GunProjectileHitEvent;
import com.tac.guns.event.LevelUpEvent;
import com.tac.guns.init.ModEffects;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.init.ModTags;
import com.tac.guns.interfaces.IExplosionDamageable;
import com.tac.guns.interfaces.IHeadshotBox;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageBlood;
import com.tac.guns.network.message.MessageProjectileHitBlock;
import com.tac.guns.network.message.MessageProjectileHitEntity;
import com.tac.guns.network.message.MessageRemoveProjectile;
import com.tac.guns.util.BufferUtil;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.math.ExtendedEntityRayTraceResult;
import com.tac.guns.world.ProjectileExplosion;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ProjectileEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && input.func_70067_L() && !input.func_175149_v();
    protected int shooterId;
    protected LivingEntity shooter;
    protected Gun modifiedGun;
    protected Gun.General general;
    protected Gun.Projectile projectile;
    protected Gun.AmmoPlugEffect ammoPlugEffect;
    private ItemStack weapon = ItemStack.field_190927_a;
    private ItemStack item = ItemStack.field_190927_a;
    protected float additionalDamage = 0.0f;
    protected EntitySize entitySize;
    protected double modifiedGravity;
    public int life;
    protected int pierce;
    protected Vector3d startPos;
    protected boolean sgHE = false;
    protected int fmjLevel = -1;
    protected int heLevel = -1;
    protected int hpLevel = -1;
    protected int iLevel = -1;
    protected double speed = 1.0;

    public ProjectileEntity(EntityType<? extends Entity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    public ProjectileEntity(EntityType<? extends Entity> entityType, World worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun, float randP, float randY) {
        this(entityType, worldIn);
        this.shooterId = shooter.func_145782_y();
        this.shooter = shooter;
        this.modifiedGun = modifiedGun;
        this.general = modifiedGun.getGeneral();
        this.projectile = modifiedGun.getProjectile();
        this.ammoPlugEffect = modifiedGun.getAmmoPlugEffect();
        this.entitySize = new EntitySize(this.projectile.getSize(), this.projectile.getSize(), false);
        this.modifiedGravity = modifiedGun.getProjectile().isGravity() ? GunModifierHelper.getModifiedProjectileGravity(weapon, -0.0285) : 0.0;
        this.pierce = Math.max(modifiedGun.getProjectile().getPierce() + GunModifierHelper.getAdditionalPierce(weapon), 1);
        this.sgHE = modifiedGun.getDisplay().getWeaponType() == WeaponType.SG && (this.projectile.isHasBlastDamage() || GunModifierHelper.getHeWeight(weapon) > -1);
        this.life = this.sgHE ? GunModifierHelper.getModifiedProjectileLife(weapon, this.projectile.getLife() * 2) : GunModifierHelper.getModifiedProjectileLife(weapon, this.projectile.getLife());
        this.fmjLevel = GunModifierHelper.getFmjWeight(weapon);
        this.heLevel = GunModifierHelper.getHeWeight(weapon);
        this.hpLevel = GunModifierHelper.getHpWeight(weapon);
        this.iLevel = GunModifierHelper.getIWeight(weapon);
        Vector3d dir = this.getDirection(shooter, weapon, item, modifiedGun);
        double speedModifier = GunEnchantmentHelper.getProjectileSpeedModifier(weapon);
        speedModifier = GunModifierHelper.getAmmoModifySpeed(weapon, modifiedGun, speedModifier);
        ItemStack gunStack = this.shooter.func_184614_ca();
        int[] levelSpeed = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10};
        float modifySpeed = 1.0f;
        if (gunStack.func_77978_p() != null && gunStack.func_77978_p().func_74781_a("level") != null && !gunStack.func_77978_p().func_74767_n("levelLock")) {
            modifySpeed = (float)((double)modifySpeed * ((100.0 + (double)levelSpeed[gunStack.func_77978_p().func_74762_e("level") - 1]) / 100.0));
        }
        this.speed = GunModifierHelper.getModifiedProjectileSpeed(weapon, this.projectile.getSpeed() * (speedModifier *= (double)modifySpeed));
        this.func_213293_j(dir.field_72450_a * this.speed, dir.field_72448_b * this.speed, dir.field_72449_c * this.speed);
        this.updateHeading();
        double posX = shooter.field_70142_S + (shooter.func_226277_ct_() - shooter.field_70142_S) / 2.0;
        double posY = shooter.field_70137_T + (shooter.func_226278_cu_() - shooter.field_70137_T) / 2.0 + (double)shooter.func_70047_e();
        double posZ = shooter.field_70136_U + (shooter.func_226281_cx_() - shooter.field_70136_U) / 2.0;
        this.func_70107_b(posX, posY, posZ);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(this.projectile.getItem());
        if (ammo != null) {
            ItemStack model;
            int customModelData = -1;
            if (weapon.func_77978_p() != null && weapon.func_77978_p().func_150297_b("Model", 10) && (model = ItemStack.func_199557_a((CompoundNBT)weapon.func_77978_p().func_74775_l("Model"))).func_77978_p() != null && model.func_77978_p().func_74764_b("CustomModelData")) {
                customModelData = model.func_77978_p().func_74762_e("CustomModelData");
            }
            ItemStack ammoStack = new ItemStack((IItemProvider)ammo);
            if (customModelData != -1) {
                ammoStack.func_196082_o().func_74768_a("CustomModelData", customModelData);
            }
            this.item = ammoStack;
        }
    }

    protected void func_70088_a() {
    }

    public EntitySize func_213305_a(Pose pose) {
        return this.entitySize;
    }

    private Vector3d getDirection(LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        float gunSpread = this.sgHE ? GunModifierHelper.getModifiedSpread(weapon, modifiedGun.getGeneral().getSpreadHE()) * GunEnchantmentHelper.getSpreadModifier(weapon) : GunModifierHelper.getModifiedSpread(weapon, modifiedGun.getGeneral().getSpread()) * GunEnchantmentHelper.getSpreadModifier(weapon);
        if (gunSpread == 0.0f) {
            return this.getVectorFromRotation(shooter.field_70125_A, shooter.field_70177_z);
        }
        if (shooter instanceof PlayerEntity) {
            AimingManager.AimTracker tracker;
            if (!modifiedGun.getGeneral().isAlwaysSpread()) {
                float modSpread = SpreadTracker.get((PlayerEntity)shooter).getSpread(item);
                if (modSpread != 0.0f) {
                    gunSpread *= SpreadTracker.get((PlayerEntity)shooter).getSpread(item);
                } else {
                    gunSpread = this.sgHE ? modifiedGun.getGeneral().getFirstShotSpreadHE() : modifiedGun.getGeneral().getFirstShotSpread();
                    gunSpread = GunModifierHelper.getModifiedFirstShotSpread(weapon, gunSpread);
                }
            }
            if ((tracker = AimingManager.get().getAimTracker((PlayerEntity)shooter)) == null || tracker.getLerpProgress() < (double)0.95f) {
                if ((double)gunSpread < 0.5) {
                    gunSpread += 0.5f;
                }
                ItemStack gunStack = this.shooter.func_184614_ca();
                int[] levelHipFire = new int[]{0, 2, 4, 6, 9, 11, 12, 13, 14, 15};
                float modifySpread = 1.0f;
                if (gunStack.func_77978_p() != null && gunStack.func_77978_p().func_74781_a("level") != null && !gunStack.func_77978_p().func_74767_n("levelLock")) {
                    modifySpread = (float)((double)modifySpread * ((100.0 - (double)levelHipFire[gunStack.func_77978_p().func_74762_e("level") - 1]) / 100.0));
                }
                gunSpread = this.sgHE ? (gunSpread *= modifiedGun.getGeneral().getHipFireInaccuracyHE()) : (gunSpread *= modifiedGun.getGeneral().getHipFireInaccuracy());
                gunSpread = GunModifierHelper.getModifiedHipFireSpread(weapon, gunSpread * modifySpread);
                if (((Float)SyncedPlayerData.instance().get((PlayerEntity)shooter, ModSyncedDataKeys.MOVING)).floatValue() != 0.0f) {
                    gunSpread = this.sgHE ? (gunSpread *= Math.max(1.0f, 2.0f * (1.0f + ((Float)SyncedPlayerData.instance().get((PlayerEntity)shooter, ModSyncedDataKeys.MOVING)).floatValue()) * modifiedGun.getGeneral().getMovementInaccuracyHE())) : (gunSpread *= Math.max(1.0f, 2.0f * (1.0f + ((Float)SyncedPlayerData.instance().get((PlayerEntity)shooter, ModSyncedDataKeys.MOVING)).floatValue()) * modifiedGun.getGeneral().getMovementInaccuracy()));
                }
            }
            if (((PlayerEntity)shooter).func_213453_ef() && (modifiedGun.getGeneral().getProjectileAmount() == 1 || this.sgHE)) {
                gunSpread = (float)((double)gunSpread * (Double)Config.SERVER.gameplay.duckSpreadPercent.get());
            }
        }
        return this.getVectorFromRotation(shooter.field_70125_A - gunSpread / 2.0f + this.field_70146_Z.nextFloat() * gunSpread, shooter.field_70177_z - gunSpread / 2.0f + this.field_70146_Z.nextFloat() * gunSpread);
    }

    public void setWeapon(ItemStack weapon) {
        this.weapon = weapon.func_77946_l();
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setAdditionalDamage(float additionalDamage) {
        this.additionalDamage = additionalDamage;
    }

    public double getModifiedGravity() {
        return this.modifiedGravity;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateHeading();
        this.onProjectileTick();
        if (!this.field_70170_p.func_201670_d()) {
            Vector3d endVec;
            Object result;
            Vector3d startVec = this.func_213303_ch();
            if (this.field_70173_aa < 1) {
                this.startPos = startVec;
            }
            if ((result = ProjectileEntity.rayTraceBlocks(this.field_70170_p, new RayTraceContext(startVec, endVec = startVec.func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this))).func_216346_c() != RayTraceResult.Type.MISS) {
                endVec = result.func_216347_e();
            }
            List<EntityResult> hitEntities = null;
            if (this.pierce <= 1 || this.projectile.isHasBlastDamage() || this.heLevel > -1) {
                EntityResult entityResult = this.findEntityOnPath(startVec, endVec);
                if (entityResult != null) {
                    hitEntities = Collections.singletonList(entityResult);
                }
            } else {
                hitEntities = this.findEntitiesOnPath(startVec, endVec);
            }
            if (hitEntities != null && hitEntities.size() > 0) {
                EntityResult[] hitEntityResult = hitEntities.toArray(new EntityResult[0]);
                for (int i = 0; i < hitEntityResult.length - 1; ++i) {
                    int k = i;
                    for (int j = i + 1; j < hitEntityResult.length; ++j) {
                        if (!(hitEntityResult[j].hitVec.func_72438_d(startVec) < hitEntityResult[k].hitVec.func_72438_d(startVec))) continue;
                        k = j;
                    }
                    EntityResult t = hitEntityResult[i];
                    hitEntityResult[i] = hitEntityResult[k];
                    hitEntityResult[k] = t;
                }
                for (EntityResult entityResult : hitEntityResult) {
                    result = new ExtendedEntityRayTraceResult(entityResult);
                    if (((EntityRayTraceResult)result).func_216348_a() instanceof PlayerEntity) {
                        PlayerEntity player = (PlayerEntity)((EntityRayTraceResult)result).func_216348_a();
                        if (this.shooter instanceof PlayerEntity && !((PlayerEntity)this.shooter).func_96122_a(player) && !((Boolean)Config.SERVER.development.bulletSelfHarm.get()).booleanValue()) {
                            result = null;
                        }
                    }
                    if (result == null || !((EntityRayTraceResult)result).func_216348_a().func_70089_S()) continue;
                    this.onHit((RayTraceResult)result, startVec, endVec);
                }
            } else {
                this.onHit((RayTraceResult)result, startVec, endVec);
            }
        }
        double nextPosX = this.func_226277_ct_() + this.func_213322_ci().func_82615_a();
        double nextPosY = this.func_226278_cu_() + this.func_213322_ci().func_82617_b();
        double nextPosZ = this.func_226281_cx_() + this.func_213322_ci().func_82616_c();
        this.func_70107_b(nextPosX, nextPosY, nextPosZ);
        if (this.projectile.isGravity()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, this.modifiedGravity, 0.0));
        }
        if (this.field_70173_aa >= this.life) {
            if (this.func_70089_S()) {
                this.onExpired();
            }
            this.func_70106_y();
        }
    }

    protected void onProjectileTick() {
    }

    protected void onExpired() {
    }

    @Nullable
    protected EntityResult findEntityOnPath(Vector3d startVec, Vector3d endVec) {
        Vector3d hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        List entities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            EntityResult result;
            if (entity.equals((Object)this.shooter) && !((Boolean)Config.SERVER.development.bulletSelfHarm.get()).booleanValue() || (result = this.getHitResult(entity, startVec, endVec)) == null) continue;
            Vector3d hitPos = result.getHitPos();
            double distanceToHit = startVec.func_72438_d(hitPos);
            if (!entity.func_70089_S() || !(distanceToHit < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
        }
        return hitEntity != null ? new EntityResult(hitEntity, hitVec, headshot) : null;
    }

    @Nullable
    protected List<EntityResult> findEntitiesOnPath(Vector3d startVec, Vector3d endVec) {
        ArrayList<EntityResult> hitEntities = new ArrayList<EntityResult>();
        List entities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            EntityResult result;
            if (entity.equals((Object)this.shooter) && !((Boolean)Config.SERVER.development.bulletSelfHarm.get()).booleanValue() || (result = this.getHitResult(entity, startVec, endVec)) == null || !entity.func_70089_S()) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Nullable
    private EntityResult getHitResult(Entity entity, Vector3d startVec, Vector3d endVec) {
        AxisAlignedBB box;
        IHeadshotBox<LivingEntity> headshotBox;
        double expandHeight = entity instanceof PlayerEntity && !entity.func_213453_ef() ? 0.0625 : 0.0;
        AxisAlignedBB boundingBox = entity.func_174813_aQ();
        if (((Boolean)Config.SERVER.gameplay.improvedHitboxes.get()).booleanValue() && entity instanceof ServerPlayerEntity && this.shooter != null) {
            int ping = (int)Math.floor((double)((ServerPlayerEntity)this.shooter).field_71138_i / 1000.0 * 20.0 + 0.5);
            boundingBox = BoundingBoxManager.getBoundingBox((PlayerEntity)entity, ping);
        }
        boundingBox = boundingBox.func_72321_a(0.0, expandHeight, 0.0);
        Vector3d velocity = entity.func_184187_bx() != null ? entity.func_184187_bx().func_213322_ci() : entity.func_213322_ci();
        boundingBox = boundingBox.func_191194_a(velocity.func_216372_d(-1.0, -1.0, -1.0));
        boundingBox = boundingBox.func_216361_a(velocity.func_216372_d(-1.0, -1.0, -1.0));
        Vector3d hitPos = boundingBox.func_216365_b(startVec, endVec).orElse(null);
        Vector3d grownHitPos = boundingBox.func_72314_b(((Double)Config.SERVER.gameplay.growBoundingBoxAmountV2.get()).doubleValue(), 0.0, ((Double)Config.SERVER.gameplay.growBoundingBoxAmountV2.get()).doubleValue()).func_216365_b(startVec, endVec).orElse(null);
        if (hitPos == null && grownHitPos != null) {
            BlockRayTraceResult raytraceresult = ProjectileEntity.rayTraceBlocks(this.field_70170_p, new RayTraceContext(startVec, grownHitPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                return null;
            }
            hitPos = grownHitPos;
        }
        boolean headshot = false;
        if (((Boolean)Config.SERVER.gameplay.enableHeadShots.get()).booleanValue() && entity instanceof LivingEntity && (headshotBox = BoundingBoxManager.getHeadshotBoxes(entity.func_200600_R())) != null && (box = headshotBox.getHeadshotBox((LivingEntity)entity)) != null) {
            Optional headshotHitPos = (box = box.func_72317_d(boundingBox.func_189972_c().field_72450_a, boundingBox.field_72338_b, boundingBox.func_189972_c().field_72449_c)).func_216365_b(startVec, endVec);
            if (!headshotHitPos.isPresent()) {
                box = box.func_72314_b(((Double)Config.SERVER.gameplay.growBoundingBoxAmountV2.get()).doubleValue(), 0.0, ((Double)Config.SERVER.gameplay.growBoundingBoxAmountV2.get()).doubleValue());
                headshotHitPos = box.func_216365_b(startVec, endVec);
            }
            if (headshotHitPos.isPresent() && (hitPos == null || ((Vector3d)headshotHitPos.get()).func_72438_d(hitPos) < 0.5)) {
                hitPos = (Vector3d)headshotHitPos.get();
                headshot = true;
            }
        }
        if (hitPos == null) {
            return null;
        }
        return new EntityResult(entity, hitPos, headshot);
    }

    private void onHit(RayTraceResult result, Vector3d startVec, Vector3d endVec) {
        if (this.pierce <= 0) {
            this.func_70106_y();
            return;
        }
        if (this.modifiedGun == null) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new GunProjectileHitEvent(result, this))) {
            return;
        }
        if (result instanceof BlockRayTraceResult) {
            BlockPos offsetPos;
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)result;
            if (blockRayTraceResult.func_216346_c() == RayTraceResult.Type.MISS) {
                return;
            }
            Vector3d hitVec = result.func_216347_e();
            BlockPos pos = blockRayTraceResult.func_216350_a();
            BlockState state = this.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!state.func_185904_a().func_76222_j()) {
                this.func_70106_y();
            }
            if (Objects.requireNonNull(block.getRegistryName()).func_110623_a().contains("_button")) {
                return;
            }
            if (((Boolean)Config.SERVER.gameplay.enableGunGriefing.get()).booleanValue() && (block instanceof BreakableBlock || block instanceof PaneBlock) && state.func_185904_a() == Material.field_151592_s) {
                this.field_70170_p.func_225521_a_(blockRayTraceResult.func_216350_a(), false, (Entity)this.shooter);
            }
            this.onHitBlock(state, pos, blockRayTraceResult.func_216354_b(), hitVec);
            if (block instanceof BellBlock) {
                BellBlock bell = (BellBlock)block;
                bell.func_226884_a_(this.field_70170_p, state, blockRayTraceResult, (PlayerEntity)this.shooter, true);
            }
            if (this.iLevel > -1 && ((Boolean)Config.SERVER.gameplay.fireStarterCauseFire.get()).booleanValue() && AbstractFireBlock.func_241465_a_((World)this.field_70170_p, (BlockPos)(offsetPos = pos.func_177972_a(blockRayTraceResult.func_216354_b())), (Direction)blockRayTraceResult.func_216354_b())) {
                BlockState fireState = AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)offsetPos);
                this.field_70170_p.func_180501_a(offsetPos, fireState, 11);
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197595_F, hitVec.field_72450_a - 1.0 + this.field_70146_Z.nextDouble() * 2.0, hitVec.field_72448_b, hitVec.field_72449_c - 1.0 + this.field_70146_Z.nextDouble() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
            }
            return;
        }
        if (result instanceof ExtendedEntityRayTraceResult) {
            ExtendedEntityRayTraceResult entityRayTraceResult = (ExtendedEntityRayTraceResult)result;
            Entity entity = entityRayTraceResult.func_216348_a();
            if (entity.func_145782_y() == this.shooterId && !((Boolean)Config.SERVER.development.bulletSelfHarm.get()).booleanValue()) {
                return;
            }
            if (entity instanceof LivingEntity && this.iLevel > -1) {
                int fireDuration = this.ammoPlugEffect.getIgniteTick()[this.iLevel];
                fireDuration = ProtectionEnchantment.func_92093_a((LivingEntity)((LivingEntity)entity), (int)fireDuration);
                ((LivingEntity)entity).func_195064_c(new EffectInstance((Effect)ModEffects.IGNITE.get(), fireDuration, this.ammoPlugEffect.getIgniteDamage()[this.iLevel]));
            }
            if (!entity.func_70089_S()) {
                entity.field_70172_ad = 0;
            } else if (entity.func_70089_S()) {
                this.onHitEntity(entity, result.func_216347_e(), startVec, endVec, entityRayTraceResult.isHeadshot());
                entity.field_70172_ad = 0;
            }
        }
    }

    protected void onHitEntity(Entity entity, Vector3d hitVec, Vector3d startVec, Vector3d endVec, boolean headshot) {
        float newDamage;
        if (this.pierce <= 0) {
            this.func_70106_y();
            return;
        }
        float damage = this.getDamage(hitVec);
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.weapon, this.field_70146_Z, damage));
        damage = newDamage;
        if (headshot) {
            if ((Double)Config.SERVER.gameplay.headShotDamageMultiplier.get() * (double)this.projectile.getGunHeadDamage() >= 0.0) {
                damage *= (float)((Double)Config.SERVER.gameplay.headShotDamageMultiplier.get() * (double)this.projectile.getGunHeadDamage());
            }
            damage += GunModifierHelper.getAdditionalHeadshotDamage(this.weapon) == 0.0f ? 1.0f : GunModifierHelper.getAdditionalHeadshotDamage(this.weapon);
        }
        DamageSource source = new DamageSourceProjectile("bullet", this, (Entity)this.shooter, this.weapon, headshot).func_76349_b();
        if (entity instanceof PlayerEntity && !((Boolean)Config.SERVER.gameplay.gunOfKindnessToPlayer.get()).booleanValue()) {
            this.tac_attackEntity(source, entity, damage);
        } else if (!((Boolean)Config.SERVER.gameplay.gunOfKindness.get()).booleanValue()) {
            this.tac_attackEntity(source, entity, damage);
        }
        if (this.shooter instanceof PlayerEntity) {
            int hitType = critical ? 2 : (headshot ? 1 : 0);
            this.updateWeaponLevels(damage);
            PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.shooter), (Object)new MessageProjectileHitEntity(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, hitType, entity instanceof PlayerEntity));
        }
        if (this.projectile.isHasBlastDamage()) {
            ProjectileEntity.createExplosion(this, GunModifierHelper.getModifiedProjectileBlastDamage(this.weapon, this.projectile.getBlastDamage()) + this.projectile.getDamage(), this.projectile.getBlastRadius(), hitVec);
            this.func_70106_y();
        } else if (this.heLevel > -1) {
            ProjectileEntity.createExplosion(this, GunModifierHelper.getModifiedProjectileBlastDamage(this.weapon, this.projectile.getBlastDamage() * ((float)this.ammoPlugEffect.getHeModifyBlastDamage()[this.heLevel] / 100.0f)) + this.projectile.getDamage(), this.projectile.getBlastRadius() * ((float)this.ammoPlugEffect.getHeModifyBlastRange()[this.heLevel] / 100.0f), hitVec);
            this.func_70106_y();
        }
        PacketHandler.getPlayChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new MessageBlood(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c));
    }

    private void tac_attackWithBluntDamage(DamageSource source, Entity entity, float damage) {
        entity.func_70097_a(source, damage * this.modifiedGun.getProjectile().getBluntDamagePercentage());
    }

    private void tac_attackEntity(DamageSource source, Entity entity, float damage) {
        --this.pierce;
        if (((Boolean)Config.SERVER.gameplay.bulletsIgnoreStandardArmor.get()).booleanValue()) {
            float damageToMcArmor = 0.0f;
            float modifyIgnore = this.projectile.getGunArmorIgnore();
            modifyIgnore = GunModifierHelper.getAmmoModifyArmorIgnore(this.weapon, this.modifiedGun, modifyIgnore);
            float armorIgnore = GunModifierHelper.getModifiedProjectileArmorIgnore(this.weapon, (float)((Double)Config.SERVER.gameplay.percentDamageIgnoresStandardArmor.get() * (double)modifyIgnore));
            if ((double)armorIgnore <= 1.0) {
                damageToMcArmor = damage * (1.0f - armorIgnore);
            }
            if ((double)armorIgnore <= 0.0) {
                damageToMcArmor = damage;
            }
            entity.func_70097_a(source, damageToMcArmor);
            entity.field_70172_ad = 0;
            source.func_76348_h();
            source.func_151518_m();
            entity.func_70097_a(source, damage - damageToMcArmor);
        } else {
            entity.func_70097_a(source, damage);
        }
    }

    protected void updateWeaponLevels(float damage) {
        ItemStack gunStack = this.shooter.func_184614_ca();
        if (!(gunStack.func_77973_b() instanceof GunItem) || gunStack.func_77978_p() == null) {
            return;
        }
        if (((Boolean)Config.SERVER.gameplay.lockGunLevel.get()).booleanValue()) {
            return;
        }
        if (gunStack.func_77978_p().func_74781_a("levelLock") != null && gunStack.func_77978_p().func_74767_n("levelLock")) {
            return;
        }
        if (gunStack.func_77978_p().func_74781_a("levelDmg") != null) {
            gunStack.func_77978_p().func_74776_a("levelDmg", gunStack.func_77978_p().func_74760_g("levelDmg") + damage);
        }
        if (gunStack.func_77978_p().func_74781_a("level") != null) {
            if (gunStack.func_77978_p().func_74762_e("level") >= 10) {
                gunStack.func_77978_p().func_74776_a("levelDmg", 0.0f);
            }
            TimelessGunItem gunItem = (TimelessGunItem)gunStack.func_77973_b();
            if ((double)gunStack.func_77978_p().func_74760_g("levelDmg") > (double)gunItem.getGun().getGeneral().getLevelReq() * ((double)gunStack.func_77978_p().func_74762_e("level") * 3.0)) {
                gunStack.func_77978_p().func_74776_a("levelDmg", 0.0f);
                gunStack.func_77978_p().func_74768_a("level", gunStack.func_77978_p().func_74762_e("level") + 1);
                MinecraftForge.EVENT_BUS.post((Event)new LevelUpEvent.Post((PlayerEntity)this.shooter, gunStack));
            }
        }
    }

    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, Vector3d hitVec) {
        if (this.pierce <= 0) {
            this.func_70106_y();
            return;
        }
        PacketHandler.getPlayChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_70170_p.func_175726_f(pos)), (Object)new MessageProjectileHitBlock(hitVec.func_82615_a(), hitVec.func_82617_b(), hitVec.func_82616_c(), pos, face, this.projectile.isHasBlastDamage()));
        if (this.iLevel > -1) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197595_F, hitVec.func_82615_a(), hitVec.func_82617_b(), hitVec.func_82616_c(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.projectile.isHasBlastDamage()) {
            ProjectileEntity.createExplosion(this, GunModifierHelper.getModifiedProjectileBlastDamage(this.weapon, this.projectile.getBlastDamage()), this.projectile.getBlastRadius(), hitVec);
            this.func_70106_y();
        } else if (this.heLevel > -1) {
            ProjectileEntity.createExplosion(this, GunModifierHelper.getModifiedProjectileBlastDamage(this.weapon, this.projectile.getBlastDamage() * ((float)this.ammoPlugEffect.getHeModifyBlastRange()[this.heLevel] / 100.0f)), this.projectile.getBlastRadius() * ((float)this.ammoPlugEffect.getHeModifyBlastRange()[this.heLevel] / 100.0f), hitVec);
            this.func_70106_y();
        }
    }

    protected void teleportToHitPoint(RayTraceResult rayTraceResult) {
        Vector3d hitResult = rayTraceResult.func_216347_e();
        this.func_70107_b(hitResult.field_72450_a, hitResult.field_72448_b, hitResult.field_72449_c);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.projectile = new Gun.Projectile();
        this.projectile.deserializeNBT(compound.func_74775_l("Projectile"));
        this.general = new Gun.General();
        this.general.deserializeNBT(compound.func_74775_l("General"));
        this.modifiedGravity = compound.func_74769_h("ModifiedGravity");
        this.life = compound.func_74762_e("MaxLife");
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("Projectile", (INBT)this.projectile.serializeNBT());
        compound.func_218657_a("General", (INBT)this.general.serializeNBT());
        compound.func_74780_a("ModifiedGravity", this.modifiedGravity);
        compound.func_74768_a("MaxLife", this.life);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150786_a(this.projectile.serializeNBT());
        buffer.func_150786_a(this.general.serializeNBT());
        buffer.writeInt(this.shooterId);
        BufferUtil.writeItemStackToBufIgnoreTag((ByteBuf)buffer, this.item);
        buffer.writeDouble(this.modifiedGravity);
        buffer.func_150787_b(this.life);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.projectile = new Gun.Projectile();
        this.projectile.deserializeNBT(Objects.requireNonNull(buffer.func_150793_b()));
        this.general = new Gun.General();
        this.general.deserializeNBT(Objects.requireNonNull(buffer.func_150793_b()));
        this.shooterId = buffer.readInt();
        this.item = BufferUtil.readItemStackFromBufIgnoreTag((ByteBuf)buffer);
        this.modifiedGravity = buffer.readDouble();
        this.life = buffer.func_150792_a();
        this.entitySize = new EntitySize(this.projectile.getSize(), this.projectile.getSize(), false);
    }

    public void updateHeading() {
        float f = MathHelper.func_76133_a((double)(this.func_213322_ci().func_82615_a() * this.func_213322_ci().func_82615_a() + this.func_213322_ci().func_82616_c() * this.func_213322_ci().func_82616_c()));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().func_82615_a(), (double)this.func_213322_ci().func_82616_c()) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().func_82617_b(), (double)f) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public Gun.Projectile getProjectile() {
        return this.projectile;
    }

    private Vector3d getVectorFromRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vector3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public LivingEntity getShooter() {
        return this.shooter;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    public float getDamage(Vector3d hitVec) {
        float initialDamage = this.projectile.getDamage() + this.additionalDamage;
        double maxDistance = (double)this.projectile.getLife() * this.speed;
        double projDistance = hitVec.func_72438_d(this.startPos);
        if (this.projectile.isDamageReduceOverLife()) {
            float modifier;
            if (projDistance <= Math.min(Math.min(this.speed / 5.0, maxDistance / 40.0), 4.0)) {
                modifier = this.projectile.getGunCloseDamage() > 1.0f ? this.projectile.getGunCloseDamage() : 1.0f;
            } else {
                float minDecayMultiplier;
                float decayEndDistance;
                float decayStartDistance;
                if (this.projectile.getGunDecayStart() > this.projectile.getGunDecayEnd() && this.projectile.getGunMinDecayMultiplier() > 1.0f) {
                    decayStartDistance = (float)((double)MathHelper.func_76131_a((float)this.projectile.getGunDecayEnd(), (float)0.0f, (float)1.0f) * maxDistance);
                    decayEndDistance = (float)((double)MathHelper.func_76131_a((float)this.projectile.getGunDecayStart(), (float)0.0f, (float)1.0f) * maxDistance);
                    minDecayMultiplier = this.projectile.getGunMinDecayMultiplier();
                } else {
                    if (this.projectile.getGunDecayStart() > this.projectile.getGunDecayEnd()) {
                        decayStartDistance = (float)((double)MathHelper.func_76131_a((float)this.projectile.getGunDecayEnd(), (float)0.0f, (float)1.0f) * maxDistance);
                        decayEndDistance = (float)((double)MathHelper.func_76131_a((float)this.projectile.getGunDecayStart(), (float)0.0f, (float)1.0f) * maxDistance);
                    } else {
                        decayStartDistance = (float)((double)MathHelper.func_76131_a((float)this.projectile.getGunDecayStart(), (float)0.0f, (float)1.0f) * maxDistance);
                        decayEndDistance = (float)((double)MathHelper.func_76131_a((float)this.projectile.getGunDecayEnd(), (float)0.0f, (float)1.0f) * maxDistance);
                    }
                    minDecayMultiplier = MathHelper.func_76131_a((float)this.projectile.getGunMinDecayMultiplier(), (float)0.0f, (float)1.0f);
                }
                modifier = decayStartDistance == decayEndDistance ? (projDistance > (double)decayEndDistance ? minDecayMultiplier : 1.0f) : (float)MathHelper.func_151237_a((double)((projDistance - (double)decayEndDistance) * (double)(1.0f - minDecayMultiplier) / (double)(decayStartDistance - decayEndDistance) + (double)minDecayMultiplier), (double)Math.min(minDecayMultiplier, 1.0f), (double)Math.max(minDecayMultiplier, 1.0f));
            }
            initialDamage *= modifier;
        }
        float damage = this.sgHE ? initialDamage : initialDamage / (float)this.general.getProjectileAmount();
        damage = GunModifierHelper.getModifiedDamage(this.weapon, this.modifiedGun, damage);
        damage = GunEnchantmentHelper.getAcceleratorDamage(this.weapon, damage);
        damage = GunModifierHelper.getAmmoModifyDamage(this.weapon, this.modifiedGun, damage);
        ItemStack gunStack = this.shooter.func_184614_ca();
        int[] levelModifyDamage = new int[]{0, 0, 0, 0, 10, 10, 10, 20, 20, 20};
        int[] levelAdditionalDamage = new int[]{0, 0, 0, 0, 1, 1, 1, 2, 2, 2};
        float modifyDamage = 1.0f;
        float additionalDamage = 0.0f;
        if (gunStack.func_77978_p() != null && gunStack.func_77978_p().func_74781_a("level") != null && !gunStack.func_77978_p().func_74767_n("levelLock")) {
            modifyDamage = (float)((double)modifyDamage * ((100.0 + (double)levelModifyDamage[gunStack.func_77978_p().func_74762_e("level") - 1]) / 100.0));
            additionalDamage += (float)levelAdditionalDamage[gunStack.func_77978_p().func_74762_e("level") - 1];
        }
        if (damage * modifyDamage <= damage + additionalDamage) {
            return Math.max(0.0f, damage * modifyDamage);
        }
        return Math.max(0.0f, damage + additionalDamage);
    }

    public float getDamage() {
        float initialDamage = this.projectile.getDamage() + this.additionalDamage;
        if (this.projectile.isDamageReduceOverLife()) {
            float modifier = ((float)this.projectile.getLife() - (float)(this.field_70173_aa - 1)) / (float)this.projectile.getLife();
            initialDamage *= modifier;
        }
        float damage = this.sgHE ? initialDamage : initialDamage / (float)this.general.getProjectileAmount();
        damage = GunModifierHelper.getModifiedDamage(this.weapon, this.modifiedGun, damage);
        damage = GunEnchantmentHelper.getAcceleratorDamage(this.weapon, damage);
        damage = GunModifierHelper.getAmmoModifyDamage(this.weapon, this.modifiedGun, damage);
        ItemStack gunStack = this.shooter.func_184614_ca();
        int[] levelModifyDamage = new int[]{0, 0, 0, 0, 10, 10, 10, 20, 20, 20};
        int[] levelAdditionalDamage = new int[]{0, 0, 0, 0, 1, 1, 1, 2, 2, 2};
        float modifyDamage = 1.0f;
        float additionalDamage = 0.0f;
        if (gunStack.func_77978_p() != null && gunStack.func_77978_p().func_74781_a("level") != null && !gunStack.func_77978_p().func_74767_n("levelLock")) {
            modifyDamage = (float)((double)modifyDamage * ((100.0 + (double)levelModifyDamage[gunStack.func_77978_p().func_74762_e("level") - 1]) / 100.0));
            additionalDamage += (float)levelAdditionalDamage[gunStack.func_77978_p().func_74762_e("level") - 1];
        }
        if (damage * modifyDamage <= damage + additionalDamage) {
            return Math.max(0.0f, damage * modifyDamage);
        }
        return Math.max(0.0f, damage + additionalDamage);
    }

    public float getRadius() {
        if (this.heLevel > -1) {
            return Math.max(0.0f, this.projectile.getBlastRadius() * ((float)this.ammoPlugEffect.getHeModifyBlastRange()[this.heLevel] / 100.0f));
        }
        return Math.max(0.0f, this.projectile.getBlastRadius());
    }

    private float getCriticalDamage(ItemStack weapon, Random rand, float damage) {
        float chance = GunModifierHelper.getCriticalChance(weapon) + this.projectile.getGunCritical();
        ItemStack gunStack = this.shooter.func_184614_ca();
        int[] levelChance = new int[]{0, 0, 0, 0, 5, 5, 5, 5, 5, 10};
        float additionalChance = 0.0f;
        if (gunStack.func_77978_p() != null && gunStack.func_77978_p().func_74781_a("level") != null && !gunStack.func_77978_p().func_74767_n("levelLock")) {
            additionalChance = (float)((double)additionalChance + (double)levelChance[gunStack.func_77978_p().func_74762_e("level") - 1] / 100.0);
        }
        chance += additionalChance;
        if (rand.nextFloat() < chance && (Double)Config.SERVER.gameplay.criticalDamageMultiplier.get() * (double)this.projectile.getGunCriticalDamage() >= 0.0) {
            int[] levelDamage = new int[]{0, 0, 0, 0, 0, 0, 0, 5, 5, 15};
            float modifyDamage = 1.0f;
            if (gunStack.func_77978_p() != null && gunStack.func_77978_p().func_74781_a("level") != null && !gunStack.func_77978_p().func_74767_n("levelLock")) {
                modifyDamage = (float)((double)modifyDamage * ((100.0 + (double)levelDamage[gunStack.func_77978_p().func_74762_e("level") - 1]) / 100.0));
            }
            return (float)((double)damage * (Double)Config.SERVER.gameplay.criticalDamageMultiplier.get() * (double)this.projectile.getGunCriticalDamage() * (double)modifyDamage);
        }
        return damage;
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public void onRemovedFromWorld() {
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(this::getDeathTargetPoint), (Object)new MessageRemoveProjectile(this.func_145782_y()));
        }
    }

    private PacketDistributor.TargetPoint getDeathTargetPoint() {
        return new PacketDistributor.TargetPoint(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 256.0, this.field_70170_p.func_234923_W_());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static BlockRayTraceResult rayTraceBlocksPassThrough(World world, RayTraceContext context, Predicate<BlockState> ignorePredicate) {
        return ProjectileEntity.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.func_180495_p(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            return ProjectileEntity.getBlockRayTraceResult(world, rayTraceContext, blockPos, blockState);
        }, rayTraceContext -> {
            Vector3d Vector3d2 = rayTraceContext.func_222253_b().func_178788_d(rayTraceContext.func_222250_a());
            return BlockRayTraceResult.func_216352_a((Vector3d)rayTraceContext.func_222250_a(), (Direction)Direction.func_210769_a((double)Vector3d2.field_72450_a, (double)Vector3d2.field_72448_b, (double)Vector3d2.field_72449_c), (BlockPos)new BlockPos(rayTraceContext.func_222250_a()));
        });
    }

    private static BlockRayTraceResult rayTraceBlocks(World world, RayTraceContext context) {
        return ProjectileEntity.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            boolean pass = block.func_203417_a(ModTags.bullet_ignore);
            if (pass) {
                return null;
            }
            return ProjectileEntity.getBlockRayTraceResult(world, rayTraceContext, blockPos, blockState);
        }, rayTraceContext -> {
            Vector3d Vector3d2 = rayTraceContext.func_222253_b().func_178788_d(rayTraceContext.func_222250_a());
            return BlockRayTraceResult.func_216352_a((Vector3d)rayTraceContext.func_222250_a(), (Direction)Direction.func_210769_a((double)Vector3d2.field_72450_a, (double)Vector3d2.field_72448_b, (double)Vector3d2.field_72449_c), (BlockPos)new BlockPos(rayTraceContext.func_222250_a()));
        });
    }

    @Nullable
    private static BlockRayTraceResult getBlockRayTraceResult(World world, RayTraceContext rayTraceContext, BlockPos blockPos, BlockState blockState) {
        FluidState fluidState = world.func_204610_c(blockPos);
        Vector3d startVec = rayTraceContext.func_222253_b();
        Vector3d endVec = rayTraceContext.func_222250_a();
        VoxelShape blockShape = rayTraceContext.func_222251_a(blockState, (IBlockReader)world, blockPos);
        BlockRayTraceResult blockResult = world.func_217296_a(startVec, endVec, blockPos, blockShape, blockState);
        VoxelShape fluidShape = rayTraceContext.func_222252_a(fluidState, (IBlockReader)world, blockPos);
        BlockRayTraceResult fluidResult = fluidShape.func_212433_a(startVec, endVec, blockPos);
        double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.func_222253_b().func_72436_e(blockResult.func_216347_e());
        double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.func_222253_b().func_72436_e(fluidResult.func_216347_e());
        return blockDistance <= fluidDistance ? blockResult : fluidResult;
    }

    private static <T> T performRayTrace(RayTraceContext context, BiFunction<RayTraceContext, BlockPos, T> hitFunction, Function<RayTraceContext, T> missFactory) {
        int blockZ;
        int blockY;
        Vector3d endVec;
        Vector3d startVec = context.func_222253_b();
        if (startVec.equals((Object)(endVec = context.func_222250_a()))) {
            return missFactory.apply(context);
        }
        double startX = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72450_a, (double)startVec.field_72450_a);
        double startY = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72448_b, (double)startVec.field_72448_b);
        double startZ = MathHelper.func_219803_d((double)-1.0E-7, (double)endVec.field_72449_c, (double)startVec.field_72449_c);
        double endX = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72450_a, (double)endVec.field_72450_a);
        double endY = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72448_b, (double)endVec.field_72448_b);
        double endZ = MathHelper.func_219803_d((double)-1.0E-7, (double)startVec.field_72449_c, (double)endVec.field_72449_c);
        int blockX = MathHelper.func_76128_c((double)endX);
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(blockX, blockY = MathHelper.func_76128_c((double)endY), blockZ = MathHelper.func_76128_c((double)endZ));
        T t = hitFunction.apply(context, (BlockPos)mutablePos);
        if (t != null) {
            return t;
        }
        double deltaX = startX - endX;
        double deltaY = startY - endY;
        double deltaZ = startZ - endZ;
        int signX = MathHelper.func_219802_k((double)deltaX);
        int signY = MathHelper.func_219802_k((double)deltaY);
        int signZ = MathHelper.func_219802_k((double)deltaZ);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
        double d12 = d9 * (signX > 0 ? 1.0 - MathHelper.func_181162_h((double)endX) : MathHelper.func_181162_h((double)endX));
        double d13 = d10 * (signY > 0 ? 1.0 - MathHelper.func_181162_h((double)endY) : MathHelper.func_181162_h((double)endY));
        double d14 = d11 * (signZ > 0 ? 1.0 - MathHelper.func_181162_h((double)endZ) : MathHelper.func_181162_h((double)endZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    blockX += signX;
                    d12 += d9;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                blockY += signY;
                d13 += d10;
            } else {
                blockZ += signZ;
                d14 += d11;
            }
            if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.func_181079_c(blockX, blockY, blockZ))) == null) continue;
            return t1;
        }
        return missFactory.apply(context);
    }

    public static void createExplosion(Entity entity, float power, float radius, @Nullable Vector3d hitVec) {
        ProjectileExplosion explosion;
        World world = entity.field_70170_p;
        if (world.func_201670_d()) {
            return;
        }
        Explosion.Mode mode = (Boolean)Config.SERVER.gameplay.enableExplosionBreak.get() != false ? Explosion.Mode.BREAK : Explosion.Mode.NONE;
        DamageSourceExplosion source = null;
        if (entity instanceof IExplosionProvider) {
            source = ((IExplosionProvider)entity).createDamageSource();
        }
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)(explosion = hitVec == null ? new ProjectileExplosion(world, entity, (DamageSource)source, null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), power, radius, mode) : new ProjectileExplosion(world, entity, (DamageSource)source, null, hitVec.func_82615_a(), hitVec.func_82617_b(), hitVec.func_82616_c(), power, radius, mode)))) {
            return;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        explosion.func_180343_e().forEach(pos -> {
            if (world.func_180495_p(pos).func_177230_c() instanceof IExplosionDamageable) {
                ((IExplosionDamageable)world.func_180495_p(pos).func_177230_c()).onProjectileExploded(world, world.func_180495_p(pos), (BlockPos)pos, entity);
            }
        });
        if (mode == Explosion.Mode.NONE) {
            explosion.func_180342_d();
        }
        for (ServerPlayerEntity player : ((ServerWorld)world).func_217369_A()) {
            if (hitVec == null) {
                if (!(player.func_70092_e(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()) < 4096.0)) continue;
                player.field_71135_a.func_147359_a((IPacket)new SExplosionPacket(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), radius, explosion.func_180343_e(), (Vector3d)explosion.func_77277_b().get(player)));
                continue;
            }
            if (!(player.func_70092_e(hitVec.func_82615_a(), hitVec.func_82617_b(), hitVec.func_82616_c()) < 4096.0)) continue;
            player.field_71135_a.func_147359_a((IPacket)new SExplosionPacket(hitVec.func_82615_a(), hitVec.func_82617_b(), hitVec.func_82616_c(), radius, explosion.func_180343_e(), (Vector3d)explosion.func_77277_b().get(player)));
        }
    }

    public static class EntityResult {
        private Entity entity;
        private Vector3d hitVec;
        private boolean headshot;

        public EntityResult(Entity entity, Vector3d hitVec, boolean headshot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Vector3d getHitPos() {
            return this.hitVec;
        }

        public boolean isHeadshot() {
            return this.headshot;
        }
    }
}

