/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common.attachments.perk;

import com.tac.guns.common.attachments.CustomModifierData;
import com.tac.guns.common.attachments.perk.Perk;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class SignedPerk<T>
extends Perk<T> {
    private final String keyPositive;
    private final String keyNegative;
    private boolean harmful = false;
    @Nullable
    private final Function<T, String> formatter;

    SignedPerk(String key, String keyPositive, String keyNegative, Function<T, String> formatter, Function<CustomModifierData.General, T> getter) {
        super(key, getter);
        this.formatter = formatter;
        this.keyPositive = keyPositive;
        this.keyNegative = keyNegative;
    }

    SignedPerk(String key, String keyPositive, String keyNegative, Function<T, String> formatter, Function<CustomModifierData.General, T> getter, boolean harmful) {
        this(key, keyPositive, keyNegative, formatter, getter);
        this.harmful = harmful;
    }

    public boolean isHarmful() {
        return this.harmful;
    }

    public String getKeyPositive() {
        return this.keyPositive;
    }

    public String getKeyNegative() {
        return this.keyNegative;
    }

    public ITextComponent getPositive(CustomModifierData data) {
        Object value = this.getValue(data.getGeneral());
        if (this.getFormatter() == null) {
            return new TranslationTextComponent(this.getKeyPositive(), new Object[]{value}).func_240699_a_(TextFormatting.GREEN);
        }
        return new TranslationTextComponent(this.getKeyPositive(), new Object[]{this.getFormatter().apply(value)}).func_240699_a_(TextFormatting.GREEN);
    }

    public ITextComponent getNegative(CustomModifierData data) {
        Object value = this.getValue(data.getGeneral());
        if (this.getFormatter() == null) {
            return new TranslationTextComponent(this.getKeyNegative(), new Object[]{value}).func_240699_a_(TextFormatting.RED);
        }
        return new TranslationTextComponent(this.getKeyNegative(), new Object[]{this.getFormatter().apply(value)}).func_240699_a_(TextFormatting.RED);
    }

    @Nullable
    public Function<T, String> getFormatter() {
        return this.formatter;
    }
}

