/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common.attachments.perk;

import com.tac.guns.common.attachments.CustomModifierData;
import com.tac.guns.common.attachments.perk.SignedPerk;
import java.lang.reflect.Field;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;

public class FloatPerk
extends SignedPerk<Float> {
    public FloatPerk(String key, String keyPositive, String keyNegative, Function<Float, String> formatter, Function<CustomModifierData.General, Float> getter) {
        super(key, keyPositive, keyNegative, formatter, getter);
    }

    public FloatPerk(String key, String keyPositive, String keyNegative, Function<Float, String> formatter, Function<CustomModifierData.General, Float> getter, boolean harmful) {
        super(key, keyPositive, keyNegative, formatter, getter, harmful);
    }

    @Override
    public Float getValue(CustomModifierData.General data) {
        if (this.getter != null && data != null) {
            return (Float)this.getter.apply(data);
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public void write(CompoundNBT tag, CustomModifierData.General data) {
        tag.func_74776_a(this.getKey(), this.getValue(data).floatValue());
    }

    @Override
    public void read(CompoundNBT tag, CustomModifierData.General data) {
        try {
            Field field;
            if (tag.func_150297_b(this.getKey(), 5) && (field = data.getClass().getDeclaredField(this.getKey())).getType() == Float.TYPE) {
                field.setAccessible(true);
                field.setFloat(data, tag.func_74760_g(this.getKey()));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

