/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common.attachments;

import com.tac.guns.annotation.Ignored;
import com.tac.guns.annotation.Optional;
import com.tac.guns.common.attachments.Perks;
import com.tac.guns.common.attachments.perk.Perk;
import com.tac.guns.interfaces.TGExclude;
import com.tac.guns.item.transition.TimelessGunItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomModifierData
implements INBTSerializable<CompoundNBT> {
    @TGExclude
    @Ignored
    private ResourceLocation id;
    @Optional
    private ResourceLocation skin;
    @Optional
    private List<String> canApplyOn;
    @Optional
    private List<String> canNotApplyOn;
    @Optional
    private List<String> extraTooltip;
    @Optional
    private boolean hideLimitInfo = false;
    @TGExclude
    @Ignored
    private final List<ITag<Item>> whiteListTags = new ArrayList<ITag<Item>>();
    @TGExclude
    @Ignored
    private final List<ResourceLocation> whiteListItems = new ArrayList<ResourceLocation>();
    @TGExclude
    @Ignored
    private final List<ITag<Item>> blackListTags = new ArrayList<ITag<Item>>();
    @TGExclude
    @Ignored
    private final List<ResourceLocation> blackListItems = new ArrayList<ResourceLocation>();
    @Optional
    private General general = new General();

    protected void setId(ResourceLocation rl) {
        if (this.id == null) {
            this.id = rl;
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceLocation getSkin() {
        return this.skin;
    }

    public List<String> getExtraTooltip() {
        return this.extraTooltip;
    }

    public void init() {
        this.getApplyOn(this.canApplyOn, this.whiteListTags, this.whiteListItems);
        this.getApplyOn(this.canNotApplyOn, this.blackListTags, this.blackListItems);
    }

    private void getApplyOn(List<String> applyOn, List<ITag<Item>> ListTags, List<ResourceLocation> ListItems) {
        if (applyOn != null) {
            for (String raw : applyOn) {
                Item item;
                ResourceLocation location;
                if (raw.startsWith("#")) {
                    location = ResourceLocation.func_208304_a((String)raw.substring(1));
                    if (location == null) continue;
                    ITag tag = ItemTags.func_199903_a().func_199910_a(location);
                    ListTags.add((ITag<Item>)tag);
                    continue;
                }
                location = ResourceLocation.func_208304_a((String)raw);
                if (location == null || !((item = (Item)ForgeRegistries.ITEMS.getValue(location)) instanceof TimelessGunItem)) continue;
                ListItems.add(location);
            }
        }
    }

    public General getGeneral() {
        return this.general;
    }

    public boolean isHideLimitInfo() {
        return this.hideLimitInfo;
    }

    @Nullable
    public List<ResourceLocation> getSuitableGuns() {
        return this.whiteListItems;
    }

    public boolean canApplyOn(TimelessGunItem item) {
        boolean noWhiteList;
        block15: {
            block22: {
                block21: {
                    block20: {
                        boolean noBlackList;
                        block18: {
                            block19: {
                                block16: {
                                    block17: {
                                        noWhiteList = false;
                                        noBlackList = false;
                                        if (this.whiteListItems.isEmpty() && this.whiteListTags.isEmpty()) {
                                            noWhiteList = true;
                                        }
                                        if (this.blackListItems.isEmpty() && this.blackListTags.isEmpty()) {
                                            noBlackList = true;
                                        }
                                        if (item.getRegistryName() == null) break block15;
                                        if (noWhiteList && noBlackList) {
                                            return true;
                                        }
                                        if (!noWhiteList) break block16;
                                        if (this.blackListItems.contains(item.getRegistryName())) break block17;
                                        if (!this.blackListTags.stream().filter(Objects::nonNull).anyMatch(arg_0 -> ((TimelessGunItem)item).func_206844_a(arg_0))) break block16;
                                    }
                                    return false;
                                }
                                if (!noBlackList) break block18;
                                if (this.whiteListItems.contains(item.getRegistryName())) break block19;
                                if (!this.whiteListTags.stream().filter(Objects::nonNull).anyMatch(arg_0 -> ((TimelessGunItem)item).func_206844_a(arg_0))) break block18;
                            }
                            return true;
                        }
                        if (noWhiteList || noBlackList) break block15;
                        if (this.blackListItems.contains(item.getRegistryName())) break block20;
                        if (!this.blackListTags.stream().filter(Objects::nonNull).anyMatch(arg_0 -> ((TimelessGunItem)item).func_206844_a(arg_0))) break block21;
                    }
                    return false;
                }
                if (this.whiteListItems.contains(item.getRegistryName())) break block22;
                if (!this.whiteListTags.stream().filter(Objects::nonNull).anyMatch(arg_0 -> ((TimelessGunItem)item).func_206844_a(arg_0))) break block15;
            }
            return true;
        }
        return noWhiteList;
    }

    public CompoundNBT serializeNBT() {
        ListNBT listNBT;
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("id", this.id.toString());
        if (this.skin != null) {
            nbt.func_74778_a("model", this.skin.toString());
        }
        if (this.canApplyOn != null) {
            listNBT = new ListNBT();
            for (String s : this.canApplyOn) {
                listNBT.add((Object)StringNBT.func_229705_a_((String)s));
            }
            nbt.func_218657_a("canApplyOn", (INBT)listNBT);
        }
        if (this.canNotApplyOn != null) {
            listNBT = new ListNBT();
            for (String s : this.canNotApplyOn) {
                listNBT.add((Object)StringNBT.func_229705_a_((String)s));
            }
            nbt.func_218657_a("canNotApplyOn", (INBT)listNBT);
        }
        if (this.extraTooltip != null) {
            listNBT = new ListNBT();
            for (String s : this.extraTooltip) {
                listNBT.add((Object)StringNBT.func_229705_a_((String)s));
            }
            nbt.func_218657_a("extraTooltip", (INBT)listNBT);
        }
        nbt.func_74757_a("hideLimitInfo", this.hideLimitInfo);
        nbt.func_218657_a("General", (INBT)this.general.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT listNBT;
        if (nbt.func_74764_b("id")) {
            this.id = ResourceLocation.func_208304_a((String)nbt.func_74779_i("id"));
        }
        if (nbt.func_74764_b("model")) {
            this.skin = ResourceLocation.func_208304_a((String)nbt.func_74779_i("model"));
        }
        if (nbt.func_150297_b("canApplyOn", 9) && !(listNBT = nbt.func_150295_c("canApplyOn", 8)).isEmpty()) {
            this.canApplyOn = new ArrayList<String>();
            listNBT.forEach(s -> this.canApplyOn.add(s.func_150285_a_()));
        }
        if (nbt.func_150297_b("canNotApplyOn", 9) && !(listNBT = nbt.func_150295_c("canNotApplyOn", 8)).isEmpty()) {
            this.canNotApplyOn = new ArrayList<String>();
            listNBT.forEach(s -> this.canNotApplyOn.add(s.func_150285_a_()));
        }
        if (nbt.func_150297_b("extraTooltip", 9) && !(listNBT = nbt.func_150295_c("extraTooltip", 8)).isEmpty()) {
            this.extraTooltip = new ArrayList<String>();
            listNBT.forEach(s -> this.extraTooltip.add(s.func_150285_a_()));
        }
        if (nbt.func_74764_b("hideLimitInfo")) {
            this.hideLimitInfo = nbt.func_74767_n("hideLimitInfo");
        }
        if (nbt.func_150297_b("General", 10)) {
            this.general.deserializeNBT(nbt.func_74775_l("General"));
        }
    }

    public static class General
    implements INBTSerializable<CompoundNBT> {
        @Optional
        private boolean silencedFire = false;
        @Optional
        private float modifyProjectileBlastDamage = 1.0f;
        @Optional
        private float modifyProjectileArmorIgnore = 1.0f;
        @Optional
        private float modifyProjectileHeadDamage = 1.0f;
        @Optional
        private double modifyFireSoundRadius = 1.0;
        @Optional
        private float additionalDamage = 0.0f;
        @Optional
        private float additionalHeadshotDamage = 0.0f;
        @Optional
        private float modifyProjectileDamage = 1.0f;
        @Optional
        private double modifyProjectileSpeed = 1.0;
        @Optional
        private float modifyProjectileSpread = 1.0f;
        @Optional
        private float modifyFirstShotSpread = 1.0f;
        @Optional
        private float modifyHipFireSpread = 1.0f;
        @Optional
        private float modifyProjectileLife = 1.0f;
        @Optional
        private float recoilModifier = 1.0f;
        @Optional
        private float horizontalRecoilModifier = 1.0f;
        @Optional
        private double modifyAimDownSightSpeed = 1.0;
        @Optional
        private int additionalAmmunition = -1;
        @Optional
        private int additionalPierce = 0;
        @Optional
        private float additionalWeaponWeight = 0.0f;
        @Optional
        private float modifyFireSoundVolume = 1.0f;
        @Optional
        private float modifyRecoilSmoothening = 1.0f;
        @Optional
        private double modifyMuzzleFlashSize = 1.0;
        @Optional
        private float modifyWeaponWeight = 0.0f;
        @Optional
        private float kickModifier = 1.0f;
        @Optional
        private int fmjAmmo = -1;
        @Optional
        private int heAmmo = -1;
        @Optional
        private int hpAmmo = -1;
        @Optional
        private int iAmmo = -1;

        public boolean isSilencedFire() {
            return this.silencedFire;
        }

        public float getModifyProjectileBlastDamage() {
            return this.modifyProjectileBlastDamage;
        }

        public float getModifyProjectileArmorIgnore() {
            return this.modifyProjectileArmorIgnore;
        }

        public float getModifyProjectileHeadDamage() {
            return this.modifyProjectileHeadDamage;
        }

        public double getModifyFireSoundRadius() {
            return this.modifyFireSoundRadius;
        }

        public float getAdditionalDamage() {
            return this.additionalDamage;
        }

        public float getAdditionalHeadshotDamage() {
            return this.additionalHeadshotDamage;
        }

        public float getModifyProjectileDamage() {
            return this.modifyProjectileDamage;
        }

        public double getModifyProjectileSpeed() {
            return this.modifyProjectileSpeed;
        }

        public float getModifyProjectileSpread() {
            return this.modifyProjectileSpread;
        }

        public float getModifyFirstShotSpread() {
            return this.modifyFirstShotSpread;
        }

        public float getModifyHipFireSpread() {
            return this.modifyHipFireSpread;
        }

        public float getModifyProjectileLife() {
            return this.modifyProjectileLife;
        }

        public float getRecoilModifier() {
            return this.recoilModifier;
        }

        public float getHorizontalRecoilModifier() {
            return this.horizontalRecoilModifier;
        }

        public double getModifyAimDownSightSpeed() {
            return this.modifyAimDownSightSpeed;
        }

        public int getAdditionalAmmunition() {
            return this.additionalAmmunition;
        }

        public int getAdditionalPierce() {
            return this.additionalPierce;
        }

        public float getAdditionalWeaponWeight() {
            return this.additionalWeaponWeight;
        }

        public float getModifyFireSoundVolume() {
            return this.modifyFireSoundVolume;
        }

        public float getModifyRecoilSmoothening() {
            return this.modifyRecoilSmoothening;
        }

        public double getModifyMuzzleFlashSize() {
            return this.modifyMuzzleFlashSize;
        }

        public float getModifyWeaponWeight() {
            return this.modifyWeaponWeight;
        }

        public float getKickModifier() {
            return this.kickModifier;
        }

        public int getFmjAmmo() {
            return this.fmjAmmo;
        }

        public int getHeAmmo() {
            return this.heAmmo;
        }

        public int getHpAmmo() {
            return this.hpAmmo;
        }

        public int getIAmmo() {
            return this.iAmmo;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            for (Perk<?> perk : Perks.perkList) {
                perk.write(nbt, this);
            }
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            for (Perk<?> perk : Perks.perkList) {
                perk.read(nbt, this);
            }
        }
    }
}

