/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.tac.guns.annotation.Optional;
import com.tac.guns.interfaces.TGExclude;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public final class Rig
implements INBTSerializable<CompoundNBT> {
    private General general = new General();
    private Repair repair = new Repair();
    private Sounds sounds = new Sounds();
    public static ExclusionStrategy strategy = new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            return field.getAnnotation(TGExclude.class) != null;
        }
    };

    public General getGeneral() {
        return this.general;
    }

    public Repair getRepair() {
        return this.repair;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("General", (INBT)this.general.serializeNBT());
        tag.func_218657_a("Repair", (INBT)this.repair.serializeNBT());
        tag.func_218657_a("Sounds", (INBT)this.sounds.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        if (tag.func_150297_b("General", 10)) {
            this.general.deserializeNBT(tag.func_74775_l("General"));
        }
        if (tag.func_150297_b("Repair", 10)) {
            this.repair.deserializeNBT(tag.func_74775_l("Repair"));
        }
        if (tag.func_150297_b("Sounds", 10)) {
            this.sounds.deserializeNBT(tag.func_74775_l("Sounds"));
        }
    }

    public static Rig create(CompoundNBT tag) {
        Rig gun = new Rig();
        gun.deserializeNBT(tag);
        return gun;
    }

    public Rig copy() {
        Rig gun = new Rig();
        gun.general = this.general.copy();
        gun.repair = this.repair.copy();
        gun.sounds = this.sounds.copy();
        return gun;
    }

    private static boolean isAmmo(ItemStack stack, ResourceLocation id) {
        return stack != null && stack.func_77973_b().getRegistryName().equals((Object)id);
    }

    public static class Sounds
    implements INBTSerializable<CompoundNBT> {
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation step;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation on;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation off;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation hit;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation broken;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation repair;

        @Nullable
        public ResourceLocation getOn() {
            return this.on;
        }

        @Nullable
        public ResourceLocation getOff() {
            return this.off;
        }

        @Nullable
        public ResourceLocation getHit() {
            return this.hit;
        }

        @Nullable
        public ResourceLocation getBroken() {
            return this.broken;
        }

        @Nullable
        public ResourceLocation getRepair() {
            return this.repair;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            if (this.step != null) {
                tag.func_74778_a("Step", this.step.toString());
            }
            if (this.on != null) {
                tag.func_74778_a("On", this.on.toString());
            }
            if (this.off != null) {
                tag.func_74778_a("Off", this.off.toString());
            }
            if (this.hit != null) {
                tag.func_74778_a("Hit", this.hit.toString());
            }
            if (this.broken != null) {
                tag.func_74778_a("Broken", this.broken.toString());
            }
            if (this.repair != null) {
                tag.func_74778_a("Repair", this.repair.toString());
            }
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("Step", 8)) {
                this.step = this.createSound(tag, "Step");
            }
            if (tag.func_150297_b("On", 8)) {
                this.on = this.createSound(tag, "On");
            }
            if (tag.func_150297_b("Off", 8)) {
                this.off = this.createSound(tag, "Off");
            }
            if (tag.func_150297_b("Hit", 8)) {
                this.hit = this.createSound(tag, "Hit");
            }
            if (tag.func_150297_b("Broken", 8)) {
                this.broken = this.createSound(tag, "Broken");
            }
            if (tag.func_150297_b("Repair", 8)) {
                this.repair = this.createSound(tag, "Repair");
            }
        }

        public Sounds copy() {
            Sounds sounds = new Sounds();
            sounds.broken = this.broken;
            sounds.hit = this.hit;
            sounds.off = this.off;
            sounds.on = this.on;
            sounds.repair = this.repair;
            sounds.step = this.step;
            return sounds;
        }

        @Nullable
        private ResourceLocation createSound(CompoundNBT tag, String key) {
            String sound = tag.func_74779_i(key);
            return sound.isEmpty() ? null : new ResourceLocation(sound);
        }

        @Nullable
        public ResourceLocation getStep() {
            return this.step;
        }
    }

    public static class Repair
    implements INBTSerializable<CompoundNBT> {
        @Optional
        private int ticksToRepair = 40;
        @Optional
        private float durability = 40.0f;
        @Optional
        private float quickRepairability = 0.5f;
        @Optional
        private boolean quickRepairable = true;
        @TGExclude
        private ResourceLocation repairItem = new ResourceLocation("tac", "armor_plate");

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("RepairItem", this.repairItem.toString());
            tag.func_74768_a("TicksToRepair", this.ticksToRepair);
            tag.func_74776_a("Durability", this.durability);
            tag.func_74776_a("QuickRepairability", this.quickRepairability);
            tag.func_74757_a("QuickRepairable", this.quickRepairable);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("RepairItem", 8)) {
                this.repairItem = new ResourceLocation(tag.func_74779_i("RepairItem"));
            }
            if (tag.func_150297_b("TicksToRepair", 99)) {
                this.ticksToRepair = tag.func_74762_e("TicksToRepair");
            }
            if (tag.func_150297_b("Durability", 99)) {
                this.durability = tag.func_74760_g("Durability");
            }
            if (tag.func_150297_b("QuickRepairability", 99)) {
                this.quickRepairability = tag.func_74760_g("QuickRepairability");
            }
            if (tag.func_150297_b("QuickRepairable", 99)) {
                this.quickRepairable = tag.func_74767_n("QuickRepairable");
            }
        }

        public Repair copy() {
            Repair repair = new Repair();
            repair.quickRepairable = this.quickRepairable;
            repair.repairItem = this.repairItem;
            repair.durability = this.durability;
            repair.quickRepairability = this.quickRepairability;
            repair.ticksToRepair = this.ticksToRepair;
            return repair;
        }

        public ResourceLocation getItem() {
            return this.repairItem;
        }

        public int getTicksToRepair() {
            return this.ticksToRepair;
        }

        public float getDurability() {
            return this.durability;
        }

        public float getQuickRepairability() {
            return this.quickRepairability;
        }

        public boolean isQuickRepairable() {
            return this.quickRepairable;
        }
    }

    public static class General
    implements INBTSerializable<CompoundNBT> {
        @Optional
        private int armorClass = 1;
        @Optional
        private int ergonomics = 1;
        @Optional
        private float speedReduction = 0.0f;
        @Optional
        private float movementInaccuracy = 1.0f;

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("ArmorClass", this.armorClass);
            tag.func_74768_a("Ergonomics", this.ergonomics);
            tag.func_74776_a("SpeedReduction", this.speedReduction);
            tag.func_74776_a("MovementInaccuracy", this.movementInaccuracy);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("ArmorClass", 99)) {
                this.armorClass = tag.func_74762_e("ArmorClass");
            }
            if (tag.func_150297_b("Ergonomics", 99)) {
                this.ergonomics = tag.func_74762_e("Ergonomics");
            }
            if (tag.func_150297_b("SpeedReduction", 99)) {
                this.speedReduction = tag.func_74760_g("SpeedReduction");
            }
            if (tag.func_150297_b("MovementInaccuracy", 99)) {
                this.movementInaccuracy = tag.func_74760_g("MovementInaccuracy");
            }
        }

        public General copy() {
            General general = new General();
            general.armorClass = this.armorClass;
            general.ergonomics = this.ergonomics;
            general.speedReduction = this.speedReduction;
            general.movementInaccuracy = this.movementInaccuracy;
            return general;
        }

        public int getArmorClass() {
            return this.armorClass;
        }

        public int getErgonomics() {
            return this.ergonomics;
        }

        public float getSpeedReduction() {
            return this.speedReduction;
        }

        public float getMovementInaccuracy() {
            return this.movementInaccuracy;
        }
    }
}

