/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.tac.guns.Config;
import com.tac.guns.annotation.Ignored;
import com.tac.guns.annotation.Optional;
import com.tac.guns.client.handler.command.GunEditor;
import com.tac.guns.common.GripType;
import com.tac.guns.common.ReloadTracker;
import com.tac.guns.common.WeaponType;
import com.tac.guns.common.container.slot.SlotType;
import com.tac.guns.interfaces.TGExclude;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.item.attachment.IScope;
import com.tac.guns.item.attachment.impl.Scope;
import com.tac.guns.item.transition.TimelessGunItem;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;

public final class Gun
implements INBTSerializable<CompoundNBT> {
    private General general = new General();
    private Reloads reloads = new Reloads();
    private Projectile projectile = new Projectile();
    private AmmoPlugEffect ammoPlugEffect = new AmmoPlugEffect();
    private Sounds sounds = new Sounds();
    private Display display = new Display();
    private Modules modules = new Modules();
    public static ExclusionStrategy strategy = new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes field) {
            return field.getAnnotation(TGExclude.class) != null;
        }
    };

    public General getGeneral() {
        return this.general;
    }

    public Reloads getReloads() {
        return this.reloads;
    }

    public Projectile getProjectile() {
        return this.projectile;
    }

    public AmmoPlugEffect getAmmoPlugEffect() {
        return this.ammoPlugEffect;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Modules getModules() {
        return this.modules;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("General", (INBT)this.general.serializeNBT());
        tag.func_218657_a("Reloads", (INBT)this.reloads.serializeNBT());
        tag.func_218657_a("Projectile", (INBT)this.projectile.serializeNBT());
        tag.func_218657_a("Sounds", (INBT)this.sounds.serializeNBT());
        tag.func_218657_a("Display", (INBT)this.display.serializeNBT());
        tag.func_218657_a("Modules", (INBT)this.modules.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        if (tag.func_150297_b("General", 10)) {
            this.general.deserializeNBT(tag.func_74775_l("General"));
        }
        if (tag.func_150297_b("Reloads", 10)) {
            this.reloads.deserializeNBT(tag.func_74775_l("Reloads"));
        }
        if (tag.func_150297_b("Projectile", 10)) {
            this.projectile.deserializeNBT(tag.func_74775_l("Projectile"));
        }
        if (tag.func_150297_b("Sounds", 10)) {
            this.sounds.deserializeNBT(tag.func_74775_l("Sounds"));
        }
        if (tag.func_150297_b("Display", 10)) {
            this.display.deserializeNBT(tag.func_74775_l("Display"));
        }
        if (tag.func_150297_b("Modules", 10)) {
            this.modules.deserializeNBT(tag.func_74775_l("Modules"));
        }
    }

    public static Gun create(CompoundNBT tag) {
        Gun gun = new Gun();
        gun.deserializeNBT(tag);
        return gun;
    }

    public Gun copy() {
        Gun gun = new Gun();
        gun.general = this.general.copy();
        gun.reloads = this.reloads.copy();
        gun.projectile = this.projectile.copy();
        gun.sounds = this.sounds.copy();
        gun.display = this.display.copy();
        gun.modules = this.modules.copy();
        return gun;
    }

    public boolean hasSlot(@Nullable SlotType type) {
        if (this.modules.attachments != null && type != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope != null || this.modules.attachments.oldScope != null || this.modules.attachments.pistolScope != null;
                }
                case BARREL: {
                    return this.modules.attachments.barrel != null || this.modules.attachments.pistolBarrel != null;
                }
                case STOCK: {
                    return this.modules.attachments.stock != null;
                }
                case UNDER_BARREL: {
                    return this.modules.attachments.underBarrel != null;
                }
                case GUN_SKIN: {
                    return this.modules.attachments.gunSkin != null;
                }
                case AMMO: {
                    return this.modules.attachments.ammoPlug != null;
                }
                case SIDE_RAIL: {
                    return this.modules.attachments.sideRail != null || this.modules.attachments.irDevice != null;
                }
                case EXTENDED_MAG: {
                    return this.modules.attachments.extendedMag != null;
                }
            }
        }
        return false;
    }

    public boolean canAttachType(@Nullable IAttachment.Type type) {
        if (this.modules.attachments != null && type != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope != null;
                }
                case BARREL: {
                    return this.modules.attachments.barrel != null;
                }
                case STOCK: {
                    return this.modules.attachments.stock != null;
                }
                case UNDER_BARREL: {
                    return this.modules.attachments.underBarrel != null;
                }
                case GUN_SKIN: {
                    return this.modules.attachments.gunSkin != null;
                }
                case AMMO: {
                    return this.modules.attachments.ammoPlug != null;
                }
                case SIDE_RAIL: {
                    return this.modules.attachments.sideRail != null;
                }
                case IR_DEVICE: {
                    return this.modules.attachments.irDevice != null;
                }
                case EXTENDED_MAG: {
                    return this.modules.attachments.extendedMag != null;
                }
                case OLD_SCOPE: {
                    return this.modules.attachments.oldScope != null;
                }
                case PISTOL_SCOPE: {
                    return this.modules.attachments.pistolScope != null;
                }
                case PISTOL_BARREL: {
                    return this.modules.attachments.pistolBarrel != null;
                }
            }
        }
        return false;
    }

    @Nullable
    public ScaledPositioned getAttachmentPosition(IAttachment.Type type) {
        if (this.modules.attachments != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope;
                }
                case BARREL: {
                    return this.modules.attachments.barrel;
                }
                case STOCK: {
                    return this.modules.attachments.stock;
                }
                case UNDER_BARREL: {
                    return this.modules.attachments.underBarrel;
                }
                case GUN_SKIN: {
                    return this.modules.attachments.gunSkin;
                }
                case AMMO: {
                    return this.modules.attachments.ammoPlug;
                }
                case SIDE_RAIL: {
                    return this.modules.attachments.sideRail;
                }
                case IR_DEVICE: {
                    return this.modules.attachments.irDevice;
                }
                case EXTENDED_MAG: {
                    return this.modules.attachments.extendedMag;
                }
                case OLD_SCOPE: {
                    return this.modules.attachments.oldScope;
                }
                case PISTOL_SCOPE: {
                    return this.modules.attachments.pistolScope;
                }
                case PISTOL_BARREL: {
                    return this.modules.attachments.pistolBarrel;
                }
            }
        }
        return null;
    }

    public boolean canAimDownSight() {
        return this.canAttachType(IAttachment.Type.SCOPE) || this.canAttachType(IAttachment.Type.OLD_SCOPE) || this.canAttachType(IAttachment.Type.PISTOL_SCOPE) || this.modules.zoom != null;
    }

    public static boolean hasAttachmentEquipped(ItemStack stack, Gun gun, IAttachment.Type type) {
        if (!gun.canAttachType(type)) {
            return false;
        }
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null && compound.func_150297_b("Attachments", 10)) {
            CompoundNBT attachment = compound.func_74775_l("Attachments");
            return attachment.func_150297_b(type.getTagKey(), 10);
        }
        return false;
    }

    @Nullable
    public static Scope getScope(ItemStack gun) {
        CompoundNBT compound = gun.func_77978_p();
        Scope scope = null;
        if (compound != null && compound.func_150297_b("Attachments", 10)) {
            ItemStack OldScopeStack;
            CompoundNBT attachment = compound.func_74775_l("Attachments");
            if (attachment.func_150297_b("Scope", 10)) {
                ItemStack scopeStack = ItemStack.func_199557_a((CompoundNBT)attachment.func_74775_l("Scope"));
                if (scopeStack.func_77973_b() instanceof IScope) {
                    scope = (Scope)((IScope)scopeStack.func_77973_b()).getProperties();
                }
            } else if (attachment.func_150297_b("OldScope", 10)) {
                ItemStack OldScopeStack2 = ItemStack.func_199557_a((CompoundNBT)attachment.func_74775_l("OldScope"));
                if (OldScopeStack2.func_77973_b() instanceof IScope) {
                    scope = (Scope)((IScope)OldScopeStack2.func_77973_b()).getProperties();
                }
            } else if (attachment.func_150297_b("PistolScope", 10) && (OldScopeStack = ItemStack.func_199557_a((CompoundNBT)attachment.func_74775_l("PistolScope"))).func_77973_b() instanceof IScope) {
                scope = (Scope)((IScope)OldScopeStack.func_77973_b()).getProperties();
            }
        }
        return scope;
    }

    public static ItemStack getAttachment(IAttachment.Type type, ItemStack gun) {
        CompoundNBT attachment;
        CompoundNBT compound = gun.func_77978_p();
        if (compound != null && compound.func_150297_b("Attachments", 10) && (attachment = compound.func_74775_l("Attachments")).func_150297_b(type.getTagKey(), 10)) {
            return ItemStack.func_199557_a((CompoundNBT)attachment.func_74775_l(type.getTagKey()));
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getAttachment(SlotType type, ItemStack gun) {
        CompoundNBT compound = gun.func_77978_p();
        if (compound != null && compound.func_150297_b("Attachments", 10)) {
            CompoundNBT attachment = compound.func_74775_l("Attachments");
            String key = null;
            switch (type) {
                case SCOPE: {
                    if (attachment.func_150297_b(IAttachment.Type.SCOPE.getTagKey(), 10)) {
                        key = IAttachment.Type.SCOPE.getTagKey();
                        break;
                    }
                    if (attachment.func_150297_b(IAttachment.Type.PISTOL_SCOPE.getTagKey(), 10)) {
                        key = IAttachment.Type.PISTOL_SCOPE.getTagKey();
                        break;
                    }
                    if (!attachment.func_150297_b(IAttachment.Type.OLD_SCOPE.getTagKey(), 10)) break;
                    key = IAttachment.Type.OLD_SCOPE.getTagKey();
                    break;
                }
                case BARREL: {
                    if (attachment.func_150297_b(IAttachment.Type.BARREL.getTagKey(), 10)) {
                        key = IAttachment.Type.BARREL.getTagKey();
                        break;
                    }
                    if (!attachment.func_150297_b(IAttachment.Type.PISTOL_BARREL.getTagKey(), 10)) break;
                    key = IAttachment.Type.PISTOL_BARREL.getTagKey();
                    break;
                }
                case SIDE_RAIL: {
                    if (attachment.func_150297_b(IAttachment.Type.SIDE_RAIL.getTagKey(), 10)) {
                        key = IAttachment.Type.SIDE_RAIL.getTagKey();
                        break;
                    }
                    if (!attachment.func_150297_b(IAttachment.Type.IR_DEVICE.getTagKey(), 10)) break;
                    key = IAttachment.Type.IR_DEVICE.getTagKey();
                    break;
                }
                default: {
                    key = type.getTagKey();
                }
            }
            if (key != null && attachment.func_150297_b(key, 10)) {
                return ItemStack.func_199557_a((CompoundNBT)attachment.func_74775_l(key));
            }
        }
        return ItemStack.field_190927_a;
    }

    public static float getAdditionalDamage(ItemStack gunStack) {
        CompoundNBT tag = gunStack.func_196082_o();
        return tag.func_74760_g("AdditionalDamage");
    }

    public static ItemStack[] findAmmo(PlayerEntity player, ResourceLocation id) {
        if (!player.func_70089_S()) {
            return new ItemStack[0];
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (player.func_184812_l_() && ((Boolean)Config.SERVER.gameplay.creativeUnlimitedReserveAmmo.get()).booleanValue() || !player.func_184812_l_() && ((Boolean)Config.SERVER.gameplay.commonUnlimitedReserveAmmo.get()).booleanValue()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            stacks.add(item != null ? new ItemStack((IItemProvider)item, Integer.MAX_VALUE) : ItemStack.field_190927_a);
            return stacks.toArray(new ItemStack[0]);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!Gun.isAmmo(stack, id)) continue;
            stacks.add(stack);
        }
        return stacks.toArray(new ItemStack[0]);
    }

    public static int getAmmo(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("AmmoCount");
    }

    public static boolean isAmmo(ItemStack stack, ResourceLocation id) {
        return stack != null && stack.func_77973_b().getRegistryName().equals((Object)id);
    }

    public static boolean hasAmmo(PlayerEntity player, ItemStack gunStack) {
        CompoundNBT tag = gunStack.func_196082_o();
        if (gunStack.func_77973_b() instanceof TimelessGunItem && ((TimelessGunItem)gunStack.func_77973_b()).getGun().getReloads().isNoMag()) {
            return ReloadTracker.calcMaxReserveAmmo(Gun.findAmmo(player, ((TimelessGunItem)gunStack.func_77973_b()).getGun().getProjectile().getItem())) > 0;
        }
        return tag.func_74767_n("IgnoreAmmo") || tag.func_74762_e("AmmoCount") > 0;
    }

    public static boolean hasAmmo(ItemStack gunStack) {
        CompoundNBT tag = gunStack.func_196082_o();
        return tag.func_74767_n("IgnoreAmmo") || tag.func_74762_e("AmmoCount") > 0;
    }

    public static class PistolScope
    extends ScaledPositioned {
        @Required
        private boolean doRenderMount;
        @Required
        private boolean doOnSlideMovement;

        public PistolScope() {
        }

        public PistolScope(CompoundNBT tag) {
            this.deserializeNBT(tag);
        }

        @Override
        public CompoundNBT serializeNBT() {
            CompoundNBT tag = super.serializeNBT();
            tag.func_74757_a("RenderMount", this.doRenderMount);
            tag.func_74757_a("DoOnSlideMovement", this.doOnSlideMovement);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundNBT tag) {
            super.deserializeNBT(tag);
            if (tag.func_150297_b("RenderMount", 99)) {
                this.doRenderMount = tag.func_74767_n("RenderMount");
            }
            if (tag.func_150297_b("DoOnSlideMovement", 99)) {
                this.doOnSlideMovement = tag.func_74767_n("DoOnSlideMovement");
            }
        }

        @Override
        public double getXOffset() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
        }

        @Override
        public double getYOffset() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
        }

        @Override
        public double getZOffset() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
        }

        @Override
        public double getScale() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? this.scale + GunEditor.get().getSizeMod() : this.scale;
        }

        public boolean getDoRenderMount() {
            return this.doRenderMount;
        }

        public boolean getDoOnSlideMovement() {
            return this.doOnSlideMovement;
        }

        @Override
        public PistolScope copy() {
            PistolScope positioned = new PistolScope();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            positioned.scale = this.scale;
            positioned.doRenderMount = this.doRenderMount;
            positioned.doOnSlideMovement = this.doOnSlideMovement;
            return positioned;
        }
    }

    public static class ScaledPositioned
    extends Positioned {
        @Optional
        protected double scale = 1.0;

        public ScaledPositioned() {
        }

        public ScaledPositioned(CompoundNBT tag) {
            this.deserializeNBT(tag);
        }

        @Override
        public CompoundNBT serializeNBT() {
            CompoundNBT tag = super.serializeNBT();
            tag.func_74780_a("Scale", this.scale);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundNBT tag) {
            super.deserializeNBT(tag);
            if (tag.func_150297_b("Scale", 99)) {
                this.scale = tag.func_74769_h("Scale");
            }
        }

        @Override
        public ScaledPositioned copy() {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            positioned.scale = this.scale;
            return positioned;
        }

        public double getScale() {
            return this.scale;
        }
    }

    public static class ShellCasing
    extends ScaledPositioned {
        @Optional
        protected float velocityX = 0.0f;
        @Optional
        protected float velocityY = 0.0f;
        @Optional
        protected float velocityZ = 0.0f;
        @Optional
        protected float rVelocityX = 0.0f;
        @Optional
        protected float rVelocityY = 0.0f;
        @Optional
        protected float rVelocityZ = 0.0f;
        @Optional
        protected float aVelocityX = 0.0f;
        @Optional
        protected float aVelocityY = 0.0f;
        @Optional
        protected float aVelocityZ = 0.0f;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation casingModel;
        @Optional
        protected int tickLife = 40;

        public ShellCasing() {
        }

        public ShellCasing(CompoundNBT tag) {
            this.deserializeNBT(tag);
        }

        @Override
        public CompoundNBT serializeNBT() {
            CompoundNBT tag = super.serializeNBT();
            tag.func_74776_a("VelocityX", this.velocityX);
            tag.func_74776_a("VelocityY", this.velocityY);
            tag.func_74776_a("VelocityZ", this.velocityZ);
            tag.func_74776_a("RVelocityX", this.rVelocityX);
            tag.func_74776_a("RVelocityY", this.rVelocityY);
            tag.func_74776_a("RVelocityZ", this.rVelocityZ);
            tag.func_74776_a("AVelocityX", this.aVelocityX);
            tag.func_74776_a("AVelocityY", this.aVelocityY);
            tag.func_74776_a("AVelocityZ", this.aVelocityZ);
            if (this.casingModel != null) {
                tag.func_74778_a("CasingModel", this.casingModel.toString());
            }
            tag.func_74768_a("TickLife", this.tickLife);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundNBT tag) {
            super.deserializeNBT(tag);
            if (tag.func_150297_b("VelocityX", 99)) {
                this.velocityX = tag.func_74760_g("VelocityX");
            }
            if (tag.func_150297_b("VelocityY", 99)) {
                this.velocityY = tag.func_74760_g("VelocityY");
            }
            if (tag.func_150297_b("VelocityZ", 99)) {
                this.velocityZ = tag.func_74760_g("VelocityZ");
            }
            if (tag.func_150297_b("RVelocityX", 99)) {
                this.rVelocityX = tag.func_74760_g("RVelocityX");
            }
            if (tag.func_150297_b("RVelocityY", 99)) {
                this.rVelocityY = tag.func_74760_g("RVelocityY");
            }
            if (tag.func_150297_b("RVelocityZ", 99)) {
                this.rVelocityZ = tag.func_74760_g("RVelocityZ");
            }
            if (tag.func_150297_b("AVelocityX", 99)) {
                this.aVelocityX = tag.func_74760_g("AVelocityX");
            }
            if (tag.func_150297_b("AVelocityY", 99)) {
                this.aVelocityY = tag.func_74760_g("AVelocityY");
            }
            if (tag.func_150297_b("AVelocityZ", 99)) {
                this.aVelocityZ = tag.func_74760_g("AVelocityZ");
            }
            if (tag.func_150297_b("CasingModel", 8)) {
                this.casingModel = this.createResource(tag, "CasingModel");
            }
            if (tag.func_150297_b("TickLife", 99)) {
                this.tickLife = tag.func_74762_e("TickLife");
            }
        }

        @Nullable
        private ResourceLocation createResource(CompoundNBT tag, String key) {
            String resource = tag.func_74779_i(key);
            return resource.isEmpty() ? null : new ResourceLocation(resource);
        }

        @Override
        public ShellCasing copy() {
            ShellCasing ms = new ShellCasing();
            ms.xOffset = this.xOffset;
            ms.yOffset = this.yOffset;
            ms.zOffset = this.zOffset;
            ms.scale = this.scale;
            ms.velocityX = this.velocityX;
            ms.velocityY = this.velocityY;
            ms.velocityZ = this.velocityZ;
            ms.rVelocityX = this.rVelocityX;
            ms.rVelocityY = this.rVelocityY;
            ms.rVelocityZ = this.rVelocityZ;
            ms.aVelocityX = this.aVelocityX;
            ms.aVelocityY = this.aVelocityY;
            ms.aVelocityZ = this.aVelocityZ;
            ms.casingModel = this.casingModel;
            ms.tickLife = this.tickLife;
            return ms;
        }

        public float getVelocityX() {
            return this.velocityX;
        }

        public float getVelocityY() {
            return this.velocityY;
        }

        public float getVelocityZ() {
            return this.velocityZ;
        }

        public float getRVelocityX() {
            return this.rVelocityX;
        }

        public float getRVelocityY() {
            return this.rVelocityY;
        }

        public float getRVelocityZ() {
            return this.rVelocityZ;
        }

        public float getAVelocityX() {
            return this.aVelocityX;
        }

        public float getAVelocityY() {
            return this.aVelocityY;
        }

        public float getAVelocityZ() {
            return this.aVelocityZ;
        }

        public ResourceLocation getCasingModel() {
            return this.casingModel;
        }

        public int getTickLife() {
            return this.tickLife;
        }
    }

    public static class Positioned
    implements INBTSerializable<CompoundNBT> {
        @Optional
        protected double xOffset = 0.0;
        @Optional
        protected double yOffset = 0.0;
        @Optional
        protected double zOffset = 0.0;

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74780_a("XOffset", this.xOffset);
            tag.func_74780_a("YOffset", this.yOffset);
            tag.func_74780_a("ZOffset", this.zOffset);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("XOffset", 99)) {
                this.xOffset = tag.func_74769_h("XOffset");
            }
            if (tag.func_150297_b("YOffset", 99)) {
                this.yOffset = tag.func_74769_h("YOffset");
            }
            if (tag.func_150297_b("ZOffset", 99)) {
                this.zOffset = tag.func_74769_h("ZOffset");
            }
        }

        public double getXOffset() {
            return this.xOffset;
        }

        public double getYOffset() {
            return this.yOffset;
        }

        public double getZOffset() {
            return this.zOffset;
        }

        public Positioned copy() {
            Positioned positioned = new Positioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            return positioned;
        }
    }

    public static class Modules
    implements INBTSerializable<CompoundNBT> {
        @Optional
        @Nullable
        private Zoom zoom = new Zoom();
        @Optional
        private Attachments attachments = new Attachments();

        @Nullable
        public Zoom getZoom() {
            return this.zoom.copy();
        }

        public Attachments getAttachments() {
            return this.attachments;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("Zoom", (INBT)this.zoom.serializeNBT());
            tag.func_218657_a("Attachments", (INBT)this.attachments.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("Zoom", 10)) {
                this.zoom.deserializeNBT(tag.func_74775_l("Zoom"));
            }
            if (tag.func_150297_b("Attachments", 10)) {
                this.attachments.deserializeNBT(tag.func_74775_l("Attachments"));
            }
        }

        public Modules copy() {
            Modules modules = new Modules();
            modules.zoom = this.zoom.copy();
            modules.attachments = this.attachments.copy();
            return modules;
        }

        public static class Attachments
        implements INBTSerializable<CompoundNBT> {
            @Optional
            @Nullable
            private ScaledPositioned scope;
            @Optional
            @Nullable
            private ScaledPositioned barrel;
            @Optional
            @Nullable
            private ScaledPositioned stock;
            @Optional
            @Nullable
            private ScaledPositioned underBarrel;
            @Optional
            @Nullable
            private ScaledPositioned gunSkin;
            @Optional
            @Nullable
            private ScaledPositioned ammoPlug;
            @Optional
            @Nullable
            private ScaledPositioned sideRail;
            @Optional
            @Nullable
            private ScaledPositioned irDevice;
            @Optional
            @Nullable
            private ScaledPositioned extendedMag;
            @Optional
            @Nullable
            private ScaledPositioned oldScope;
            @Optional
            @Nullable
            private PistolScope pistolScope;
            @Optional
            @Nullable
            private ScaledPositioned pistolBarrel;

            @Nullable
            public ScaledPositioned getScope() {
                return this.scope;
            }

            @Nullable
            public ScaledPositioned getBarrel() {
                return this.barrel;
            }

            @Nullable
            public ScaledPositioned getStock() {
                return this.stock;
            }

            @Nullable
            public ScaledPositioned getUnderBarrel() {
                return this.underBarrel;
            }

            @Nullable
            public ScaledPositioned getGunSkin() {
                return this.gunSkin;
            }

            @Nullable
            public ScaledPositioned getAmmoPlug() {
                return this.ammoPlug;
            }

            @Nullable
            public ScaledPositioned getSideRail() {
                return this.sideRail;
            }

            @Nullable
            public ScaledPositioned getIrDevice() {
                return this.irDevice;
            }

            @Nullable
            public ScaledPositioned getExtendedMag() {
                return this.extendedMag;
            }

            @Nullable
            public ScaledPositioned getOldScope() {
                return this.oldScope;
            }

            @Nullable
            public PistolScope getPistolScope() {
                return this.pistolScope;
            }

            @Nullable
            public ScaledPositioned getPistolBarrel() {
                return this.pistolBarrel;
            }

            public CompoundNBT serializeNBT() {
                CompoundNBT tag = new CompoundNBT();
                if (this.scope != null) {
                    tag.func_218657_a("Scope", (INBT)this.scope.serializeNBT());
                }
                if (this.barrel != null) {
                    tag.func_218657_a("Barrel", (INBT)this.barrel.serializeNBT());
                }
                if (this.stock != null) {
                    tag.func_218657_a("Stock", (INBT)this.stock.serializeNBT());
                }
                if (this.underBarrel != null) {
                    tag.func_218657_a("UnderBarrel", (INBT)this.underBarrel.serializeNBT());
                }
                if (this.oldScope != null) {
                    tag.func_218657_a("OldScope", (INBT)this.oldScope.serializeNBT());
                }
                if (this.gunSkin != null) {
                    tag.func_218657_a("GunSkin", (INBT)this.gunSkin.serializeNBT());
                }
                if (this.ammoPlug != null) {
                    tag.func_218657_a("AmmoPlug", (INBT)this.ammoPlug.serializeNBT());
                }
                if (this.sideRail != null) {
                    tag.func_218657_a("SideRail", (INBT)this.sideRail.serializeNBT());
                }
                if (this.irDevice != null) {
                    tag.func_218657_a("IrDevice", (INBT)this.irDevice.serializeNBT());
                }
                if (this.extendedMag != null) {
                    tag.func_218657_a("ExtendedMag", (INBT)this.extendedMag.serializeNBT());
                }
                if (this.pistolScope != null) {
                    tag.func_218657_a("PistolScope", (INBT)this.pistolScope.serializeNBT());
                }
                if (this.pistolBarrel != null) {
                    tag.func_218657_a("PistolBarrel", (INBT)this.pistolBarrel.serializeNBT());
                }
                return tag;
            }

            public void deserializeNBT(CompoundNBT tag) {
                if (tag.func_150297_b("Scope", 10)) {
                    this.scope = this.createScope(tag, "Scope");
                }
                if (tag.func_150297_b("Barrel", 10)) {
                    this.barrel = this.createBarrel(tag, "Barrel");
                }
                if (tag.func_150297_b("Stock", 10)) {
                    this.stock = this.createScaledPositioned(tag, "Stock");
                }
                if (tag.func_150297_b("UnderBarrel", 10)) {
                    this.underBarrel = this.createScaledPositioned(tag, "UnderBarrel");
                }
                if (tag.func_150297_b("OldScope", 10)) {
                    this.oldScope = this.createOldScope(tag, "OldScope");
                }
                if (tag.func_150297_b("GunSkin", 10)) {
                    this.gunSkin = this.createScaledPositioned(tag, "GunSkin");
                }
                if (tag.func_150297_b("AmmoPlug", 10)) {
                    this.ammoPlug = this.createScaledPositioned(tag, "AmmoPlug");
                }
                if (tag.func_150297_b("SideRail", 10)) {
                    this.sideRail = this.createScaledPositioned(tag, "SideRail");
                }
                if (tag.func_150297_b("IrDevice", 10)) {
                    this.irDevice = this.createScaledPositioned(tag, "IrDevice");
                }
                if (tag.func_150297_b("ExtendedMag", 10)) {
                    this.extendedMag = this.createScaledPositioned(tag, "ExtendedMag");
                }
                if (tag.func_150297_b("PistolScope", 10)) {
                    this.pistolScope = this.createPistolScope(tag, "PistolScope");
                }
                if (tag.func_150297_b("PistolBarrel", 10)) {
                    this.pistolBarrel = this.createPistolBarrel(tag, "PistolBarrel");
                }
            }

            public Attachments copy() {
                Attachments attachments = new Attachments();
                if (this.scope != null) {
                    attachments.scope = this.scope.copy();
                }
                if (this.barrel != null) {
                    attachments.barrel = this.barrel.copy();
                }
                if (this.stock != null) {
                    attachments.stock = this.stock.copy();
                }
                if (this.underBarrel != null) {
                    attachments.underBarrel = this.underBarrel.copy();
                }
                if (this.oldScope != null) {
                    attachments.oldScope = this.oldScope.copy();
                }
                if (this.gunSkin != null) {
                    attachments.gunSkin = this.gunSkin.copy();
                }
                if (this.ammoPlug != null) {
                    attachments.ammoPlug = this.ammoPlug.copy();
                }
                if (this.sideRail != null) {
                    attachments.sideRail = this.sideRail.copy();
                }
                if (this.irDevice != null) {
                    attachments.irDevice = this.irDevice.copy();
                }
                if (this.extendedMag != null) {
                    attachments.extendedMag = this.extendedMag.copy();
                }
                if (this.pistolScope != null) {
                    attachments.pistolScope = this.pistolScope.copy();
                }
                if (this.pistolBarrel != null) {
                    attachments.pistolBarrel = this.pistolBarrel.copy();
                }
                return attachments;
            }

            @Nullable
            private ScaledPositioned createScaledPositioned(CompoundNBT tag, String key) {
                CompoundNBT attachment = tag.func_74775_l(key);
                return attachment.isEmpty() ? null : new ScaledPositioned(attachment);
            }

            @Nullable
            private PistolScope createPistolScope(CompoundNBT tag, String key) {
                CompoundNBT attachment = tag.func_74775_l(key);
                return attachment.isEmpty() ? null : new PistolScope(attachment){

                    @Override
                    public double getXOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
                    }

                    @Override
                    public double getYOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
                    }

                    @Override
                    public double getZOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
                    }

                    @Override
                    public double getScale() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolScope ? this.scale + GunEditor.get().getSizeMod() : this.scale;
                    }
                };
            }

            @Nullable
            private ScaledPositioned createScope(CompoundNBT tag, String key) {
                CompoundNBT attachment = tag.func_74775_l(key);
                return attachment.isEmpty() ? null : new ScaledPositioned(attachment){

                    @Override
                    public double getXOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.scope ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
                    }

                    @Override
                    public double getYOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.scope ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
                    }

                    @Override
                    public double getZOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.scope ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
                    }

                    @Override
                    public double getScale() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.scope ? this.scale + GunEditor.get().getSizeMod() : this.scale;
                    }
                };
            }

            @Nullable
            private ScaledPositioned createBarrel(CompoundNBT tag, String key) {
                CompoundNBT attachment = tag.func_74775_l(key);
                return attachment.isEmpty() ? null : new ScaledPositioned(attachment){

                    @Override
                    public double getXOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.barrel ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
                    }

                    @Override
                    public double getYOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.barrel ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
                    }

                    @Override
                    public double getZOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.barrel ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
                    }

                    @Override
                    public double getScale() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.barrel ? this.scale + GunEditor.get().getSizeMod() : this.scale;
                    }
                };
            }

            @Nullable
            private ScaledPositioned createPistolBarrel(CompoundNBT tag, String key) {
                CompoundNBT attachment = tag.func_74775_l(key);
                return attachment.isEmpty() ? null : new ScaledPositioned(attachment){

                    @Override
                    public double getXOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolBarrel ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
                    }

                    @Override
                    public double getYOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolBarrel ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
                    }

                    @Override
                    public double getZOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolBarrel ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
                    }

                    @Override
                    public double getScale() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.pistolBarrel ? this.scale + GunEditor.get().getSizeMod() : this.scale;
                    }
                };
            }

            @Nullable
            private ScaledPositioned createOldScope(CompoundNBT tag, String key) {
                CompoundNBT attachment = tag.func_74775_l(key);
                return attachment.isEmpty() ? null : new ScaledPositioned(attachment){

                    @Override
                    public double getXOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.oldScope ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
                    }

                    @Override
                    public double getYOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.oldScope ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
                    }

                    @Override
                    public double getZOffset() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.oldScope ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
                    }

                    @Override
                    public double getScale() {
                        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.oldScope ? this.scale + GunEditor.get().getSizeMod() : this.scale;
                    }
                };
            }
        }

        public static class Zoom
        extends Positioned {
            @Optional
            private float fovModifier;
            @Optional
            private double stabilityOffset = 0.225;

            @Override
            public CompoundNBT serializeNBT() {
                CompoundNBT tag = super.serializeNBT();
                tag.func_74776_a("FovModifier", this.fovModifier);
                tag.func_74780_a("StabilityOffset", this.stabilityOffset);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundNBT tag) {
                super.deserializeNBT(tag);
                if (tag.func_150297_b("FovModifier", 99)) {
                    this.fovModifier = tag.func_74760_g("FovModifier");
                }
                if (tag.func_150297_b("StabilityOffset", 99)) {
                    this.stabilityOffset = tag.func_74769_h("StabilityOffset");
                }
            }

            @Override
            public Zoom copy() {
                Zoom zoom = new Zoom();
                zoom.fovModifier = this.fovModifier;
                zoom.stabilityOffset = this.stabilityOffset;
                zoom.xOffset = this.xOffset;
                zoom.yOffset = this.yOffset;
                zoom.zOffset = this.zOffset;
                return zoom;
            }

            public float getFovModifier() {
                return this.fovModifier;
            }

            public double getStabilityOffset() {
                return this.stabilityOffset;
            }

            @Override
            public double getXOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.zoom ? super.getXOffset() + GunEditor.get().getxMod() : super.getXOffset();
            }

            @Override
            public double getYOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.zoom ? super.getYOffset() + GunEditor.get().getyMod() : super.getYOffset();
            }

            @Override
            public double getZOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.zoom ? super.getZOffset() + GunEditor.get().getzMod() : super.getZOffset();
            }
        }
    }

    public static class Display
    implements INBTSerializable<CompoundNBT> {
        @Optional
        @Nullable
        private Flash flash;
        @Optional
        @Nullable
        private ShellCasing shellCasing;
        @Optional
        private int weaponType = 0;
        @Optional
        private float hipfireScale = 0.75f;
        @Optional
        private float hipfireMoveScale = 0.5f;
        @Optional
        private float hipfireRecoilScale = 1.0f;
        @Optional
        private boolean showDynamicHipfire = true;

        public float getHipfireScale() {
            return this.hipfireScale;
        }

        public float getHipfireMoveScale() {
            return this.hipfireMoveScale;
        }

        public float getHipfireRecoilScale() {
            return this.hipfireRecoilScale;
        }

        public boolean isDynamicHipfire() {
            return this.showDynamicHipfire;
        }

        public WeaponType getWeaponType() {
            return WeaponType.values()[this.weaponType];
        }

        @Nullable
        public Flash getFlash() {
            return this.flash;
        }

        @Nullable
        public ShellCasing getShellCasing() {
            return this.shellCasing;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            if (this.flash != null) {
                tag.func_218657_a("Flash", (INBT)this.flash.serializeNBT());
            }
            if (this.shellCasing != null) {
                tag.func_218657_a("ShellCasing", (INBT)this.shellCasing.serializeNBT());
            }
            tag.func_74776_a("HipFireScale", this.hipfireScale);
            tag.func_74776_a("HipFireMoveScale", this.hipfireMoveScale);
            tag.func_74776_a("HipFireRecoilScale", this.hipfireRecoilScale / 2.0f);
            tag.func_74757_a("ShowDynamicHipfire", this.showDynamicHipfire);
            tag.func_74768_a("WeaponType", this.weaponType);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("Flash", 10)) {
                CompoundNBT flashTag = tag.func_74775_l("Flash");
                if (!flashTag.isEmpty()) {
                    Flash flash = new Flash();
                    flash.deserializeNBT(tag.func_74775_l("Flash"));
                    this.flash = flash;
                } else {
                    this.flash = null;
                }
            }
            if (tag.func_150297_b("ShellCasing", 10)) {
                CompoundNBT casingTag = tag.func_74775_l("ShellCasing");
                if (!casingTag.isEmpty()) {
                    ShellCasing shellCasing = new ShellCasing();
                    shellCasing.deserializeNBT(casingTag);
                    this.shellCasing = shellCasing;
                } else {
                    this.shellCasing = null;
                }
            }
            if (tag.func_150297_b("HipFireScale", 99)) {
                this.hipfireScale = tag.func_74760_g("HipFireScale");
            }
            if (tag.func_150297_b("HipFireMoveScale", 99)) {
                this.hipfireMoveScale = tag.func_74760_g("HipFireMoveScale");
            }
            if (tag.func_150297_b("HipFireRecoilScale", 99)) {
                this.hipfireRecoilScale = tag.func_74760_g("HipFireRecoilScale");
            }
            if (tag.func_150297_b("ShowDynamicHipfire", 99)) {
                this.showDynamicHipfire = tag.func_74767_n("ShowDynamicHipfire");
            }
            if (tag.func_150297_b("WeaponType", 99)) {
                this.weaponType = tag.func_74762_e("WeaponType");
            }
        }

        public Display copy() {
            Display display = new Display();
            if (this.flash != null) {
                display.flash = this.flash.copy();
            }
            if (this.shellCasing != null) {
                display.shellCasing = this.shellCasing.copy();
            }
            if (this.hipfireScale != 0.0f) {
                display.hipfireScale = this.hipfireScale;
            }
            if (this.hipfireMoveScale != 0.0f) {
                display.hipfireMoveScale = this.hipfireMoveScale;
            }
            if (this.hipfireRecoilScale != 0.0f) {
                display.hipfireRecoilScale = this.hipfireRecoilScale;
            }
            if (this.weaponType != 0) {
                display.weaponType = this.weaponType;
            }
            display.hipfireRecoilScale = this.hipfireRecoilScale;
            return display;
        }

        public static class Flash
        extends Positioned {
            private double size = 0.5;
            private double smokeSize = 2.0;
            private double trailAdjust = 1.15;

            @Override
            public CompoundNBT serializeNBT() {
                CompoundNBT tag = super.serializeNBT();
                tag.func_74780_a("Scale", this.size);
                tag.func_74780_a("SmokeSize", this.smokeSize);
                tag.func_74780_a("TrailAdjust", this.trailAdjust);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundNBT tag) {
                super.deserializeNBT(tag);
                if (tag.func_150297_b("Scale", 99)) {
                    this.size = tag.func_74769_h("Scale");
                }
                if (tag.func_150297_b("TrailAdjust", 99)) {
                    this.trailAdjust = tag.func_74769_h("TrailAdjust");
                }
                if (tag.func_150297_b("SmokeSize", 99)) {
                    this.smokeSize = tag.func_74769_h("SmokeSize");
                }
            }

            @Override
            public Flash copy() {
                Flash flash = new Flash();
                flash.size = this.size;
                flash.smokeSize = this.smokeSize;
                flash.trailAdjust = this.trailAdjust;
                flash.xOffset = this.xOffset;
                flash.yOffset = this.yOffset;
                flash.zOffset = this.zOffset;
                return flash;
            }

            public double getSize() {
                return this.size;
            }

            @Override
            public double getXOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash ? this.xOffset + GunEditor.get().getxMod() : this.xOffset;
            }

            @Override
            public double getYOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash ? this.yOffset + GunEditor.get().getyMod() : this.yOffset;
            }

            @Override
            public double getZOffset() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash ? this.zOffset + GunEditor.get().getzMod() : this.zOffset;
            }

            public double getTrailAdjust() {
                return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.flash ? this.trailAdjust + GunEditor.get().getSizeMod() : this.trailAdjust;
            }

            public double getSmokeSize() {
                return this.smokeSize;
            }
        }
    }

    public static class Sounds
    implements INBTSerializable<CompoundNBT> {
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation fire;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reload;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadEmpty;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadNormal;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation pump;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation pullBolt;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadIntro;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadLoop;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadEnd;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation reloadEndEmpty;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation draw;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation inspect;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation inspectEmpty;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation cock;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation noammo;
        @Optional
        @Nullable
        @TGExclude
        private ResourceLocation silencedFire;

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            if (this.fire != null) {
                tag.func_74778_a("Fire", this.fire.toString());
            }
            if (this.reload != null) {
                tag.func_74778_a("Reload", this.reload.toString());
            }
            if (this.cock != null) {
                tag.func_74778_a("Cock", this.cock.toString());
            }
            if (this.silencedFire != null) {
                tag.func_74778_a("SilencedFire", this.silencedFire.toString());
            }
            if (this.reloadEmpty != null) {
                tag.func_74778_a("ReloadEmpty", this.reloadEmpty.toString());
            }
            if (this.draw != null) {
                tag.func_74778_a("Draw", this.draw.toString());
            }
            if (this.inspectEmpty != null) {
                tag.func_74778_a("InspectEmpty", this.inspectEmpty.toString());
            }
            if (this.inspect != null) {
                tag.func_74778_a("Inspect", this.inspect.toString());
            }
            if (this.reloadNormal != null) {
                tag.func_74778_a("ReloadNormal", this.reloadNormal.toString());
            }
            if (this.pump != null) {
                tag.func_74778_a("Pump", this.pump.toString());
            }
            if (this.reloadIntro != null) {
                tag.func_74778_a("ReloadIntro", this.reloadIntro.toString());
            }
            if (this.reloadLoop != null) {
                tag.func_74778_a("ReloadLoop", this.reloadLoop.toString());
            }
            if (this.reloadEnd != null) {
                tag.func_74778_a("ReloadEnd", this.reloadEnd.toString());
            }
            if (this.pullBolt != null) {
                tag.func_74778_a("PullBolt", this.pullBolt.toString());
            }
            if (this.reloadEndEmpty != null) {
                tag.func_74778_a("ReloadEndEmpty", this.reloadEndEmpty.toString());
            }
            tag.func_74778_a("Noammo", "tac:item.noammo");
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("Fire", 8)) {
                this.fire = this.createSound(tag, "Fire");
            }
            if (tag.func_150297_b("Reload", 8)) {
                this.reload = this.createSound(tag, "Reload");
            }
            if (tag.func_150297_b("Cock", 8)) {
                this.cock = this.createSound(tag, "Cock");
            }
            if (tag.func_150297_b("Noammo", 8)) {
                this.noammo = this.createSound(tag, "Noammo");
            }
            if (tag.func_150297_b("SilencedFire", 8)) {
                this.silencedFire = this.createSound(tag, "SilencedFire");
            }
            if (tag.func_150297_b("ReloadEmpty", 8)) {
                this.reloadEmpty = this.createSound(tag, "ReloadEmpty");
            }
            if (tag.func_150297_b("Draw", 8)) {
                this.draw = this.createSound(tag, "Draw");
            }
            if (tag.func_150297_b("InspectEmpty", 8)) {
                this.inspectEmpty = this.createSound(tag, "InspectEmpty");
            }
            if (tag.func_150297_b("Inspect", 8)) {
                this.inspect = this.createSound(tag, "Inspect");
            }
            if (tag.func_150297_b("ReloadNormal", 8)) {
                this.reloadNormal = this.createSound(tag, "ReloadNormal");
            }
            if (tag.func_150297_b("Pump", 8)) {
                this.pump = this.createSound(tag, "Pump");
            }
            if (tag.func_150297_b("ReloadIntro", 8)) {
                this.reloadIntro = this.createSound(tag, "ReloadIntro");
            }
            if (tag.func_150297_b("ReloadLoop", 8)) {
                this.reloadLoop = this.createSound(tag, "ReloadLoop");
            }
            if (tag.func_150297_b("ReloadEnd", 8)) {
                this.reloadEnd = this.createSound(tag, "ReloadEnd");
            }
            if (tag.func_150297_b("PullBolt", 8)) {
                this.pullBolt = this.createSound(tag, "PullBolt");
            }
            if (tag.func_150297_b("ReloadEndEmpty", 8)) {
                this.reloadEndEmpty = this.createSound(tag, "ReloadEndEmpty");
            }
        }

        public Sounds copy() {
            Sounds sounds = new Sounds();
            sounds.fire = this.fire;
            sounds.reload = this.reload;
            sounds.cock = this.cock;
            sounds.noammo = this.noammo;
            sounds.silencedFire = this.silencedFire;
            sounds.reloadEmpty = this.reloadEmpty;
            sounds.draw = this.draw;
            sounds.inspectEmpty = this.inspectEmpty;
            sounds.inspect = this.inspect;
            sounds.reloadNormal = this.reloadNormal;
            sounds.pump = this.pump;
            sounds.reloadIntro = this.reloadIntro;
            sounds.reloadLoop = this.reloadLoop;
            sounds.reloadEnd = this.reloadEnd;
            sounds.pullBolt = this.pullBolt;
            sounds.reloadEndEmpty = this.reloadEndEmpty;
            return sounds;
        }

        @Nullable
        private ResourceLocation createSound(CompoundNBT tag, String key) {
            String sound = tag.func_74779_i(key);
            return sound.isEmpty() ? null : new ResourceLocation(sound);
        }

        @Nullable
        private ResourceLocation createSound(String sound) {
            return sound.isEmpty() ? null : new ResourceLocation(sound);
        }

        @Nullable
        public ResourceLocation getFire() {
            return this.fire;
        }

        @Nullable
        public ResourceLocation getReload() {
            return this.reload;
        }

        @Nullable
        public ResourceLocation getCock() {
            return this.cock;
        }

        @Nullable
        public ResourceLocation getNoammo() {
            return this.noammo;
        }

        @Nullable
        public ResourceLocation getSilencedFire() {
            return this.silencedFire;
        }

        @Nullable
        public ResourceLocation getReloadEmpty() {
            return this.reloadEmpty;
        }

        @Nullable
        public ResourceLocation getDraw() {
            return this.draw;
        }

        @Nullable
        public ResourceLocation getInspectEmpty() {
            return this.inspectEmpty != null ? this.inspectEmpty : this.inspect;
        }

        @Nullable
        public ResourceLocation getInspect() {
            return this.inspect;
        }

        @Nullable
        public ResourceLocation getReloadNormal() {
            return this.reloadNormal;
        }

        @Nullable
        public ResourceLocation getPump() {
            return this.pump;
        }

        @Nullable
        public ResourceLocation getReloadIntro() {
            return this.reloadIntro;
        }

        @Nullable
        public ResourceLocation getReloadLoop() {
            return this.reloadLoop;
        }

        @Nullable
        public ResourceLocation getReloadEnd() {
            return this.reloadEnd;
        }

        @Nullable
        public ResourceLocation getPullBolt() {
            return this.pullBolt;
        }

        @Nullable
        public ResourceLocation getReloadEndEmpty() {
            return this.reloadEndEmpty;
        }
    }

    public static class AmmoPlugEffect
    implements INBTSerializable<CompoundNBT> {
        @Optional
        private int[] fmjModifyArmorIgnore = new int[]{120, 120, 120};
        @Optional
        private int[] fmjModifyDamage = new int[]{95, 95, 95};
        @Optional
        private int[] fmjModifySpeed = new int[]{100, 100, 100};
        @Optional
        private int[] heModifyArmorIgnore = new int[]{100, 100, 100};
        @Optional
        private int[] heModifyDamage = new int[]{95, 95, 95};
        @Optional
        private int[] heModifySpeed = new int[]{100, 100, 100};
        @Optional
        private int[] heModifyBlastDamage = new int[]{140, 140, 140};
        @Optional
        private int[] heModifyBlastRange = new int[]{100, 100, 100};
        @Optional
        private int[] hpModifyArmorIgnore = new int[]{60, 60, 60};
        @Optional
        private int[] hpModifyDamage = new int[]{120, 120, 120};
        @Optional
        private int[] hpModifySpeed = new int[]{85, 85, 85};
        @Optional
        private int[] iModifyArmorIgnore = new int[]{80, 80, 80};
        @Optional
        private int[] iModifyDamage = new int[]{100, 100, 100};
        @Optional
        private int[] iModifySpeed = new int[]{100, 100, 100};
        @Optional
        private int[] igniteTick = new int[]{20, 20, 20};
        @Optional
        private int[] igniteDamage = new int[]{1, 1, 1};

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74783_a("FmjModifyArmorIgnore", this.fmjModifyArmorIgnore);
            tag.func_74783_a("FmjModifyDamage", this.fmjModifyDamage);
            tag.func_74783_a("FmjModifySpeed", this.fmjModifySpeed);
            tag.func_74783_a("HeModifyArmorIgnore", this.heModifyArmorIgnore);
            tag.func_74783_a("HeModifyDamage", this.heModifyDamage);
            tag.func_74783_a("HeModifySpeed", this.heModifySpeed);
            tag.func_74783_a("HeModifyBlastDamage", this.heModifyBlastDamage);
            tag.func_74783_a("HeModifyBlastRange", this.heModifyBlastRange);
            tag.func_74783_a("HpModifyArmorIgnore", this.hpModifyArmorIgnore);
            tag.func_74783_a("HpModifyDamage", this.hpModifyDamage);
            tag.func_74783_a("HpModifySpeed", this.hpModifySpeed);
            tag.func_74783_a("IModifyArmorIgnore", this.iModifyArmorIgnore);
            tag.func_74783_a("IModifyDamage", this.iModifyDamage);
            tag.func_74783_a("IModifySpeed", this.iModifySpeed);
            tag.func_74783_a("IgniteTick", this.igniteTick);
            tag.func_74783_a("IgniteDamage", this.igniteDamage);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("FmjModifyArmorIgnore", 99)) {
                this.fmjModifyArmorIgnore = tag.func_74759_k("FmjModifyArmorIgnore");
            }
            if (tag.func_150297_b("FmjModifyDamage", 99)) {
                this.fmjModifyDamage = tag.func_74759_k("FmjModifyDamage");
            }
            if (tag.func_150297_b("FmjModifySpeed", 99)) {
                this.fmjModifySpeed = tag.func_74759_k("FmjModifySpeed");
            }
            if (tag.func_150297_b("HeModifyArmorIgnore", 99)) {
                this.heModifyArmorIgnore = tag.func_74759_k("HeModifyArmorIgnore");
            }
            if (tag.func_150297_b("HeModifyDamage", 99)) {
                this.heModifyDamage = tag.func_74759_k("HeModifyDamage");
            }
            if (tag.func_150297_b("HeModifySpeed", 99)) {
                this.heModifySpeed = tag.func_74759_k("HeModifySpeed");
            }
            if (tag.func_150297_b("HeModifyBlastDamage", 99)) {
                this.heModifyBlastDamage = tag.func_74759_k("HeModifyBlastDamage");
            }
            if (tag.func_150297_b("HeModifyBlastRange", 99)) {
                this.heModifyBlastRange = tag.func_74759_k("HeModifyBlastRange");
            }
            if (tag.func_150297_b("HpModifyArmorIgnore", 99)) {
                this.hpModifyArmorIgnore = tag.func_74759_k("HpModifyArmorIgnore");
            }
            if (tag.func_150297_b("HpModifyDamage", 99)) {
                this.hpModifyDamage = tag.func_74759_k("HpModifyDamage");
            }
            if (tag.func_150297_b("HpModifySpeed", 99)) {
                this.hpModifySpeed = tag.func_74759_k("HpModifySpeed");
            }
            if (tag.func_150297_b("IModifyArmorIgnore", 99)) {
                this.iModifyArmorIgnore = tag.func_74759_k("IModifyArmorIgnore");
            }
            if (tag.func_150297_b("IModifyDamage", 99)) {
                this.iModifyDamage = tag.func_74759_k("IModifyDamage");
            }
            if (tag.func_150297_b("IModifySpeed", 99)) {
                this.iModifySpeed = tag.func_74759_k("IModifySpeed");
            }
            if (tag.func_150297_b("IgniteTick", 99)) {
                this.igniteTick = tag.func_74759_k("IgniteTick");
            }
            if (tag.func_150297_b("IgniteDamage", 99)) {
                this.igniteDamage = tag.func_74759_k("IgniteDamage");
            }
        }

        public AmmoPlugEffect copy() {
            AmmoPlugEffect ammoPlugEffect = new AmmoPlugEffect();
            ammoPlugEffect.fmjModifyArmorIgnore = this.fmjModifyArmorIgnore;
            ammoPlugEffect.fmjModifyDamage = this.fmjModifyDamage;
            ammoPlugEffect.fmjModifySpeed = this.fmjModifySpeed;
            ammoPlugEffect.heModifyArmorIgnore = this.heModifyArmorIgnore;
            ammoPlugEffect.heModifyDamage = this.heModifyDamage;
            ammoPlugEffect.heModifySpeed = this.heModifySpeed;
            ammoPlugEffect.heModifyBlastDamage = this.heModifyBlastDamage;
            ammoPlugEffect.heModifyBlastRange = this.heModifyBlastRange;
            ammoPlugEffect.hpModifyArmorIgnore = this.hpModifyArmorIgnore;
            ammoPlugEffect.hpModifyDamage = this.hpModifyDamage;
            ammoPlugEffect.hpModifySpeed = this.hpModifySpeed;
            ammoPlugEffect.iModifyArmorIgnore = this.iModifyArmorIgnore;
            ammoPlugEffect.iModifyDamage = this.iModifyDamage;
            ammoPlugEffect.iModifySpeed = this.iModifySpeed;
            ammoPlugEffect.igniteTick = this.igniteTick;
            ammoPlugEffect.igniteDamage = this.igniteDamage;
            return ammoPlugEffect;
        }

        public int[] getFmjModifyArmorIgnore() {
            return this.fmjModifyArmorIgnore;
        }

        public int[] getFmjModifyDamage() {
            return this.fmjModifyDamage;
        }

        public int[] getFmjModifySpeed() {
            return this.fmjModifySpeed;
        }

        public int[] getHeModifyArmorIgnore() {
            return this.heModifyArmorIgnore;
        }

        public int[] getHeModifyDamage() {
            return this.heModifyDamage;
        }

        public int[] getHeModifySpeed() {
            return this.heModifySpeed;
        }

        public int[] getHeModifyBlastDamage() {
            return this.heModifyBlastDamage;
        }

        public int[] getHeModifyBlastRange() {
            return this.heModifyBlastRange;
        }

        public int[] getHpModifyArmorIgnore() {
            return this.hpModifyArmorIgnore;
        }

        public int[] getHpModifyDamage() {
            return this.hpModifyDamage;
        }

        public int[] getHpModifySpeed() {
            return this.hpModifySpeed;
        }

        public int[] getIModifyArmorIgnore() {
            return this.iModifyArmorIgnore;
        }

        public int[] getIModifyDamage() {
            return this.iModifyDamage;
        }

        public int[] getIModifySpeed() {
            return this.iModifySpeed;
        }

        public int[] getIgniteTick() {
            return this.igniteTick;
        }

        public int[] getIgniteDamage() {
            return this.igniteDamage;
        }
    }

    public static class Projectile
    implements INBTSerializable<CompoundNBT> {
        @Optional
        private boolean visible = true;
        @Optional
        private float damage;
        @Optional
        private boolean hasBlastDamage = false;
        @Optional
        private float blastDamage = 2.0f;
        @Optional
        private float blastRadius = 0.5f;
        @Optional
        private float armorIgnore = 1.0f;
        @Optional
        private float critical = 0.0f;
        @Optional
        private float criticalDamage = 1.0f;
        @Optional
        private float headDamage = 1.0f;
        @Optional
        private float closeDamage = 1.0f;
        @Optional
        private float decayStart = 0.0f;
        @Optional
        private float minDecayMultiplier = 0.1f;
        @Optional
        private float decayEnd = 1.0f;
        @Ignored
        private float size = 0.1f;
        @Optional
        private double speed;
        @Optional
        private int life;
        @Optional
        private int pierce = 1;
        @Optional
        private boolean gravity = true;
        @Optional
        private boolean damageReduceOverLife = true;
        @Optional
        private int trailColor = 16765577;
        @Optional
        private double trailLengthMultiplier = 4.35;
        @Optional
        private float trailRotationMultiplier = 0.0175f;
        @Optional
        private boolean ricochet = true;
        @TGExclude
        private ResourceLocation item = new ResourceLocation("tac", "basic_ammo");
        @Optional
        private int bulletClass = 1;
        @Optional
        private float bluntDamagePercentage = 0.5f;

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("Item", this.item.toString());
            tag.func_74757_a("Visible", this.visible);
            tag.func_74776_a("Damage", this.damage);
            tag.func_74757_a("HasBlastDamage", this.hasBlastDamage);
            tag.func_74776_a("BlastDamage", this.blastDamage);
            tag.func_74776_a("BlastRadius", this.blastRadius);
            tag.func_74776_a("ArmorIgnore", this.armorIgnore);
            tag.func_74776_a("Critical", this.critical);
            tag.func_74776_a("CriticalDamage", this.criticalDamage);
            tag.func_74776_a("HeadDamage", this.headDamage);
            tag.func_74776_a("CloseDamage", this.closeDamage);
            tag.func_74776_a("DecayStart", this.decayStart);
            tag.func_74776_a("MinDecayMultiplier", this.minDecayMultiplier);
            tag.func_74776_a("DecayEnd", this.decayEnd);
            tag.func_74776_a("Size", this.size);
            tag.func_74780_a("Speed", this.speed);
            tag.func_74768_a("Life", this.life);
            tag.func_74768_a("Pierce", this.pierce);
            tag.func_74757_a("Gravity", this.gravity);
            tag.func_74757_a("DamageReduceOverLife", this.damageReduceOverLife);
            tag.func_74768_a("TrailColor", this.trailColor);
            tag.func_74780_a("TrailLengthMultiplier", this.trailLengthMultiplier);
            tag.func_74776_a("TrailRotationMultiplier", this.trailRotationMultiplier);
            tag.func_74757_a("Ricochet", this.ricochet);
            tag.func_74768_a("BulletClass", this.bulletClass);
            tag.func_74776_a("BluntDamagePercentage", this.bluntDamagePercentage);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("Item", 8)) {
                this.item = new ResourceLocation(tag.func_74779_i("Item"));
            }
            if (tag.func_150297_b("Visible", 99)) {
                this.visible = tag.func_74767_n("Visible");
            }
            if (tag.func_150297_b("Damage", 99)) {
                this.damage = tag.func_74760_g("Damage");
            }
            if (tag.func_150297_b("HasBlastDamage", 99)) {
                this.hasBlastDamage = tag.func_74767_n("HasBlastDamage");
            }
            if (tag.func_150297_b("BlastDamage", 99)) {
                this.blastDamage = tag.func_74760_g("BlastDamage");
            }
            if (tag.func_150297_b("BlastRadius", 99)) {
                this.blastRadius = tag.func_74760_g("BlastRadius");
            }
            if (tag.func_150297_b("ArmorIgnore", 99)) {
                this.armorIgnore = tag.func_74760_g("ArmorIgnore");
            }
            if (tag.func_150297_b("Critical", 99)) {
                this.critical = tag.func_74760_g("Critical");
            }
            if (tag.func_150297_b("CriticalDamage", 99)) {
                this.criticalDamage = tag.func_74760_g("CriticalDamage");
            }
            if (tag.func_150297_b("HeadDamage", 99)) {
                this.headDamage = tag.func_74760_g("HeadDamage");
            }
            if (tag.func_150297_b("CloseDamage", 99)) {
                this.closeDamage = tag.func_74760_g("CloseDamage");
            }
            if (tag.func_150297_b("DecayStart", 99)) {
                this.decayStart = tag.func_74760_g("DecayStart");
            }
            if (tag.func_150297_b("MinDecayMultiplier", 99)) {
                this.minDecayMultiplier = tag.func_74760_g("MinDecayMultiplier");
            }
            if (tag.func_150297_b("DecayEnd", 99)) {
                this.decayEnd = tag.func_74760_g("DecayEnd");
            }
            if (tag.func_150297_b("Size", 99)) {
                this.size = tag.func_74760_g("Size");
            }
            if (tag.func_150297_b("Speed", 99)) {
                this.speed = tag.func_74769_h("Speed");
            }
            if (tag.func_150297_b("Life", 99)) {
                this.life = tag.func_74762_e("Life");
            }
            if (tag.func_150297_b("Pierce", 99)) {
                this.pierce = tag.func_74762_e("Pierce");
            }
            if (tag.func_150297_b("Gravity", 99)) {
                this.gravity = tag.func_74767_n("Gravity");
            }
            if (tag.func_150297_b("DamageReduceOverLife", 99)) {
                this.damageReduceOverLife = tag.func_74767_n("DamageReduceOverLife");
            }
            if (tag.func_150297_b("TrailColor", 99)) {
                this.trailColor = tag.func_74762_e("TrailColor");
            }
            if (tag.func_150297_b("TrailLengthMultiplier", 99)) {
                this.trailLengthMultiplier = tag.func_74769_h("TrailLengthMultiplier");
            }
            if (tag.func_150297_b("TrailRotationMultiplier", 99)) {
                this.trailRotationMultiplier = tag.func_74760_g("TrailRotationMultiplier");
            }
            if (tag.func_150297_b("Ricochet", 99)) {
                this.ricochet = tag.func_74767_n("Ricochet");
            }
            if (tag.func_150297_b("BulletClass", 99)) {
                this.bulletClass = tag.func_74762_e("BulletClass");
            }
            if (tag.func_150297_b("BluntDamagePercentage", 99)) {
                this.bluntDamagePercentage = tag.func_74760_g("bluntDamagePercentage");
            }
        }

        public Projectile copy() {
            Projectile projectile = new Projectile();
            projectile.item = this.item;
            projectile.visible = this.visible;
            projectile.damage = this.damage;
            projectile.hasBlastDamage = this.hasBlastDamage;
            projectile.blastDamage = this.blastDamage;
            projectile.blastRadius = this.blastRadius;
            projectile.armorIgnore = this.armorIgnore;
            projectile.critical = this.critical;
            projectile.criticalDamage = this.criticalDamage;
            projectile.headDamage = this.headDamage;
            projectile.closeDamage = this.closeDamage;
            projectile.decayStart = this.decayStart;
            projectile.minDecayMultiplier = this.minDecayMultiplier;
            projectile.decayEnd = this.decayEnd;
            projectile.size = this.size;
            projectile.speed = this.speed;
            projectile.life = this.life;
            projectile.pierce = this.pierce;
            projectile.gravity = this.gravity;
            projectile.damageReduceOverLife = this.damageReduceOverLife;
            projectile.trailColor = this.trailColor;
            projectile.trailLengthMultiplier = this.trailLengthMultiplier;
            projectile.trailRotationMultiplier = this.trailRotationMultiplier;
            projectile.ricochet = this.ricochet;
            projectile.bulletClass = this.bulletClass;
            projectile.bluntDamagePercentage = this.bluntDamagePercentage;
            return projectile;
        }

        public ResourceLocation getItem() {
            return this.item;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public float getDamage() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.damage + GunEditor.get().getDamageMod() : this.damage;
        }

        public boolean isHasBlastDamage() {
            return this.hasBlastDamage;
        }

        public float getBlastDamage() {
            return this.blastDamage;
        }

        public float getBlastRadius() {
            return this.blastRadius;
        }

        public float getGunArmorIgnore() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.armorIgnore + GunEditor.get().getArmorIgnoreMod() : this.armorIgnore;
        }

        public float getGunCritical() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.critical + GunEditor.get().getCriticalMod() : this.critical;
        }

        public float getGunCriticalDamage() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.criticalDamage + GunEditor.get().getCriticalDamageMod() : this.criticalDamage;
        }

        public float getGunHeadDamage() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.headDamage + GunEditor.get().getHeadDamageMod() : this.headDamage;
        }

        public float getGunCloseDamage() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.closeDamage + GunEditor.get().getCloseDamageMod() : this.closeDamage;
        }

        public float getGunDecayStart() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.decayStart + GunEditor.get().getDecayStartMod() : this.decayStart;
        }

        public float getGunMinDecayMultiplier() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.minDecayMultiplier + GunEditor.get().getMinDecayMultiplierMod() : this.minDecayMultiplier;
        }

        public float getGunDecayEnd() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.decayEnd + GunEditor.get().getDecayEndMod() : this.decayEnd;
        }

        public float getSize() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.size + GunEditor.get().getDamageMod() : this.size;
        }

        public double getSpeed() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? this.speed + GunEditor.get().getSpeedMod() : this.speed;
        }

        public int getLife() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.projectile ? (int)((double)this.life + GunEditor.get().getLifeMod()) : this.life;
        }

        public int getPierce() {
            return this.pierce;
        }

        public boolean isGravity() {
            return this.gravity;
        }

        public boolean isDamageReduceOverLife() {
            return this.damageReduceOverLife;
        }

        public int getTrailColor() {
            return this.trailColor;
        }

        public double getTrailLengthMultiplier() {
            return this.trailLengthMultiplier;
        }

        public float getTrailRotationMultiplier() {
            return this.trailRotationMultiplier;
        }

        public boolean isRicochet() {
            return this.ricochet;
        }

        public int getBulletClass() {
            return this.bulletClass;
        }

        public float getBluntDamagePercentage() {
            return this.bluntDamagePercentage;
        }
    }

    public static class Reloads
    implements INBTSerializable<CompoundNBT> {
        private int maxAmmo = 20;
        @Optional
        private boolean magFed = false;
        @Optional
        private boolean noMag = false;
        @Optional
        private boolean isHeat = false;
        @Optional
        private boolean isBarrel = false;
        @Optional
        private int tickToHeat = 200;
        @Optional
        private int tickOverHeat = 40;
        @Optional
        private int heatRecover = 1;
        @Optional
        private int delay = 0;
        @Optional
        private int reloadMagTimer = 20;
        @Optional
        private int additionalReloadEmptyMagTimer = 0;
        @Optional
        private int reloadAmount = 1;
        @Optional
        private int[] maxAdditionalAmmoPerOC = new int[0];
        @Optional
        private int preReloadPauseTicks = 0;
        @Optional
        private int interReloadPauseTicks = 1;
        @Optional
        private boolean openBolt = false;
        @Optional
        private int stripperClipReloadAmount = 5;
        @Optional
        private boolean stripperClip = false;

        public int getStripperClipReloadAmount() {
            return this.stripperClipReloadAmount;
        }

        public boolean isStripperClip() {
            return this.stripperClip;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("MaxAmmo", this.maxAmmo);
            tag.func_74757_a("MagFed", this.magFed);
            tag.func_74757_a("NoMag", this.noMag);
            tag.func_74757_a("IsHeat", this.isHeat);
            tag.func_74757_a("IsBarrel", this.isBarrel);
            tag.func_74768_a("ReloadSpeed", this.reloadAmount);
            tag.func_74768_a("TickToHeat", this.tickToHeat);
            tag.func_74768_a("TickOverHeat", this.tickOverHeat);
            tag.func_74768_a("HeatRecover", this.heatRecover);
            tag.func_74768_a("Delay", this.delay);
            tag.func_74768_a("ReloadMagTimer", this.reloadMagTimer);
            tag.func_74768_a("AdditionalReloadEmptyMagTimer", this.additionalReloadEmptyMagTimer);
            tag.func_74783_a("MaxAmmunitionPerOverCap", this.maxAdditionalAmmoPerOC);
            tag.func_74768_a("ReloadPauseTicks", this.preReloadPauseTicks);
            tag.func_74768_a("InterReloadPauseTicks", this.interReloadPauseTicks);
            tag.func_74757_a("OpenBolt", this.openBolt);
            tag.func_74768_a("StripperClipReloadAmount", this.stripperClipReloadAmount);
            tag.func_74757_a("StripperClip", this.stripperClip);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("MaxAmmo", 99)) {
                this.maxAmmo = tag.func_74762_e("MaxAmmo");
            }
            if (tag.func_150297_b("MagFed", 99)) {
                this.magFed = tag.func_74767_n("MagFed");
            }
            if (tag.func_150297_b("NoMag", 99)) {
                this.noMag = tag.func_74767_n("NoMag");
            }
            if (tag.func_150297_b("IsHeat", 99)) {
                this.isHeat = tag.func_74767_n("IsHeat");
            }
            if (tag.func_150297_b("IsBarrel", 99)) {
                this.isBarrel = tag.func_74767_n("IsBarrel");
            }
            if (tag.func_150297_b("ReloadSpeed", 99)) {
                this.reloadAmount = tag.func_74762_e("ReloadSpeed");
            }
            if (tag.func_150297_b("TickToHeat", 99)) {
                this.tickToHeat = tag.func_74762_e("TickToHeat");
            }
            if (tag.func_150297_b("TickOverHeat", 99)) {
                this.tickOverHeat = tag.func_74762_e("TickOverHeat");
            }
            if (tag.func_150297_b("HeatRecover", 99)) {
                this.heatRecover = tag.func_74762_e("HeatRecover");
            }
            if (tag.func_150297_b("Delay", 99)) {
                this.delay = tag.func_74762_e("Delay");
            }
            if (tag.func_150297_b("ReloadMagTimer", 99)) {
                this.reloadMagTimer = tag.func_74762_e("ReloadMagTimer");
            }
            if (tag.func_150297_b("AdditionalReloadEmptyMagTimer", 99)) {
                this.additionalReloadEmptyMagTimer = tag.func_74762_e("AdditionalReloadEmptyMagTimer");
            }
            if (tag.func_150297_b("MaxAmmunitionPerOverCap", 11)) {
                this.maxAdditionalAmmoPerOC = tag.func_74759_k("MaxAmmunitionPerOverCap");
            }
            if (tag.func_150297_b("ReloadPauseTicks", 99)) {
                this.preReloadPauseTicks = tag.func_74762_e("ReloadPauseTicks");
            }
            if (tag.func_150297_b("InterReloadPauseTicks", 99)) {
                this.interReloadPauseTicks = tag.func_74762_e("InterReloadPauseTicks");
            }
            if (tag.func_150297_b("OpenBolt", 99)) {
                this.openBolt = tag.func_74767_n("OpenBolt");
            }
            if (tag.func_150297_b("StripperClipReloadAmount", 99)) {
                this.stripperClipReloadAmount = tag.func_74762_e("StripperClipReloadAmount");
            }
            if (tag.func_150297_b("StripperClip", 99)) {
                this.stripperClip = tag.func_74767_n("StripperClip");
            }
        }

        public Reloads copy() {
            Reloads reloads = new Reloads();
            reloads.magFed = this.magFed;
            reloads.noMag = this.noMag;
            reloads.isHeat = this.isHeat;
            reloads.isBarrel = this.isBarrel;
            reloads.maxAmmo = this.maxAmmo;
            reloads.reloadAmount = this.reloadAmount;
            reloads.tickToHeat = this.tickToHeat;
            reloads.tickOverHeat = this.tickOverHeat;
            reloads.heatRecover = this.heatRecover;
            reloads.delay = this.delay;
            reloads.reloadMagTimer = this.reloadMagTimer;
            reloads.additionalReloadEmptyMagTimer = this.additionalReloadEmptyMagTimer;
            reloads.maxAdditionalAmmoPerOC = this.maxAdditionalAmmoPerOC;
            reloads.preReloadPauseTicks = this.preReloadPauseTicks;
            reloads.interReloadPauseTicks = this.interReloadPauseTicks;
            reloads.openBolt = this.openBolt;
            reloads.stripperClipReloadAmount = this.stripperClipReloadAmount;
            reloads.stripperClip = this.stripperClip;
            return reloads;
        }

        public boolean isMagFed() {
            return this.magFed;
        }

        public boolean isNoMag() {
            return this.noMag;
        }

        public boolean isHeat() {
            return this.isHeat;
        }

        public boolean isBarrel() {
            return this.isBarrel;
        }

        public int getMaxAmmo() {
            return this.maxAmmo;
        }

        public int getReloadAmount() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.reloads ? (int)((double)this.reloadAmount + GunEditor.get().getReloadAmountMod()) : this.reloadAmount;
        }

        public int getTickToHeat() {
            return this.tickToHeat;
        }

        public int getTickOverHeat() {
            return this.tickOverHeat;
        }

        public int getHeatRecover() {
            return this.heatRecover;
        }

        public int getDelay() {
            return this.delay;
        }

        public int getReloadMagTimer() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.reloads ? (int)((double)this.reloadMagTimer + GunEditor.get().getReloadMagTimerMod()) : this.reloadMagTimer;
        }

        public int getAdditionalReloadEmptyMagTimer() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.reloads ? (int)((double)this.additionalReloadEmptyMagTimer + GunEditor.get().getAdditionalReloadEmptyMagTimerMod()) : this.additionalReloadEmptyMagTimer;
        }

        public int[] getMaxAdditionalAmmoPerOC() {
            return this.maxAdditionalAmmoPerOC;
        }

        public int getPreReloadPauseTicks() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.reloads ? (int)((double)this.preReloadPauseTicks + GunEditor.get().getPreReloadPauseTicksMod()) : this.preReloadPauseTicks;
        }

        public int getinterReloadPauseTicks() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.reloads ? (int)((double)this.interReloadPauseTicks + GunEditor.get().getInterReloadPauseTicksMod()) : this.interReloadPauseTicks;
        }

        public boolean isOpenBolt() {
            return this.openBolt;
        }
    }

    public static class General
    implements INBTSerializable<CompoundNBT> {
        @Optional
        private boolean auto = false;
        @Optional
        private boolean boltAction = false;
        @Optional
        private int rate;
        @Optional
        private int burstRate = 8;
        @Optional
        private int burstCount = 3;
        @Optional
        private int[] rateSelector = new int[]{0, 1};
        @Optional
        private float recoilAngle = 1.0f;
        @Optional
        private float recoilKick;
        @Optional
        private float horizontalRecoilAngle = 2.0f;
        @Optional
        private float cameraRecoilModifier = 1.75f;
        @Optional
        private float recoilDuration = 0.25f;
        @Optional
        private float weaponRecoilOffset = 0.5f;
        @Optional
        private float cameraRecoilDuration = 1.0f;
        @Optional
        private float visualRecoilPercent = 0.0f;
        @Optional
        private float recoilAdsReduction = 0.2f;
        @Optional
        private int projectileAmount = 1;
        @Optional
        private int projToMinAccuracy = 5;
        @Optional
        private int msToAccuracyReset = 425;
        @Optional
        private boolean alwaysSpread = false;
        @Optional
        private float spread = 1.0f;
        @Optional
        private float firstShotSpread = 0.0f;
        @Optional
        private float weightKilo = 0.0f;
        @Ignored
        @TGExclude
        private GripType gripType = GripType.ONE_HANDED;
        @Optional
        private float movementInaccuracy = 1.0f;
        @Optional
        private float hipFireInaccuracy = 3.25f;
        @Optional
        private float spreadHE = 1.0f;
        @Optional
        private float firstShotSpreadHE = 0.0f;
        @Optional
        private float movementInaccuracyHE = 1.0f;
        @Optional
        private float hipFireInaccuracyHE = 3.25f;
        @Optional
        private float levelReq = 300.0f;
        @Optional
        private int upgradeBenchMaxUses = 3;

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("Auto", this.auto);
            tag.func_74757_a("BoltAction", this.boltAction);
            tag.func_74768_a("Rate", this.rate);
            tag.func_74768_a("BurstRate", this.burstRate);
            tag.func_74768_a("BurstCount", this.burstCount);
            tag.func_74783_a("RateSelector", this.rateSelector);
            tag.func_74778_a("GripType", this.gripType.getId().toString());
            tag.func_74776_a("RecoilAngle", this.recoilAngle);
            tag.func_74776_a("RecoilKick", this.recoilKick);
            tag.func_74776_a("HorizontalRecoilAngle", this.horizontalRecoilAngle);
            tag.func_74776_a("CameraRecoilModifier", this.cameraRecoilModifier);
            tag.func_74776_a("RecoilDurationOffset", this.recoilDuration);
            tag.func_74776_a("weaponRecoilOffset", this.weaponRecoilOffset);
            tag.func_74776_a("CameraRecoilDuration", this.cameraRecoilDuration);
            tag.func_74776_a("VisualRecoilDuration", this.visualRecoilPercent);
            tag.func_74776_a("RecoilAdsReduction", this.recoilAdsReduction);
            tag.func_74768_a("ProjectileAmount", this.projectileAmount);
            tag.func_74768_a("ProjToMinAccuracy", this.projToMinAccuracy);
            tag.func_74768_a("MsToAccuracyRest", this.msToAccuracyReset);
            tag.func_74757_a("AlwaysSpread", this.alwaysSpread);
            tag.func_74776_a("Spread", this.spread);
            tag.func_74776_a("FirstShotSpread", this.firstShotSpread);
            tag.func_74776_a("WeightKilo", this.weightKilo);
            tag.func_74776_a("LevelReq", this.levelReq);
            tag.func_74768_a("UpgradeBenchMaxUses", this.upgradeBenchMaxUses);
            tag.func_74776_a("MovementInaccuracy", this.movementInaccuracy);
            tag.func_74776_a("HipFireInaccuracy", this.hipFireInaccuracy);
            tag.func_74776_a("SpreadHE", this.spreadHE);
            tag.func_74776_a("FirstShotSpreadHE", this.firstShotSpreadHE);
            tag.func_74776_a("MovementInaccuracyHE", this.movementInaccuracyHE);
            tag.func_74776_a("HipFireInaccuracyHE", this.hipFireInaccuracyHE);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            if (tag.func_150297_b("Auto", 99)) {
                this.auto = tag.func_74767_n("Auto");
            }
            if (tag.func_150297_b("BoltAction", 99)) {
                this.boltAction = tag.func_74767_n("BoltAction");
            }
            if (tag.func_150297_b("Rate", 99)) {
                this.rate = tag.func_74762_e("Rate");
            }
            if (tag.func_150297_b("BurstRate", 99)) {
                this.burstRate = tag.func_74762_e("BurstRate");
            }
            if (tag.func_150297_b("BurstCount", 99)) {
                this.burstCount = tag.func_74762_e("BurstCount");
            }
            if (tag.func_150297_b("RateSelector", 11)) {
                this.rateSelector = tag.func_74759_k("RateSelector");
            }
            if (tag.func_150297_b("GripType", 8)) {
                this.gripType = GripType.getType(ResourceLocation.func_208304_a((String)tag.func_74779_i("GripType")));
            }
            if (tag.func_150297_b("RecoilAngle", 99)) {
                this.recoilAngle = tag.func_74760_g("RecoilAngle");
            }
            if (tag.func_150297_b("RecoilKick", 99)) {
                this.recoilKick = tag.func_74760_g("RecoilKick");
            }
            if (tag.func_150297_b("HorizontalRecoilAngle", 99)) {
                this.horizontalRecoilAngle = tag.func_74760_g("HorizontalRecoilAngle");
            }
            if (tag.func_150297_b("CameraRecoilModifier", 99)) {
                this.cameraRecoilModifier = tag.func_74760_g("CameraRecoilModifier");
            }
            if (tag.func_150297_b("RecoilDurationOffset", 99)) {
                this.recoilDuration = tag.func_74760_g("RecoilDurationOffset");
            }
            if (tag.func_150297_b("weaponRecoilOffset", 99)) {
                this.weaponRecoilOffset = tag.func_74760_g("weaponRecoilOffset");
            }
            if (tag.func_150297_b("CameraRecoilDuration", 99)) {
                this.cameraRecoilDuration = tag.func_74760_g("CameraRecoilDuration");
            }
            if (tag.func_150297_b("VisualRecoilDuration", 99)) {
                this.visualRecoilPercent = tag.func_74760_g("VisualRecoilDuration");
            }
            if (tag.func_150297_b("RecoilAdsReduction", 99)) {
                this.recoilAdsReduction = tag.func_74760_g("RecoilAdsReduction");
            }
            if (tag.func_150297_b("ProjectileAmount", 99)) {
                this.projectileAmount = tag.func_74762_e("ProjectileAmount");
            }
            if (tag.func_150297_b("ProjToMinAccuracy", 99)) {
                this.projToMinAccuracy = tag.func_74762_e("ProjToMinAccuracy");
            }
            if (tag.func_150297_b("MsToAccuracyRest", 99)) {
                this.msToAccuracyReset = tag.func_74762_e("MsToAccuracyRest");
            }
            if (tag.func_150297_b("UpgradeBenchMaxUses", 99)) {
                this.upgradeBenchMaxUses = tag.func_74762_e("UpgradeBenchMaxUses");
            }
            if (tag.func_150297_b("AlwaysSpread", 99)) {
                this.alwaysSpread = tag.func_74767_n("AlwaysSpread");
            }
            if (tag.func_150297_b("Spread", 99)) {
                this.spread = tag.func_74760_g("Spread");
            }
            if (tag.func_150297_b("FirstShotSpread", 99)) {
                this.firstShotSpread = tag.func_74760_g("FirstShotSpread");
            }
            if (tag.func_150297_b("WeightKilo", 99)) {
                this.weightKilo = tag.func_74760_g("WeightKilo");
            }
            if (tag.func_150297_b("LevelReq", 99)) {
                this.levelReq = tag.func_74760_g("LevelReq");
            }
            if (tag.func_150297_b("MovementInaccuracy", 99)) {
                this.movementInaccuracy = tag.func_74760_g("MovementInaccuracy");
            }
            if (tag.func_150297_b("HipFireInaccuracy", 99)) {
                this.hipFireInaccuracy = tag.func_74760_g("HipFireInaccuracy");
            }
            if (tag.func_150297_b("SpreadHE", 99)) {
                this.spreadHE = tag.func_74760_g("SpreadHE");
            }
            if (tag.func_150297_b("FirstShotSpreadHE", 99)) {
                this.firstShotSpreadHE = tag.func_74760_g("FirstShotSpreadHE");
            }
            if (tag.func_150297_b("MovementInaccuracyHE", 99)) {
                this.movementInaccuracyHE = tag.func_74760_g("MovementInaccuracyHE");
            }
            if (tag.func_150297_b("HipFireInaccuracyHE", 99)) {
                this.hipFireInaccuracyHE = tag.func_74760_g("HipFireInaccuracyHE");
            }
        }

        public General copy() {
            General general = new General();
            general.auto = this.auto;
            general.boltAction = this.boltAction;
            general.rate = this.rate;
            general.burstRate = this.burstRate;
            general.burstCount = this.burstCount;
            general.rateSelector = this.rateSelector;
            general.gripType = this.gripType;
            general.recoilAngle = this.recoilAngle;
            general.recoilKick = this.recoilKick;
            general.horizontalRecoilAngle = this.horizontalRecoilAngle;
            general.cameraRecoilModifier = this.cameraRecoilModifier;
            general.recoilDuration = this.recoilDuration;
            general.weaponRecoilOffset = this.weaponRecoilOffset;
            general.cameraRecoilDuration = this.cameraRecoilDuration;
            general.visualRecoilPercent = this.visualRecoilPercent;
            general.recoilAdsReduction = this.recoilAdsReduction;
            general.projectileAmount = this.projectileAmount;
            general.projToMinAccuracy = this.projToMinAccuracy;
            general.msToAccuracyReset = this.msToAccuracyReset;
            general.alwaysSpread = this.alwaysSpread;
            general.spread = this.spread;
            general.firstShotSpread = this.firstShotSpread;
            general.weightKilo = this.weightKilo;
            general.levelReq = this.levelReq;
            general.upgradeBenchMaxUses = this.upgradeBenchMaxUses;
            general.movementInaccuracy = this.movementInaccuracy;
            general.hipFireInaccuracy = this.hipFireInaccuracy;
            general.spreadHE = this.spreadHE;
            general.firstShotSpreadHE = this.firstShotSpreadHE;
            general.movementInaccuracyHE = this.movementInaccuracyHE;
            general.hipFireInaccuracyHE = this.hipFireInaccuracyHE;
            return general;
        }

        public boolean isAuto() {
            return this.auto;
        }

        public boolean isBoltAction() {
            return this.boltAction;
        }

        public int getRate() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? (int)((double)this.rate + GunEditor.get().getRateMod()) : this.rate;
        }

        public int getUpgradeBenchMaxUses() {
            return this.upgradeBenchMaxUses;
        }

        public int getBurstRate() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? (int)((double)this.burstRate + GunEditor.get().getBurstRateMod()) : this.burstRate;
        }

        public int getBurstCount() {
            return this.burstCount;
        }

        public int[] getRateSelector() {
            return this.rateSelector;
        }

        public GripType getGripType() {
            return this.gripType;
        }

        public float getRecoilAngle() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.recoilAngle + GunEditor.get().getRecoilAngleMod() : this.recoilAngle / 1.5f;
        }

        public float getRecoilKick() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.recoilKick + GunEditor.get().getRecoilKickMod() : this.recoilKick / 1.5f;
        }

        public float getHorizontalRecoilAngle() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.horizontalRecoilAngle + GunEditor.get().getHorizontalRecoilAngleMod() : this.horizontalRecoilAngle / 1.5f;
        }

        public float getCameraRecoilModifier() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.cameraRecoilModifier + GunEditor.get().getCameraRecoilModifierMod() : this.cameraRecoilModifier;
        }

        public float getRecoilDuration() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.recoilDuration + GunEditor.get().getRecoilDurationMod() : this.recoilDuration;
        }

        public float getWeaponRecoilOffset() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.weaponRecoilOffset + GunEditor.get().getWeaponRecoilDurationMod() : this.weaponRecoilOffset;
        }

        public float getCameraRecoilDuration() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.cameraRecoilDuration + GunEditor.get().getWeaponRecoilDurationMod() : this.cameraRecoilDuration;
        }

        public float getVisualRecoilPercent() {
            return this.visualRecoilPercent;
        }

        public float getRecoilAdsReduction() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? (this.recoilAdsReduction + GunEditor.get().getRecoilAdsReductionMod()) * 2.0f : this.recoilAdsReduction * 2.0f;
        }

        public int getProjectileAmount() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? (int)((double)this.projectileAmount + GunEditor.get().getProjectileAmountMod()) : this.projectileAmount;
        }

        public boolean isAlwaysSpread() {
            return this.alwaysSpread;
        }

        public float getSpread() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.spread * 0.5f + GunEditor.get().getSpreadMod() : this.spread * 0.5f;
        }

        public float getWeightKilo() {
            return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER && (Boolean)Config.SERVER.development.enableTDev.get() != false && GunEditor.get().getMode() == GunEditor.TaCWeaponDevModes.general ? this.weightKilo + GunEditor.get().getWeightKiloMod() : this.weightKilo;
        }

        public float getLevelReq() {
            return this.levelReq;
        }

        public float getMovementInaccuracy() {
            return this.movementInaccuracy;
        }

        public float getHipFireInaccuracy() {
            return this.hipFireInaccuracy * 1.75f;
        }

        public int getProjCountAccuracy() {
            return this.projToMinAccuracy;
        }

        public float getFirstShotSpread() {
            return this.firstShotSpread;
        }

        public int getMsToAccuracyReset() {
            return this.msToAccuracyReset;
        }

        public float getSpreadHE() {
            return this.spreadHE * 0.5f;
        }

        public float getFirstShotSpreadHE() {
            return this.firstShotSpreadHE;
        }

        public float getHipFireInaccuracyHE() {
            return this.hipFireInaccuracyHE * 1.75f;
        }

        public float getMovementInaccuracyHE() {
            return this.movementInaccuracyHE;
        }
    }
}

