/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tac.guns.Config;
import com.tac.guns.common.Gun;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.transition.TimelessGunItem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OverheatBarHandler
extends AbstractGui {
    private static OverheatBarHandler instance;
    private static final ResourceLocation[] HEAT_BASE;
    private static final ResourceLocation[] HEAT_BAR;

    public static OverheatBarHandler get() {
        return instance == null ? (instance = new OverheatBarHandler()) : instance;
    }

    private OverheatBarHandler() {
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent e) {
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!((Boolean)Config.CLIENT.weaponGUI.weaponOverheatBar.showWeaponOverheatBar.get()).booleanValue()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack heldItem = player.func_184614_ca();
        MatrixStack stack = event.getMatrixStack();
        if (!(heldItem.func_77973_b() instanceof GunItem)) {
            return;
        }
        if (heldItem.func_77978_p() == null) {
            return;
        }
        Gun gun = ((GunItem)heldItem.func_77973_b()).getGun();
        if (!gun.getReloads().isHeat()) {
            return;
        }
        float anchorPointX = (float)event.getWindow().func_198107_o() / 2.0f;
        float anchorPointY = (float)event.getWindow().func_198087_p() / 2.0f;
        float heatProgress = Math.min(1.0f, 1.0f * (float)heldItem.func_77978_p().func_74762_e("heatValue") / (float)gun.getReloads().getTickToHeat());
        float totalTranslateX = 0.0f;
        float totalTranslateY = 16.0f;
        int heatProgressRound = Math.min(99, Math.round(100.0f * heatProgress));
        String heatText = heatProgressRound + "%";
        if (heatProgressRound < 10) {
            heatText = "0" + heatText;
        }
        stack.func_227860_a_();
        stack.func_227861_a_((double)anchorPointX, (double)anchorPointY, 0.0);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        double totalAlpha = MathHelper.func_151237_a((double)((Double)Config.CLIENT.weaponGUI.weaponOverheatBar.weaponOverheatBarAlpha.get()), (double)0.0, (double)1.0);
        stack.func_227860_a_();
        stack.func_227861_a_((double)totalTranslateX, (double)totalTranslateY, 0.0);
        if (heldItem.func_77978_p().func_74767_n("overHeatLock")) {
            RenderSystem.color4f((float)1.0f, (float)0.1f, (float)0.1f, (float)((float)(1.0 * totalAlpha)));
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(1.0 * totalAlpha)));
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HEAT_BASE[0]);
        OverheatBarHandler.func_238463_a_((MatrixStack)stack, (int)-48, (int)-48, (float)0.0f, (float)0.0f, (int)96, (int)96, (int)96, (int)96);
        stack.func_227865_b_();
        stack.func_227860_a_();
        stack.func_227861_a_((double)totalTranslateX, (double)totalTranslateY, 0.0);
        RenderSystem.color4f((float)0.4f, (float)0.4f, (float)0.4f, (float)((float)((double)0.4f * totalAlpha)));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HEAT_BAR[0]);
        OverheatBarHandler.func_238463_a_((MatrixStack)stack, (int)-48, (int)-48, (float)0.0f, (float)0.0f, (int)96, (int)96, (int)96, (int)96);
        stack.func_227865_b_();
        stack.func_227860_a_();
        stack.func_227862_a_(heatProgress, 1.0f, 1.0f);
        stack.func_227861_a_((double)totalTranslateX, (double)totalTranslateY, 0.0);
        if (heldItem.func_77978_p().func_74767_n("overHeatLock")) {
            RenderSystem.color4f((float)1.0f, (float)0.2f, (float)0.2f, (float)((float)(1.0 * totalAlpha)));
        } else if (heatProgress >= 0.8f) {
            RenderSystem.color4f((float)1.0f, (float)0.5f, (float)0.0f, (float)((float)(1.0 * totalAlpha)));
        } else if (heatProgress >= 0.5f) {
            RenderSystem.color4f((float)1.0f, (float)0.8f, (float)0.2f, (float)((float)(1.0 * totalAlpha)));
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(1.0 * totalAlpha)));
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HEAT_BAR[0]);
        OverheatBarHandler.func_238463_a_((MatrixStack)stack, (int)-48, (int)-48, (float)0.0f, (float)0.0f, (int)96, (int)96, (int)96, (int)96);
        stack.func_227865_b_();
        stack.func_227860_a_();
        stack.func_227861_a_((double)totalTranslateX, (double)totalTranslateY, 0.0);
        stack.func_227861_a_(-8.5, 14.0, 0.0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(1.0 * totalAlpha)));
        if (OverheatBarHandler.overHeat((PlayerEntity)player, heldItem)) {
            stack.func_227861_a_(-15.5, 0.0, 0.0);
            Color color = new Color(255, 51, 51, (int)(255.0 * totalAlpha));
            OverheatBarHandler.func_238476_c_((MatrixStack)stack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)"OVERHEAT!", (int)0, (int)0, (int)color.getRGB());
            stack.func_227861_a_(15.5, 0.0, 0.0);
        } else {
            Color color = new Color(255, 255, 255, (int)(255.0 * totalAlpha));
            OverheatBarHandler.func_238476_c_((MatrixStack)stack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)heatText, (int)0, (int)0, (int)color.getRGB());
        }
        stack.func_227865_b_();
        stack.func_227865_b_();
    }

    private static boolean overHeat(PlayerEntity player, ItemStack heldItem) {
        if (heldItem.func_77973_b() instanceof TimelessGunItem && !((TimelessGunItem)heldItem.func_77973_b()).getGun().getReloads().isHeat()) {
            return false;
        }
        return heldItem.func_77978_p().func_74762_e("heatValue") >= ((TimelessGunItem)heldItem.func_77973_b()).getGun().getReloads().getTickToHeat() || heldItem.func_77978_p().func_74767_n("overHeatLock");
    }

    static {
        HEAT_BASE = new ResourceLocation[]{new ResourceLocation("tac", "textures/gui/heat_base.png")};
        HEAT_BAR = new ResourceLocation[]{new ResourceLocation("tac", "textures/gui/heat_bar.png")};
    }
}

