/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.tac.guns.client.Keys;
import com.tac.guns.client.handler.AimingHandler;
import com.tac.guns.client.handler.ReloadHandler;
import com.tac.guns.client.render.animation.module.AnimationMeta;
import com.tac.guns.client.render.animation.module.AnimationSoundManager;
import com.tac.guns.client.render.animation.module.Animations;
import com.tac.guns.client.render.animation.module.BoltActionAnimationController;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import com.tac.guns.client.render.animation.module.MachineGunAnimationController;
import com.tac.guns.client.render.animation.module.PumpShotgunAnimationController;
import com.tac.guns.common.Gun;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.event.GunReloadEvent;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.GunItem;
import com.tac.guns.util.GunModifierHelper;
import de.javagl.jgltf.model.animation.AnimationRunner;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tac", value={Dist.CLIENT})
public enum AnimationHandler {
    INSTANCE;


    public static void preloadAnimations() {
        String[] animationControllers;
        for (String controllerName : animationControllers = new String[]{"AA12AnimationController", "Dp28AnimationController", "Glock17AnimationController", "HkMp5a5AnimationController", "HK416A5AnimationController", "M870AnimationController", "Mp7AnimationController", "Type81AnimationController", "Ak47AnimationController", "AWPAnimationController", "M60AnimationController", "M1014AnimationController", "TtiG34AnimationController", "MK18MOD1AnimationController", "M4AnimationController", "STI2011AnimationController", "Timeless50AnimationController", "M1911AnimationController", "MK47AnimationController", "MK14AnimationController", "SCAR_HAnimationController", "SCAR_MK20AnimationController", "SCAR_LAnimationController", "CZ75AnimationController", "CZ75AutoAnimationController", "DBShotgunAnimationController", "FNFALAnimationController", "M16A4AnimationController", "SPR15AnimationController", "Deagle50AnimationController", "Type95LAnimationController", "Type191AnimationController", "MAC10AnimationController", "Vector45AnimationController", "SKSTacticalAnimationController", "M24AnimationController", "M82A2AnimationController", "RPKAnimationController", "M249AnimationController", "M1A1AnimationController", "Glock18AnimationController", "SIGMCXAnimationController", "M92FSAnimationController", "MP9AnimationController", "MK23AnimationController", "RPG7AnimationController", "UDP9AnimationController", "UZIAnimationController", "MRADAnimationController", "HK_G3AnimationController", "TEC9AnimationController", "COLTPYTHONAnimationController", "P90AnimationController", "C96AnimationController", "B93RAnimationController", "MINIGUNAnimationController"}) {
            try {
                String fullClassName = "com.tac.guns.client.render.animation." + controllerName;
                Class<?> controllerClass = Class.forName(fullClassName);
                Method getInstanceMethod = controllerClass.getMethod("getInstance", new Class[0]);
                getInstanceMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void onGunReload(boolean reloading, ItemStack itemStack) {
        GunAnimationController controller;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (itemStack.func_77973_b() instanceof GunItem) {
            GunItem gunItem = (GunItem)itemStack.func_77973_b();
            CompoundNBT tag = itemStack.func_196082_o();
            int reloadingAmount = GunModifierHelper.getAmmoCapacity(itemStack, gunItem.getGun()) - tag.func_74762_e("AmmoCount");
            if (reloadingAmount <= 0) {
                return;
            }
        }
        if ((controller = GunAnimationController.fromItem(itemStack.func_77973_b())) == null) {
            return;
        }
        if (!reloading) {
            return;
        }
        AnimationMeta reloadEmptyMeta = controller.getAnimationFromLabel(GunAnimationController.AnimationLabel.RELOAD_EMPTY);
        AnimationMeta reloadNormalMeta = controller.getAnimationFromLabel(GunAnimationController.AnimationLabel.RELOAD_NORMAL);
        if (Gun.hasAmmo(itemStack)) {
            if (controller.getPreviousAnimation() != null && !controller.getPreviousAnimation().equals(reloadNormalMeta)) {
                controller.stopAnimation();
            }
            controller.runAnimation(GunAnimationController.AnimationLabel.RELOAD_NORMAL);
        } else {
            if (controller.getPreviousAnimation() != null && !controller.getPreviousAnimation().equals(reloadEmptyMeta)) {
                controller.stopAnimation();
            }
            if (GunAnimationController.fromItem(itemStack.func_77973_b()) instanceof PumpShotgunAnimationController) {
                ((PumpShotgunAnimationController)GunAnimationController.fromItem(itemStack.func_77973_b())).setEmpty(true);
            }
            controller.runAnimation(GunAnimationController.AnimationLabel.RELOAD_EMPTY);
        }
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Pre event) {
        if (!event.isClient()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (!event.getPlayer().func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            return;
        }
        GunAnimationController controller = GunAnimationController.fromItem(event.getStack().func_77973_b());
        if (controller == null) {
            return;
        }
        if (controller.isAnimationRunning()) {
            AnimationMeta meta = controller.getPreviousAnimation();
            if (meta == null) {
                return;
            }
            if (meta.equals(controller.getAnimationFromLabel(GunAnimationController.AnimationLabel.INSPECT)) || meta.equals(controller.getAnimationFromLabel(GunAnimationController.AnimationLabel.INSPECT_EMPTY))) {
                controller.stopAnimation();
            } else {
                AnimationRunner runner = Animations.getAnimationRunner(meta.getResourceLocation());
                if (runner == null) {
                    return;
                }
                float current = runner.getAnimationManager().getCurrentTimeS();
                float max = runner.getAnimationManager().getMaxEndTimeS();
                if (!meta.equals(controller.getAnimationFromLabel(GunAnimationController.AnimationLabel.PUMP)) && !meta.equals(controller.getAnimationFromLabel(GunAnimationController.AnimationLabel.PULL_BOLT)) && max - current <= 0.25f) {
                    return;
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPumpShotgunFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (!event.getPlayer().func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            return;
        }
        GunAnimationController controller = GunAnimationController.fromItem(event.getStack().func_77973_b());
        if (controller instanceof PumpShotgunAnimationController) {
            controller.runAnimation(GunAnimationController.AnimationLabel.PUMP);
        }
    }

    @SubscribeEvent
    public void onBoltActionRifleFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (!event.getPlayer().func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            return;
        }
        GunAnimationController controller = GunAnimationController.fromItem(event.getStack().func_77973_b());
        if (controller instanceof BoltActionAnimationController) {
            controller.runAnimation(GunAnimationController.AnimationLabel.PULL_BOLT);
        }
    }

    @SubscribeEvent
    public void onMachineGunFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (!event.getPlayer().func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            return;
        }
        GunAnimationController controller = GunAnimationController.fromItem(event.getStack().func_77973_b());
        if (controller instanceof MachineGunAnimationController && controller.getAnimationFromLabel(GunAnimationController.AnimationLabel.BULLET_CHAIN) != null) {
            controller.runAnimation(GunAnimationController.AnimationLabel.BULLET_CHAIN);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        AnimationSoundManager.INSTANCE.onPlayerDeath(event.getPlayer());
    }

    @SubscribeEvent
    public void onClientPlayerReload(GunReloadEvent.Pre event) {
        GunAnimationController controller;
        if (event.isClient() && (controller = GunAnimationController.fromItem(event.getStack().func_77973_b())) != null && (controller.isAnimationRunning(GunAnimationController.AnimationLabel.DRAW) || controller.isAnimationRunning(GunAnimationController.AnimationLabel.PUMP))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        GunAnimationController controller = GunAnimationController.fromItem(itemStack.func_77973_b());
        if (controller == null) {
            return;
        }
        if (controller.isAnimationRunning()) {
            // empty if block
        }
    }

    public boolean isReloadingIntro(Item item) {
        GunAnimationController controller = GunAnimationController.fromItem(item);
        if (controller == null) {
            return false;
        }
        return controller.isAnimationRunning(GunAnimationController.AnimationLabel.RELOAD_INTRO);
    }

    public void onReloadLoop(Item item) {
        GunAnimationController controller = GunAnimationController.fromItem(item);
        if (controller == null) {
            return;
        }
        controller.stopAnimation();
        controller.runAnimation(GunAnimationController.AnimationLabel.RELOAD_LOOP);
    }

    public void onReloadEnd(Item item) {
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        GunAnimationController controller = GunAnimationController.fromItem(stack.func_77973_b());
        if (controller instanceof PumpShotgunAnimationController && controller.getPreviousAnimation() != null && controller.getPreviousAnimation().equals(controller.getAnimationFromLabel(GunAnimationController.AnimationLabel.RELOAD_LOOP)) && !ReloadHandler.get().isReloading() && !controller.isAnimationRunning()) {
            if (((PumpShotgunAnimationController)controller).isEmpty()) {
                controller.runAnimation(GunAnimationController.AnimationLabel.RELOAD_EMPTY_END);
                ((PumpShotgunAnimationController)controller).setEmpty(false);
            } else {
                controller.runAnimation(GunAnimationController.AnimationLabel.RELOAD_NORMAL_END);
            }
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        if (itemStack.func_77973_b() instanceof GunItem) {
            if (controller.isAnimationRunning(GunAnimationController.AnimationLabel.INSPECT) && AimingHandler.get().isAiming()) {
                controller.stopAnimation();
            }
            if (((Boolean)SyncedPlayerData.instance().get((PlayerEntity)player, ModSyncedDataKeys.RELOADING)).booleanValue()) {
                AimingHandler.get().cancelAim();
            } else if (AimingHandler.get().getCanceling()) {
                AimingHandler.get().setCanceling();
            }
        }
    }

    static {
        Keys.INSPECT.addPressCallback(() -> {
            if (!Keys.noConflict(Keys.INSPECT)) {
                return;
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            ItemStack stack = player.field_71071_by.func_70448_g();
            GunAnimationController controller = GunAnimationController.fromItem(stack.func_77973_b());
            if (controller != null && !controller.isAnimationRunning()) {
                controller.stopAnimation();
                if (Gun.hasAmmo(stack)) {
                    controller.runAnimation(GunAnimationController.AnimationLabel.INSPECT);
                } else {
                    controller.runAnimation(GunAnimationController.AnimationLabel.INSPECT_EMPTY);
                }
            }
        });
    }
}

