/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.gunskin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.tac.guns.GunMod;
import com.tac.guns.client.gunskin.DefaultSkin;
import com.tac.guns.client.gunskin.DyeSkin;
import com.tac.guns.client.gunskin.GunSkin;
import com.tac.guns.client.gunskin.SkinLoader;
import com.tac.guns.client.gunskin.SkinLoaders;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.util.GunModifierHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;

public class SkinManager {
    private static Map<ResourceLocation, Map<ResourceLocation, GunSkin>> skins = new HashMap<ResourceLocation, Map<ResourceLocation, GunSkin>>();
    private static final Map<ResourceLocation, DefaultSkin> defaultSkins = new HashMap<ResourceLocation, DefaultSkin>();

    public static void reload() {
        skins = new HashMap<ResourceLocation, Map<ResourceLocation, GunSkin>>();
        SkinManager.init();
    }

    public static void cleanCache() {
        for (GunSkin gunSkin : defaultSkins.values()) {
            gunSkin.cleanCache();
        }
        for (Map map : skins.values()) {
            for (GunSkin skin : map.values()) {
                skin.cleanCache();
            }
        }
    }

    private static void init() {
        Set nameSpaces = Minecraft.func_71410_x().func_195551_G().func_199001_a();
        for (String nameSpace : nameSpaces) {
            ResourceLocation loc = new ResourceLocation(nameSpace, "models/gunskin/skin.json");
            try {
                List all = Minecraft.func_71410_x().func_195551_G().func_199004_b(loc);
                for (IResource resource : all) {
                    SkinManager.loadSkinList(resource);
                }
            }
            catch (IOException e) {
                GunMod.LOGGER.debug("Failed to load skins from {} {}", (Object)loc, (Object)e);
            }
        }
    }

    private static void loadSkinList(IResource resource) throws IOException {
        InputStream stream = resource.func_199027_b();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
        String nameSpace = resource.func_199029_a().func_110624_b();
        for (Map.Entry e : json.entrySet()) {
            String gun = (String)e.getKey();
            SkinLoader loader = SkinLoader.getSkinLoader(gun);
            if (loader == null) continue;
            JsonObject skins = ((JsonElement)e.getValue()).getAsJsonObject();
            block13: for (Map.Entry s : skins.entrySet()) {
                try {
                    ResourceLocation rl;
                    String skinName = (String)s.getKey();
                    JsonObject skinObject = ((JsonElement)s.getValue()).getAsJsonObject();
                    String skinType = skinObject.get("type").getAsString();
                    ResourceLocation skinLoc = ResourceLocation.func_208304_a((String)(nameSpace + ":" + skinName));
                    if (skinLoc == null) {
                        GunMod.LOGGER.warn("Failed to load skins of {} named {}: invalid name.", (Object)gun, (Object)skinName);
                        continue;
                    }
                    if (!defaultSkins.containsKey(loader.getGun())) {
                        GunMod.LOGGER.warn("Failed to load skins of {} named {}: default skin no loaded.", (Object)gun, (Object)skinName);
                        continue;
                    }
                    if (skinType == null) {
                        GunMod.LOGGER.warn("Failed to load skins of {} named {}: unknown type.", (Object)gun, (Object)skinName);
                        continue;
                    }
                    switch (skinType) {
                        case "custom": {
                            SkinManager.parseCustom(skinObject, loader, skinLoc, gun, skinName);
                            break;
                        }
                        case "texture": {
                            SkinManager.parseTextureOnly(skinObject, loader, skinLoc, gun, skinName);
                            break;
                        }
                        case "dye": {
                            SkinManager.parseDye(skinObject, loader);
                            continue block13;
                        }
                        default: {
                            GunMod.LOGGER.warn("Failed to load skins of {} named {}: unknown type.", (Object)gun, (Object)skinName);
                            continue block13;
                        }
                    }
                    if (skinObject.get("icon") != null) {
                        rl = ResourceLocation.func_208304_a((String)skinObject.get("icon").getAsString());
                        GunSkin skin = SkinManager.getSkin(loader.getGun(), skinLoc);
                        if (skin != null && rl != null) {
                            loader.loadSkinIcon(skin, rl);
                        }
                    }
                    if (skinObject.get("mini_icon") == null) continue;
                    rl = ResourceLocation.func_208304_a((String)skinObject.get("mini_icon").getAsString());
                    GunSkin skin = SkinManager.getSkin(loader.getGun(), skinLoc);
                    if (skin == null || rl == null) continue;
                    loader.loadSkinMiniIcon(skin, rl);
                }
                catch (Exception e2) {
                    GunMod.LOGGER.warn("Failed to load skins from {} {}.", (Object)resource.func_199029_a(), (Object)e2);
                }
            }
        }
        reader.close();
        stream.close();
    }

    private static void parseDye(JsonObject skinObject, SkinLoader loader) {
        JsonObject colors = skinObject.get("colors").getAsJsonObject();
        int cnt = 0;
        for (DyeSkin.PresetType preset : DyeSkin.PresetType.values()) {
            JsonElement color = colors.get(preset.name());
            if (color == null || !color.isJsonArray()) continue;
            JsonArray array = color.getAsJsonArray();
            int l = array.size();
            int[] c = new int[l];
            for (int i = 0; i < l; ++i) {
                c[i] = array.get(i).getAsInt();
            }
            DyeSkin skin = loader.loadDyeSkin(preset, c);
            if (skin == null) continue;
            ++cnt;
            skins.putIfAbsent(loader.getGun(), new HashMap());
            skins.get(loader.getGun()).put(preset.getSkinLocation(), skin);
        }
        GunMod.LOGGER.info("Loaded {} dye gun skins of {}", (Object)cnt, (Object)loader.getGun());
    }

    private static void parseTextureOnly(JsonObject skinObject, SkinLoader loader, ResourceLocation skinLoc, String gun, String skinName) {
        JsonObject modelObject = skinObject.get("textures").getAsJsonObject();
        ArrayList<Pair<String, ResourceLocation>> textures = new ArrayList<Pair<String, ResourceLocation>>();
        for (Map.Entry c : modelObject.entrySet()) {
            ResourceLocation tl = ResourceLocation.func_208304_a((String)((JsonElement)c.getValue()).getAsString());
            if (tl == null) continue;
            textures.add((Pair<String, ResourceLocation>)new Pair(c.getKey(), (Object)tl));
        }
        if (SkinManager.registerTextureOnlySkin(loader, skinLoc, textures)) {
            GunMod.LOGGER.info("Loaded texture-only gun skin of {} named {}", (Object)gun, (Object)skinName);
        }
    }

    private static void parseCustom(JsonObject skinObject, SkinLoader loader, ResourceLocation skinLoc, String gun, String skinName) {
        JsonObject modelObject = skinObject.get("models").getAsJsonObject();
        HashMap<String, String> components = new HashMap<String, String>();
        for (Map.Entry c : modelObject.entrySet()) {
            components.put((String)c.getKey(), ((JsonElement)c.getValue()).getAsString());
        }
        if (SkinManager.registerCustomSkin(loader, skinLoc, components)) {
            GunMod.LOGGER.info("Loaded custom gun skin of {} named {}", (Object)gun, (Object)skinName);
        }
    }

    public static void loadDefaultSkins() {
        SkinLoaders.init();
        for (SkinLoader loader : SkinLoader.skinLoaders.values()) {
            SkinManager.loadDefaultSkin(loader.getGun(), loader.loadDefaultSkin());
        }
    }

    public static void loadDefaultSkin(ResourceLocation gun, DefaultSkin skin) {
        defaultSkins.put(gun, skin);
    }

    private static boolean registerCustomSkin(SkinLoader loader, ResourceLocation skinLocation, Map<String, String> models) {
        GunSkin skin = loader.loadCustomSkin(skinLocation, models);
        if (skin != null) {
            skins.putIfAbsent(loader.getGun(), new HashMap());
            skins.get(loader.getGun()).put(skinLocation, skin);
            return true;
        }
        return false;
    }

    private static boolean registerTextureOnlySkin(SkinLoader loader, ResourceLocation skinLocation, List<Pair<String, ResourceLocation>> textures) {
        for (Pair<String, ResourceLocation> p : textures) {
            ResourceLocation tl = ResourceLocation.func_208304_a((String)(((ResourceLocation)p.getSecond()).func_110624_b() + ":textures/" + ((ResourceLocation)p.getSecond()).func_110623_a() + ".png"));
            if (tl != null && Minecraft.func_71410_x().func_195551_G().func_219533_b(tl)) continue;
            return false;
        }
        GunSkin skin = loader.loadTextureOnlySkin(skinLocation, textures);
        if (skin != null) {
            skins.putIfAbsent(loader.getGun(), new HashMap());
            skins.get(loader.getGun()).put(skinLocation, skin);
            return true;
        }
        return false;
    }

    public static GunSkin getSkin(String gun, ResourceLocation skinLocation) {
        ResourceLocation rl = ResourceLocation.func_208304_a((String)("tac:" + gun));
        if (skinLocation != null && skins.containsKey(rl)) {
            return skins.get(rl).get(skinLocation);
        }
        return null;
    }

    public static GunSkin getSkin(ResourceLocation gun, ResourceLocation skinLocation) {
        if (skinLocation != null && skins.containsKey(gun)) {
            return skins.get(gun).get(skinLocation);
        }
        return null;
    }

    private static GunSkin getAttachedSkin(ItemStack weapon) {
        if (weapon.func_77973_b() instanceof TimelessGunItem) {
            ResourceLocation gun = weapon.func_77973_b().getRegistryName();
            ResourceLocation skin = GunModifierHelper.getAdditionalSkin(weapon);
            return SkinManager.getSkin(gun, skin);
        }
        return null;
    }

    public static GunSkin getSkin(ItemStack stack) {
        GunSkin skin = null;
        ResourceLocation gun = stack.func_77973_b().getRegistryName();
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Skin", 8)) {
            String skinLoc = stack.func_77978_p().func_74779_i("Skin");
            ResourceLocation loc = skinLoc.contains(":") ? ResourceLocation.func_208304_a((String)skinLoc) : new ResourceLocation("tac", skinLoc);
            skin = SkinManager.getSkin(gun, loc);
        }
        if (skin == null) {
            skin = SkinManager.getAttachedSkin(stack);
        }
        if (skin == null && defaultSkins.containsKey(gun)) {
            return defaultSkins.get(gun);
        }
        return skin;
    }

    public static DefaultSkin getDefaultSkin(String gun) {
        ResourceLocation rl = ResourceLocation.func_208304_a((String)("tac:" + gun));
        if (rl == null) {
            return null;
        }
        return defaultSkins.get(rl);
    }

    public static DefaultSkin getDefaultSkin(ResourceLocation gun) {
        if (gun == null) {
            return null;
        }
        return defaultSkins.get(gun);
    }
}

