/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.registration.RegistrationHelper;

public class ItemObject<I extends IForgeRegistryEntry<? super I> & IItemProvider>
implements Supplier<I>,
IItemProvider {
    private final Supplier<? extends I> entry;
    private final ResourceLocation name;

    public ItemObject(ForgeRegistryEntry<? super I> entry) {
        this.entry = RegistrationHelper.castDelegate(entry.delegate);
        this.name = Objects.requireNonNull(entry.getRegistryName(), () -> "Attempted to create an Item Object with an unregistered entry");
    }

    public ItemObject(RegistryObject<? extends I> object) {
        this.entry = object;
        this.name = object.getId();
    }

    protected ItemObject(ItemObject<? extends I> object) {
        this.entry = object.entry;
        this.name = object.name;
    }

    @Override
    public I get() {
        return (I)((IForgeRegistryEntry)Objects.requireNonNull(this.entry.get(), () -> "Item Object not present " + this.name));
    }

    @Nullable
    public I getOrNull() {
        try {
            return (I)((IForgeRegistryEntry)this.entry.get());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public Item func_199767_j() {
        return ((IItemProvider)this.get()).func_199767_j();
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public ItemObject(Supplier<? extends I> entry, ResourceLocation name) {
        this.entry = entry;
        this.name = name;
    }
}

