/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.plugin.jei;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.Size2i;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.plugin.jei.JEIPlugin;
import slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipe;

public class RetexturedRecipeExtension
implements ICraftingCategoryExtension,
ICustomCraftingCategoryExtension,
ITooltipCallback<ItemStack> {
    private final ShapedRetexturedRecipe recipe;
    private final Size2i size;
    private final List<List<ItemStack>> allOutputs;
    private final List<ItemStack> displayOutputs;

    RetexturedRecipeExtension(ShapedRetexturedRecipe recipe) {
        this.recipe = recipe;
        this.size = new Size2i(recipe.getRecipeWidth(), recipe.getRecipeHeight());
        ItemStack output = this.recipe.func_77571_b();
        List displayVariants = Arrays.stream(recipe.getTexture().func_193365_a()).map(stack -> recipe.getRecipeOutput(stack.func_77973_b())).collect(Collectors.toList());
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(displayVariants);
        builder.add((Object)output);
        ImmutableList allVariants = builder.build();
        this.allOutputs = ImmutableList.of((Object)allVariants);
        this.displayOutputs = displayVariants.isEmpty() ? allVariants : displayVariants;
    }

    public ResourceLocation getRegistryName() {
        return this.recipe.func_199560_c();
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputIngredients((List)this.recipe.func_192400_c());
        ingredients.setOutputLists(VanillaTypes.ITEM, this.allOutputs);
    }

    public Size2i getSize() {
        return this.size;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.addTooltipCallback((ITooltipCallback)this);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        ImmutableList outputs = this.displayOutputs;
        IFocus ifocus = recipeLayout.getFocus();
        if (ifocus != null && ifocus.getValue() instanceof ItemStack) {
            IGuiIngredientGroup guiIngredients = recipeLayout.getIngredientsGroup(VanillaTypes.ITEM);
            ItemStack focus = (ItemStack)ifocus.getValue();
            IFocus.Mode mode = ifocus.getMode();
            if (mode == IFocus.Mode.INPUT && this.recipe.getTexture().test(focus)) {
                outputs = ImmutableList.of((Object)this.recipe.getRecipeOutput(focus.func_77973_b()));
            } else if (mode == IFocus.Mode.OUTPUT) {
                Block textureBlock = RetexturedBlockItem.getTexture(focus);
                if (textureBlock != Blocks.field_150350_a) {
                    ItemStack output = focus.func_77946_l();
                    output.func_190920_e(this.recipe.func_77571_b().func_190916_E());
                    outputs = ImmutableList.of((Object)output);
                    guiIngredients.setOverrideDisplayFocus(JEIPlugin.recipeManager.createFocus(IFocus.Mode.INPUT, (Object)new ItemStack((IItemProvider)textureBlock)));
                } else {
                    guiIngredients.setOverrideDisplayFocus(null);
                }
            }
        }
        JEIPlugin.vanillaCraftingHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, this.size.width, this.size.height);
        guiItemStacks.set(0, outputs);
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<ITextComponent> tooltip) {
        ResourceLocation registryName = this.getRegistryName();
        if (slotIndex == 0 && registryName != null) {
            boolean showAdvanced;
            if (JEIPlugin.modIdHelper.isDisplayingModNameEnabled()) {
                String recipeModId = this.getRegistryName().func_110624_b();
                boolean modIdDifferent = false;
                ResourceLocation itemRegistryName = ingredient.func_77973_b().getRegistryName();
                if (itemRegistryName != null) {
                    String itemModId = itemRegistryName.func_110624_b();
                    boolean bl = modIdDifferent = !recipeModId.equals(itemModId);
                }
                if (modIdDifferent) {
                    String modName = JEIPlugin.modIdHelper.getFormattedModNameForModId(recipeModId);
                    tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.recipe.by", new Object[]{modName}).func_240699_a_(TextFormatting.GRAY));
                }
            }
            boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.func_231173_s_();
            if (showAdvanced) {
                tooltip.add((ITextComponent)new TranslationTextComponent("jei.tooltip.recipe.id", new Object[]{registryName}).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
    }
}

