/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

@OnlyIn(value=Dist.CLIENT)
public class ItemElement
extends SizedBookElement {
    public static final int ITEM_SIZE_HARDCODED = 16;
    public static final long ITEM_SWITCH_TIME = 3000000000L;
    public NonNullList<ItemStack> itemCycle;
    public float scale;
    @Nullable
    public String action;
    public List<ITextComponent> tooltip;
    public long lastTime = Util.func_211178_c();
    public int currentItem = 0;

    public ItemElement(int x, int y, float scale, Item item) {
        this(x, y, scale, new ItemStack((IItemProvider)item));
    }

    public ItemElement(int x, int y, float scale, Block item) {
        this(x, y, scale, new ItemStack((IItemProvider)item));
    }

    public ItemElement(int x, int y, float scale, ItemStack item) {
        this(x, y, scale, new ItemStack[]{item});
    }

    public ItemElement(int x, int y, float scale, Collection<ItemStack> itemCycle) {
        this(x, y, scale, itemCycle.toArray(new ItemStack[0]));
    }

    public ItemElement(int x, int y, float scale, Collection<ItemStack> itemCycle, String action) {
        this(x, y, scale, itemCycle.toArray(new ItemStack[0]), action);
    }

    public ItemElement(int x, int y, float scale, ItemStack ... itemCycle) {
        this(x, y, scale, itemCycle, (String)null);
    }

    public ItemElement(int x, int y, float scale, ItemStack[] itemCycle, @Nullable String action) {
        super(x, y, MathHelper.func_76141_d((float)(16.0f * scale)), MathHelper.func_76141_d((float)(16.0f * scale)));
        NonNullList nonNullStacks = NonNullList.func_191197_a((int)itemCycle.length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < itemCycle.length; ++i) {
            if (itemCycle[i].func_190926_b()) continue;
            nonNullStacks.set(i, (Object)itemCycle[i].func_77946_l());
        }
        this.itemCycle = nonNullStacks;
        this.scale = scale;
        this.action = action;
    }

    @Override
    public void draw(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        long nano = Util.func_211178_c();
        if (nano > this.lastTime + 3000000000L) {
            this.lastTime = nano;
            ++this.currentItem;
            if (this.currentItem >= this.itemCycle.size()) {
                this.currentItem = 0;
            }
        }
        if (this.currentItem < this.itemCycle.size()) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)this.x, (float)this.y, (float)0.0f);
            RenderSystem.scalef((float)this.scale, (float)this.scale, (float)1.0f);
            ItemStack stack = (ItemStack)this.itemCycle.get(this.currentItem);
            this.mc.func_175599_af().func_180450_b(stack, 0, 0);
            FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
            if (font == null) {
                font = this.mc.field_71466_p;
            }
            this.mc.func_175599_af().func_180453_a(font, stack, 0, 0, null);
            RenderSystem.popMatrix();
            RenderHelper.func_74518_a();
        }
    }

    @Override
    public void drawOverlay(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        if (this.isHovered(mouseX, mouseY) && this.currentItem < this.itemCycle.size()) {
            if (this.tooltip != null) {
                this.drawHoveringText(matrixStack, this.tooltip, mouseX, mouseY, fontRenderer);
            } else {
                this.renderToolTip(matrixStack, fontRenderer, (ItemStack)this.itemCycle.get(this.currentItem), mouseX, mouseY);
            }
        }
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isHovered(mouseX, mouseY) && this.currentItem < this.itemCycle.size()) {
            if (this.action != null) {
                StringActionProcessor.process(this.action, this.parent);
            } else {
                this.parent.itemClicked((ItemStack)this.itemCycle.get(this.currentItem));
            }
        }
    }
}

