/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.connected;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.SixWayBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;

public class ConnectedModelRegistry {
    private static final BiPredicate<BlockState, BlockState> BLOCK_CONNECTION_PREDICATE = (s1, s2) -> s1.func_177230_c() == s2.func_177230_c();
    private static final Map<String, BiPredicate<BlockState, BlockState>> CONNECTION_PREDICATES = new HashMap<String, BiPredicate<BlockState, BlockState>>();
    private static final Map<String, String[]> CONNECTION_TYPES;

    public static void registerPredicate(String name, BiPredicate<BlockState, BlockState> predicate) {
        CONNECTION_PREDICATES.putIfAbsent(name, predicate);
    }

    public static BiPredicate<BlockState, BlockState> deserializePredicate(JsonObject json, String key) {
        String name = JSONUtils.func_151219_a((JsonObject)json, (String)key, (String)"block");
        if (!CONNECTION_PREDICATES.containsKey(name)) {
            throw new JsonSyntaxException("Unknown connection predicate " + name);
        }
        return CONNECTION_PREDICATES.get(name);
    }

    public static BiPredicate<BlockState, BlockState> getPredicate(String name) {
        return CONNECTION_PREDICATES.getOrDefault(name, BLOCK_CONNECTION_PREDICATE);
    }

    private static boolean safeGet(BlockState state, BooleanProperty prop) {
        return state.func_235901_b_((Property)prop) && (Boolean)state.func_177229_b((Property)prop) != false;
    }

    public static void registerType(String name, Function<Predicate<Direction>, String> mapper) {
        if (!CONNECTION_TYPES.containsKey(name)) {
            String[] suffixes = new String[16];
            for (int i = 0; i < 16; ++i) {
                int index = i;
                suffixes[i] = mapper.apply(dir -> {
                    int flag = 1 << dir.func_176736_b();
                    return (index & flag) == flag;
                });
            }
            CONNECTION_TYPES.put(name, suffixes);
        }
    }

    public static String[] deserializeType(JsonElement json, String key) {
        String name = JSONUtils.func_151206_a((JsonElement)json, (String)key);
        if (!CONNECTION_TYPES.containsKey(name)) {
            throw new JsonSyntaxException("Unknown connection type " + name);
        }
        return CONNECTION_TYPES.get(name);
    }

    static {
        ConnectedModelRegistry.registerPredicate("block", BLOCK_CONNECTION_PREDICATE);
        ConnectedModelRegistry.registerPredicate("pane", (state, neighbor) -> state.func_177230_c() == neighbor.func_177230_c() && (ConnectedModelRegistry.safeGet(state, SixWayBlock.field_196488_a) || ConnectedModelRegistry.safeGet(state, SixWayBlock.field_196490_b) || ConnectedModelRegistry.safeGet(state, SixWayBlock.field_196492_c) || ConnectedModelRegistry.safeGet(state, SixWayBlock.field_196495_y)) == (ConnectedModelRegistry.safeGet(neighbor, SixWayBlock.field_196488_a) || ConnectedModelRegistry.safeGet(neighbor, SixWayBlock.field_196490_b) || ConnectedModelRegistry.safeGet(neighbor, SixWayBlock.field_196492_c) || ConnectedModelRegistry.safeGet(neighbor, SixWayBlock.field_196495_y)));
        CONNECTION_TYPES = new HashMap<String, String[]>();
        ConnectedModelRegistry.registerType("cornerless_full", predicate -> {
            String name = "";
            if (predicate.test(Direction.NORTH)) {
                name = name + "u";
            }
            if (predicate.test(Direction.SOUTH)) {
                name = name + "d";
            }
            if (predicate.test(Direction.WEST)) {
                name = name + "l";
            }
            if (predicate.test(Direction.EAST)) {
                name = name + "r";
            }
            return name;
        });
        ConnectedModelRegistry.registerType("horizontal", predicate -> {
            boolean right = predicate.test(Direction.EAST);
            if (predicate.test(Direction.WEST)) {
                return right ? "middle" : "right";
            }
            return right ? "left" : "";
        });
        ConnectedModelRegistry.registerType("vertical", predicate -> {
            boolean bottom = predicate.test(Direction.SOUTH);
            if (predicate.test(Direction.NORTH)) {
                return bottom ? "middle" : "bottom";
            }
            return bottom ? "top" : "";
        });
        ConnectedModelRegistry.registerType("top", predicate -> predicate.test(Direction.NORTH) ? "bottom" : "");
    }
}

