/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.core.config.Option;
import org.embeddedt.modernfix.core.config.OptionCategories;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.screen.ModernFixConfigScreen;
import org.embeddedt.modernfix.screen.ModernFixOptionInfoScreen;

public class OptionList
extends AbstractOptionList<Entry> {
    private int maxNameWidth = 0;
    private static final int DEPTH_OFFSET = 20;
    private static final ITextComponent OPTION_ON = new TranslationTextComponent("modernfix.option.on").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN));
    private static final ITextComponent OPTION_OFF = new TranslationTextComponent("modernfix.option.off").func_240700_a_(style -> style.func_240712_a_(TextFormatting.RED));
    private static final Set<String> OPTIONS_MISSING_HELP = new HashSet<String>();
    private ModernFixConfigScreen mainScreen;
    private final Set<Option> addedOptions = new HashSet<Option>();

    private static IFormattableTextComponent getOptionComponent(Option option) {
        String friendlyKey = "modernfix.option.name." + option.getName();
        StringTextComponent baseComponent = new StringTextComponent(option.getSelfName());
        if (I18n.func_188566_a((String)friendlyKey)) {
            return new TranslationTextComponent(friendlyKey).func_240700_a_(style -> style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)baseComponent)));
        }
        return baseComponent;
    }

    public void updateOptionEntryStatuses() {
        for (Entry e : this.func_231039_at__()) {
            if (!(e instanceof OptionEntry)) continue;
            ((OptionEntry)e).updateStatus();
        }
    }

    private void addOption(Option option) {
        if (this.addedOptions.add(option)) {
            int w = this.field_230668_b_.field_71466_p.func_238414_a_((ITextProperties)OptionList.getOptionComponent(option)) + 20 * option.getDepth();
            this.maxNameWidth = Math.max(w, this.maxNameWidth);
            this.func_230513_b_((AbstractList.AbstractListEntry)new OptionEntry(option.getName(), option));
            ModernFixMixinPlugin.instance.config.getOptionMap().values().stream().filter(subOption -> subOption.getParent() == option).sorted(Comparator.comparing(Option::getName)).forEach(this::addOption);
        }
    }

    public OptionList(ModernFixConfigScreen arg, Minecraft arg2) {
        super(arg2, arg.field_230708_k_ + 45, arg.field_230709_l_, 43, arg.field_230709_l_ - 32, 20);
        this.mainScreen = arg;
        Multimap<String, Option> optionsByCategory = ModernFixMixinPlugin.instance.config.getOptionCategoryMap();
        List<String> theCategories = OptionCategories.getCategoriesInOrder();
        for (String category : theCategories) {
            String categoryTranslationKey = "modernfix.option.category." + category;
            this.func_230513_b_((AbstractList.AbstractListEntry)new CategoryEntry((ITextComponent)new TranslationTextComponent(categoryTranslationKey).func_240703_c_(Style.field_240709_b_.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent(categoryTranslationKey + ".description"))))));
            optionsByCategory.get((Object)category).stream().filter(key -> {
                int dotCount = 0;
                for (char c : key.getName().toCharArray()) {
                    if (c != '.') continue;
                    ++dotCount;
                }
                return dotCount >= 2;
            }).sorted(Comparator.comparing(Option::getName)).forEach(this::addOption);
        }
    }

    protected int func_230952_d_() {
        return super.func_230952_d_() + 15 + 20;
    }

    public int func_230949_c_() {
        return super.func_230949_c_() + 32;
    }

    public static abstract class Entry
    extends AbstractOptionList.Entry<Entry> {
    }

    class OptionEntry
    extends Entry {
        private final String name;
        private final Button toggleButton;
        private final Button helpButton;
        private final Option option;

        public OptionEntry(String optionName, Option option) {
            this.name = optionName;
            this.option = option;
            this.toggleButton = new Button(0, 0, 55, 20, (ITextComponent)new StringTextComponent(""), arg -> {
                this.option.setEnabled(!this.option.isEnabled(), !this.option.isUserDefined());
                try {
                    ModernFixMixinPlugin.instance.config.save();
                    if (!((OptionList)OptionList.this).mainScreen.madeChanges) {
                        ((OptionList)OptionList.this).mainScreen.madeChanges = true;
                    }
                }
                catch (IOException e) {
                    this.option.setEnabled(!this.option.isEnabled(), !this.option.isUserDefined());
                    ModernFix.LOGGER.error("Unable to save config", (Throwable)e);
                }
                OptionList.this.updateOptionEntryStatuses();
            }, (btn, gfx, x, y) -> {
                if (this.option.isModDefined()) {
                    String disablingMods = String.join((CharSequence)", ", this.option.getDefiningMods());
                    OptionList.this.mainScreen.func_238652_a_(gfx, (ITextComponent)new TranslationTextComponent("modernfix.option." + (this.option.isEnabled() ? "enabled" : "disabled")).func_230529_a_((ITextComponent)new TranslationTextComponent("modernfix.option.mod_override", new Object[]{disablingMods})), x, y);
                }
            });
            this.updateStatus();
            this.helpButton = new Button(75, 0, 20, 20, (ITextComponent)new StringTextComponent("?"), arg -> {
                OptionList.this.mainScreen.setLastScrollAmount(OptionList.this.func_230966_l_());
                Minecraft.func_71410_x().func_147108_a((Screen)new ModernFixOptionInfoScreen(OptionList.this.mainScreen, optionName));
            });
            if (!I18n.func_188566_a((String)("modernfix.option." + optionName))) {
                this.helpButton.field_230693_o_ = false;
                if (ModernFixPlatformHooks.INSTANCE.isDevEnv() && OPTIONS_MISSING_HELP.add(optionName)) {
                    ModernFix.LOGGER.warn("Missing help for {}", (Object)optionName);
                }
            }
        }

        void updateStatus() {
            this.toggleButton.field_230693_o_ = !this.option.isModDefined() && !this.option.isEffectivelyDisabledByParent();
        }

        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            IFormattableTextComponent nameComponent = OptionList.getOptionComponent(this.option);
            if (this.option.isUserDefined()) {
                nameComponent = nameComponent.func_240700_a_(style -> style.func_240722_b_(Boolean.valueOf(true))).func_230529_a_((ITextComponent)new TranslationTextComponent("modernfix.config.not_default"));
            }
            float textX = left + 20 * this.option.getDepth() + 160 - OptionList.this.maxNameWidth;
            float textY = top + height / 2 - 4;
            ((OptionList)OptionList.this).field_230668_b_.field_71466_p.func_243248_b(matrixStack, (ITextComponent)nameComponent, textX, textY, 0xFFFFFF);
            this.toggleButton.field_230690_l_ = left + 175;
            this.toggleButton.field_230691_m_ = top;
            this.toggleButton.func_238482_a_(this.getOptionMessage(this.option));
            this.toggleButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.helpButton.field_230690_l_ = left + 175 + 55;
            this.helpButton.field_230691_m_ = top;
            this.helpButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            if ((float)mouseX >= textX && (float)mouseY >= textY && (float)mouseX <= textX + (float)OptionList.this.maxNameWidth) {
                float f = mouseY;
                Objects.requireNonNull(((OptionList)OptionList.this).field_230668_b_.field_71466_p);
                if (f <= textY + 9.0f) {
                    OptionList.this.mainScreen.func_238653_a_(matrixStack, nameComponent.func_150256_b(), mouseX, mouseY);
                }
            }
        }

        private ITextComponent getOptionMessage(Option option) {
            return option.isEnabled() ? OPTION_ON : OPTION_OFF;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return ImmutableList.of((Object)this.toggleButton, (Object)this.helpButton);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            for (IGuiEventListener iGuiEventListener : this.func_231039_at__()) {
                if (!iGuiEventListener.func_231044_a_(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            for (IGuiEventListener iGuiEventListener : this.func_231039_at__()) {
                if (!iGuiEventListener.func_231048_c_(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }
    }

    class CategoryEntry
    extends Entry {
        private final ITextComponent name;
        private final int width;

        public CategoryEntry(ITextComponent component) {
            this.name = component;
            this.width = ((OptionList)OptionList.this).field_230668_b_.field_71466_p.func_238414_a_((ITextProperties)this.name);
        }

        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            FontRenderer var10000 = ((OptionList)OptionList.this).field_230668_b_.field_71466_p;
            float x = ((OptionList)OptionList.this).field_230668_b_.field_71462_r.field_230708_k_ / 2 - this.width / 2;
            int y = top + height - 10;
            var10000.func_243248_b(matrixStack, this.name, x, (float)y, 0xFFFFFF);
            if ((float)mouseX >= x && mouseY >= y && (float)mouseX <= x + (float)this.width) {
                Objects.requireNonNull(((OptionList)OptionList.this).field_230668_b_.field_71466_p);
                if (mouseY <= y + 9) {
                    OptionList.this.mainScreen.func_238653_a_(matrixStack, this.name.func_150256_b(), mouseX, mouseY);
                }
            }
        }

        public boolean func_231049_c__(boolean focus) {
            return false;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }
    }
}

