/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.resourcepacks;

import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.VanillaPack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.embeddedt.modernfix.FileWalker;
import org.embeddedt.modernfix.util.FileUtil;
import org.embeddedt.modernfix.util.PackTypeHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VanillaPack.class})
public class VanillaPackMixin {
    @Shadow
    @Final
    private static Map<ResourcePackType, FileSystem> field_217810_e;
    private static LoadingCache<Pair<Path, Integer>, List<Path>> pathStreamLoadingCache;
    private static Set<String> containedPaths;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void cacheContainedPaths(String[] p_i47912_1_, CallbackInfo ci) {
        if (containedPaths != null) {
            return;
        }
        containedPaths = new ObjectOpenHashSet();
        Joiner slashJoiner = Joiner.on((char)'/');
        for (ResourcePackType type : ResourcePackType.values()) {
            if (!PackTypeHelper.isVanillaPackType(type)) continue;
            FileSystem fs = field_217810_e.get(type);
            if (fs == null) {
                throw new IllegalStateException("No filesystem for vanilla " + type.name() + " assets");
            }
            try {
                Path root = fs.getPath(type.func_198956_a(), new String[0]).toAbsolutePath();
                try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
                    stream.map(path -> root.relativize(path.toAbsolutePath())).forEach(path -> containedPaths.add(slashJoiner.join((Object)type.func_198956_a(), path, new Object[0])));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ((ObjectOpenHashSet)containedPaths).trim();
    }

    @Redirect(method={"getResources(Ljava/util/Collection;ILjava/lang/String;Ljava/nio/file/Path;Ljava/lang/String;Ljava/util/function/Predicate;)V"}, at=@At(value="INVOKE", target="Ljava/nio/file/Files;walk(Ljava/nio/file/Path;I[Ljava/nio/file/FileVisitOption;)Ljava/util/stream/Stream;"))
    private static Stream<Path> useCacheForLoading(Path path, int maxDepth, FileVisitOption[] fileVisitOptions) throws IOException {
        try {
            return ((List)pathStreamLoadingCache.get((Object)Pair.of((Object)path, (Object)maxDepth))).stream();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    @Inject(method={"hasResource"}, at={@At(value="INVOKE", target="Ljava/lang/Class;getResource(Ljava/lang/String;)Ljava/net/URL;")}, cancellable=true)
    private void useCacheForExistence(ResourcePackType type, ResourceLocation location, CallbackInfoReturnable<Boolean> cir) {
        if (!PackTypeHelper.isVanillaPackType(type)) {
            return;
        }
        cir.setReturnValue((Object)containedPaths.contains(type.func_198956_a() + "/" + location.func_110624_b() + "/" + FileUtil.normalize(location.func_110623_a())));
    }

    static {
        pathStreamLoadingCache = CacheBuilder.newBuilder().build((CacheLoader)FileWalker.INSTANCE);
        containedPaths = null;
    }
}

