/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.dynamic_resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.VanillaPack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.packs.DelegatingResourcePack;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.duck.IExtendedModelBakery;
import org.embeddedt.modernfix.dynamicresources.DynamicBakedModelProvider;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelBakery.class}, priority=600)
@ClientOnlyMixin
public abstract class ModelBakeryMixin
implements IExtendedModelBakery {
    private static final boolean debugDynamicModelLoading = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    @Shadow
    @Final
    @Mutable
    public Map<ResourceLocation, IUnbakedModel> field_217849_F;
    @Shadow
    @Final
    public static ModelResourceLocation field_177604_a;
    @Shadow
    @Final
    protected IResourceManager field_177598_f;
    @Shadow
    @javax.annotation.Nullable
    private SpriteMap field_229322_z_;
    @Shadow
    @Final
    private Set<ResourceLocation> field_217848_D;
    @Shadow
    @Final
    private static Logger field_177603_c;
    @Shadow
    @Final
    @Mutable
    private Map<ResourceLocation, IBakedModel> field_217852_I;
    @Shadow
    @Final
    @Mutable
    private Map<Triple<ResourceLocation, TransformationMatrix, Boolean>, IBakedModel> field_217850_G;
    @Shadow
    @Final
    public static BlockModel field_177606_o;
    @Shadow
    @Final
    private static ItemModelGenerator field_217854_z;
    private Cache<Triple<ResourceLocation, TransformationMatrix, Boolean>, IBakedModel> loadedBakedModels;
    private Cache<ResourceLocation, IUnbakedModel> loadedModels;
    private HashMap<ResourceLocation, IUnbakedModel> smallLoadingCache = new HashMap();
    private IUnbakedModel missingModel;
    private Set<ResourceLocation> blockStateFiles;
    private Set<ResourceLocation> modelFiles;
    private int mfix$nestedLoads = 0;
    private IBakedModel bakedMissingModel = null;

    @Shadow
    protected abstract BlockModel func_177594_c(ResourceLocation var1) throws IOException;

    @Shadow
    protected abstract void func_209598_b(ResourceLocation var1) throws Exception;

    @Shadow
    public abstract IUnbakedModel func_209597_a(ResourceLocation var1);

    @Shadow
    @javax.annotation.Nullable
    public abstract IBakedModel getBakedModel(ResourceLocation var1, IModelTransform var2, Function<RenderMaterial, TextureAtlasSprite> var3);

    @Shadow
    @Nullable
    public abstract IBakedModel func_217845_a(ResourceLocation var1, IModelTransform var2);

    @Inject(method={"<init>(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/color/block/BlockColors;Z)V"}, at={@At(value="RETURN")})
    private void replaceTopLevelBakedModels(IResourceManager manager, BlockColors colors, boolean vanillaBakery, CallbackInfo ci) {
        this.loadedBakedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).softValues().build();
        this.loadedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).softValues().build();
        this.field_217850_G = this.loadedBakedModels.asMap();
        this.field_217849_F = this.loadedModels.asMap();
        this.field_217852_I = new DynamicBakedModelProvider((ModelBakery)this, this.field_217850_G);
    }

    private <K, V> void onModelRemoved(RemovalNotification<K, V> notification) {
        ResourceLocation rl;
        if (!debugDynamicModelLoading) {
            return;
        }
        Object k = notification.getKey();
        if (k == null) {
            return;
        }
        boolean baked = false;
        if (k instanceof ResourceLocation) {
            rl = (ResourceLocation)k;
        } else {
            rl = (ResourceLocation)((Triple)k).getLeft();
            baked = true;
        }
        ModernFix.LOGGER.warn("Evicted {} model {}", (Object)(baked ? "baked" : "unbaked"), (Object)rl);
    }

    @Redirect(method={"processLoading"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/ModelBakery;loadBlockModel(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/block/model/BlockModel;", ordinal=0))
    private BlockModel captureMissingModel(ModelBakery bakery, ResourceLocation location) throws IOException {
        this.missingModel = this.func_177594_c(location);
        this.blockStateFiles = new HashSet<ResourceLocation>();
        this.modelFiles = new HashSet<ResourceLocation>();
        return (BlockModel)this.missingModel;
    }

    @Inject(method={"loadTopLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void addTopLevelFile(ModelResourceLocation location, CallbackInfo ci) {
        ci.cancel();
        if (Objects.equals(location.func_177518_c(), "inventory")) {
            this.modelFiles.add(new ResourceLocation(location.func_110624_b(), "item/" + location.func_110623_a()));
        } else {
            this.blockStateFiles.add(new ResourceLocation(location.func_110624_b(), location.func_110623_a()));
        }
    }

    @Redirect(method={"processLoading"}, at=@At(value="INVOKE", target="Ljava/util/Collection;stream()Ljava/util/stream/Stream;", ordinal=0))
    private Stream<?> getModelStream(Collection<?> modelCollection) {
        return new ArrayList(modelCollection).stream();
    }

    @Redirect(method={"processLoading"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/client/ForgeHooksClient;gatherFluidTextures(Ljava/util/Set;)V", remap=false))
    private void gatherModelTextures(Set<RenderMaterial> materialSet) {
        ForgeHooksClient.gatherFluidTextures(materialSet);
        this.gatherModelMaterials(materialSet);
    }

    @Redirect(method={"processLoading"}, at=@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V", ordinal=0))
    private void fetchStaticDefinitions(Map<ResourceLocation, StateContainer<Block, BlockState>> map, BiConsumer<ResourceLocation, StateContainer<Block, BlockState>> func) {
        map.forEach((loc, def) -> this.blockStateFiles.add((ResourceLocation)loc));
    }

    @Redirect(method={"processLoading"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;", ordinal=0))
    private ImmutableList<BlockState> fetchBlocks(StateContainer<Block, BlockState> def) {
        this.blockStateFiles.add(((BlockState)def.func_177621_b()).func_177230_c().getRegistryName());
        return ImmutableList.of();
    }

    private boolean trustedResourcePack(IResourcePack pack) {
        return pack instanceof VanillaPack || pack instanceof ModFileResourcePack || pack instanceof DownloadingPackFinder || pack instanceof DelegatingResourcePack || pack instanceof FolderPack || pack instanceof FilePack;
    }

    private void gatherModelMaterials(Set<RenderMaterial> materialSet) {
        Function<JsonElement, BlockModel> modelDeserializer = model -> (BlockModel)ModelLoaderRegistry.ExpandedBlockModelDeserializer.INSTANCE.fromJson(model, BlockModel.class);
        ModelBakeryHelpers.gatherModelMaterials(this.field_177598_f, this::trustedResourcePack, materialSet, this.blockStateFiles, this.modelFiles, this.missingModel, modelDeserializer, this::func_209597_a);
        this.loadedModels.invalidateAll();
        this.loadedModels.put((Object)field_177604_a, (Object)this.missingModel);
    }

    @Redirect(method={"uploadTextures"}, at=@At(value="INVOKE", target="Ljava/util/Set;forEach(Ljava/util/function/Consumer;)V", ordinal=0))
    private void skipBake(Set instance, Consumer consumer, TextureManager resourceManager, IProfiler profiler) {
        this.field_217852_I.put((ResourceLocation)field_177604_a, this.getBakedModel((ResourceLocation)field_177604_a, (IModelTransform)ModelRotation.X0_Y0, arg_0 -> ((SpriteMap)this.field_229322_z_).func_229151_a_(arg_0)));
        DynamicBakedModelProvider.currentInstance = (DynamicBakedModelProvider)this.field_217852_I;
    }

    @Redirect(method={"loadModel"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1))
    private Object getMissingModel(Map map, Object rl) {
        if (rl == field_177604_a && map == this.field_217849_F) {
            return this.missingModel;
        }
        return this.field_217849_F.get(rl);
    }

    @ModifyVariable(method={"cacheAndQueueDependencies"}, at=@At(value="HEAD"), argsOnly=true)
    private IUnbakedModel fireUnbakedEvent(IUnbakedModel model, ResourceLocation location) {
        for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
            try {
                model = integration.onUnbakedModelLoad(location, model, (ModelBakery)this);
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Exception firing model load event for {}", (Object)location, (Object)e);
            }
        }
        return model;
    }

    @Inject(method={"cacheAndQueueDependencies"}, at={@At(value="RETURN")})
    private void addToSmallLoadingCache(ResourceLocation location, IUnbakedModel model, CallbackInfo ci) {
        this.smallLoadingCache.put(location, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getModel"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOrLoadModelDynamic(ResourceLocation modelLocation, CallbackInfoReturnable<IUnbakedModel> cir) {
        if (modelLocation.equals((Object)field_177604_a)) {
            cir.setReturnValue((Object)this.missingModel);
            return;
        }
        IUnbakedModel existing = this.field_217849_F.get(modelLocation);
        if (existing != null) {
            cir.setReturnValue((Object)existing);
        } else {
            ModelBakeryMixin modelBakeryMixin = this;
            synchronized (modelBakeryMixin) {
                if (this.field_217848_D.contains(modelLocation)) {
                    throw new IllegalStateException("Circular reference while loading " + modelLocation);
                }
                this.field_217848_D.add(modelLocation);
                IUnbakedModel iunbakedmodel = this.missingModel;
                while (!this.field_217848_D.isEmpty()) {
                    ResourceLocation resourcelocation = this.field_217848_D.iterator().next();
                    ++this.mfix$nestedLoads;
                    try {
                        existing = this.field_217849_F.get(resourcelocation);
                        if (existing == null) {
                            if (debugDynamicModelLoading) {
                                field_177603_c.info("Loading {}", (Object)resourcelocation);
                            }
                            this.func_209598_b(resourcelocation);
                            continue;
                        }
                        this.smallLoadingCache.put(resourcelocation, existing);
                    }
                    catch (ModelBakery.BlockStateDefinitionException var9) {
                        field_177603_c.warn(var9.getMessage());
                        this.field_217849_F.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    catch (Exception var10) {
                        field_177603_c.warn("Unable to load model: '{}' referenced from: {}: {}", (Object)resourcelocation, (Object)modelLocation, (Object)var10);
                        this.field_217849_F.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    finally {
                        --this.mfix$nestedLoads;
                        this.field_217848_D.remove(resourcelocation);
                    }
                }
                IUnbakedModel result = this.smallLoadingCache.getOrDefault(modelLocation, iunbakedmodel);
                try {
                    result.func_225614_a_(this::func_209597_a, new HashSet());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (this.mfix$nestedLoads == 0) {
                    this.smallLoadingCache.clear();
                }
                cir.setReturnValue((Object)result);
            }
        }
    }

    private <T extends Comparable<T>, V extends T> BlockState setPropertyGeneric(BlockState state, Property<T> prop, Object o) {
        return (BlockState)state.func_206870_a(prop, (Comparable)o);
    }

    @Redirect(method={"loadModel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;"))
    private ImmutableList<BlockState> loadOnlyRelevantBlockState(StateContainer<Block, BlockState> stateDefinition, ResourceLocation location) {
        if (!(location instanceof ModelResourceLocation) || Minecraft.func_71410_x().field_71441_e == null) {
            return stateDefinition.func_177619_a();
        }
        return ModelBakeryHelpers.getBlockStatesForMRL(stateDefinition, (ModelResourceLocation)location);
    }

    @Override
    public ImmutableList<BlockState> getBlockStatesForMRL(StateContainer<Block, BlockState> stateDefinition, ModelResourceLocation location) {
        return this.loadOnlyRelevantBlockState(stateDefinition, (ResourceLocation)location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getBakedModel"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOrLoadBakedModelDynamic(ResourceLocation arg, IModelTransform arg2, Function<RenderMaterial, TextureAtlasSprite> textureGetter, CallbackInfoReturnable<IBakedModel> cir) {
        Triple triple = Triple.of((Object)arg, (Object)arg2.func_225615_b_(), (Object)arg2.func_188049_c());
        IBakedModel existing = this.field_217850_G.get(triple);
        if (existing != null) {
            cir.setReturnValue((Object)existing);
        } else {
            if (this.field_229322_z_ == null) {
                throw new IllegalStateException("bake called too early");
            }
            ModelBakeryMixin modelBakeryMixin = this;
            synchronized (modelBakeryMixin) {
                BlockModel blockmodel;
                if (debugDynamicModelLoading) {
                    field_177603_c.info("Baking {}", (Object)arg);
                }
                IUnbakedModel iunbakedmodel = this.func_209597_a(arg);
                iunbakedmodel.func_225614_a_(this::func_209597_a, new HashSet());
                if (iunbakedmodel == this.missingModel && debugDynamicModelLoading) {
                    field_177603_c.warn("Model {} not present", (Object)arg);
                }
                if (iunbakedmodel != this.missingModel) {
                    for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
                        try {
                            iunbakedmodel = integration.onUnbakedModelPreBake(arg, iunbakedmodel, (ModelBakery)this);
                        }
                        catch (RuntimeException e) {
                            ModernFix.LOGGER.error("Exception encountered firing bake event for {}", (Object)arg, (Object)e);
                        }
                    }
                }
                IBakedModel ibakedmodel = null;
                if (iunbakedmodel instanceof BlockModel && (blockmodel = (BlockModel)iunbakedmodel).func_178310_f() == field_177606_o) {
                    ibakedmodel = field_217854_z.func_209579_a(textureGetter, blockmodel).func_228813_a_((ModelBakery)this, blockmodel, textureGetter, arg2, arg, false);
                }
                if (ibakedmodel == null) {
                    if (iunbakedmodel == this.missingModel) {
                        if (this.bakedMissingModel == null) {
                            this.bakedMissingModel = iunbakedmodel.func_225613_a_((ModelBakery)this, textureGetter, arg2, arg);
                            ((DynamicBakedModelProvider)this.field_217852_I).setMissingModel(this.bakedMissingModel);
                        }
                        ibakedmodel = this.bakedMissingModel;
                    } else {
                        ibakedmodel = iunbakedmodel.func_225613_a_((ModelBakery)this, textureGetter, arg2, arg);
                    }
                }
                for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
                    try {
                        ibakedmodel = integration.onBakedModelLoad(arg, iunbakedmodel, ibakedmodel, arg2, (ModelBakery)this);
                    }
                    catch (RuntimeException e) {
                        ModernFix.LOGGER.error("Exception encountered firing bake event for {}", (Object)arg, (Object)e);
                    }
                }
                this.field_217850_G.put((Triple<ResourceLocation, TransformationMatrix, Boolean>)triple, ibakedmodel);
                cir.setReturnValue((Object)ibakedmodel);
            }
        }
    }
}

