/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.bugfix.refinedstorage.te_bug;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.apiimpl.storage.externalstorage.FluidExternalStorageCache;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.forge.rs.IFluidExternalStorageCache;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FluidExternalStorageCache.class})
@RequiresMod(value="refinedstorage")
public class FluidExternalStorageCacheMixin
implements IFluidExternalStorageCache {
    @Shadow(remap=false)
    private List<FluidStack> cache;
    @Shadow(remap=false)
    private int stored;

    @Override
    public boolean initCache(IFluidHandler handler) {
        if (this.cache != null) {
            return false;
        }
        this.cache = new ArrayList<FluidStack>();
        int stored = 0;
        for (int i = 0; i < handler.getTanks(); ++i) {
            FluidStack stack = handler.getFluidInTank(i).copy();
            this.cache.add(stack);
            stored += stack.getAmount();
        }
        this.stored = stored;
        return true;
    }

    @Inject(method={"update"}, at={@At(value="FIELD", target="Lcom/refinedmods/refinedstorage/apiimpl/storage/externalstorage/FluidExternalStorageCache;cache:Ljava/util/List;", ordinal=0)}, cancellable=true, remap=false)
    private void checkNullCache(INetwork network, @Nullable IFluidHandler handler, CallbackInfo ci) {
        if (this.initCache(handler)) {
            ci.cancel();
        }
    }
}

