/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.datagen;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DatagenModLoader;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.embeddedt.modernfix.ModernFix;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RuntimeDatagen {
    private static final String RESOURCES_OUT_DIR = RuntimeDatagen.getPropertyOrBlank("modernfix.datagen.output");
    private static final String RESOURCES_IN_DIR = RuntimeDatagen.getPropertyOrBlank("modernfix.datagen.existing");
    private static final String MODS_LIST = RuntimeDatagen.getPropertyOrBlank("modernfix.datagen.mods");
    private static final String EXISTING_MODS_LIST = RuntimeDatagen.getPropertyOrBlank("modernfix.datagen.existing_mods");
    private static final boolean IS_FLAT = Boolean.getBoolean("modernfix.datagen.flat");

    private static String getPropertyOrBlank(String name) {
        String val = System.getProperty(name);
        if (val == null || val.length() == 0) {
            return "";
        }
        return val;
    }

    public static boolean isDatagenAvailable() {
        return RESOURCES_OUT_DIR.length() > 0;
    }

    public static void runRuntimeDatagen() {
        ObfuscationReflectionHelper.setPrivateValue(DatagenModLoader.class, null, (Object)true, (String)"runningDataGen");
        HashSet mods = new HashSet(Arrays.stream(MODS_LIST.split(",")).collect(Collectors.toSet()));
        ModernFix.LOGGER.info("Beginning runtime datagen for " + mods.size() + " mods...");
        HashSet<String> existingMods = new HashSet<String>(Arrays.stream(EXISTING_MODS_LIST.split(",")).collect(Collectors.toSet()));
        HashSet existingPacks = new HashSet(Arrays.stream(RESOURCES_IN_DIR.split(",")).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet()));
        Path path = Paths.get(RESOURCES_OUT_DIR, new String[0]);
        GatherDataEvent.DataGeneratorConfig dataGeneratorConfig = new GatherDataEvent.DataGeneratorConfig(mods, path, Collections.emptyList(), true, true, true, true, true, mods.isEmpty() || IS_FLAT);
        if (!mods.contains("forge")) {
            existingMods.add("forge");
        }
        ExistingFileHelper existingFileHelper = new ExistingFileHelper(existingPacks, existingMods, true, null, null);
        ((SimpleReloadableResourceManager)ObfuscationReflectionHelper.getPrivateValue(ExistingFileHelper.class, (Object)existingFileHelper, (String)"clientResources")).func_199021_a((IResourcePack)Minecraft.func_71410_x().func_195541_I().func_195746_a());
        ModLoader.get().runEventGenerator(mc -> new GatherDataEvent(mc, dataGeneratorConfig.makeGenerator(p -> dataGeneratorConfig.isFlat() ? p : p.resolve(mc.getModId()), dataGeneratorConfig.getMods().contains(mc.getModId())), dataGeneratorConfig, existingFileHelper));
        dataGeneratorConfig.runAll();
        ObfuscationReflectionHelper.setPrivateValue(DatagenModLoader.class, null, (Object)false, (String)"runningDataGen");
        ModernFix.LOGGER.info("Finished runtime datagen.");
    }

    @SubscribeEvent
    public static void onInitTitleScreen(GuiScreenEvent.InitGuiEvent.Post event) {
        if (RuntimeDatagen.isDatagenAvailable() && event.getGui() instanceof MainMenuScreen) {
            MainMenuScreen screen = (MainMenuScreen)event.getGui();
            screen.func_230480_a_((Widget)new Button(screen.field_230708_k_ / 2 - 100 - 50, screen.field_230709_l_ / 4 + 48, 50, 20, (ITextComponent)new StringTextComponent("DG"), arg -> RuntimeDatagen.runRuntimeDatagen()));
        }
    }
}

