/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.registry.Registry;
import org.apache.commons.lang3.tuple.Triple;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBakedModelProvider
implements Map<ResourceLocation, IBakedModel> {
    private static final ImmutableSet<ResourceLocation> BAKE_SKIPPED_TOPLEVEL = ImmutableSet.builder().add((Object)new ResourceLocation("custommachinery", "block/custom_machine_block")).build();
    public static DynamicBakedModelProvider currentInstance = null;
    private final ModelBakery bakery;
    private final Map<Triple<ResourceLocation, TransformationMatrix, Boolean>, IBakedModel> bakedCache;
    private final Map<ResourceLocation, IBakedModel> permanentOverrides;
    private IBakedModel missingModel;
    private static final IBakedModel SENTINEL = new IBakedModel(){

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            return null;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_230044_c_() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return null;
        }

        public ItemOverrideList func_188617_f() {
            return null;
        }
    };

    public DynamicBakedModelProvider(ModelBakery bakery, Map<Triple<ResourceLocation, TransformationMatrix, Boolean>, IBakedModel> cache) {
        this.bakery = bakery;
        this.bakedCache = cache;
        this.permanentOverrides = Collections.synchronizedMap(new Object2ObjectOpenHashMap());
        if (currentInstance == null) {
            currentInstance = this;
        }
    }

    public void setMissingModel(IBakedModel model) {
        this.missingModel = model;
    }

    private static Triple<ResourceLocation, TransformationMatrix, Boolean> vanillaKey(Object o) {
        return Triple.of((Object)((ResourceLocation)o), (Object)ModelRotation.X0_Y0.func_225615_b_(), (Object)false);
    }

    @Override
    public int size() {
        return this.bakedCache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bakedCache.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.permanentOverrides.getOrDefault(o, SENTINEL) != null;
    }

    @Override
    public boolean containsValue(Object o) {
        return this.permanentOverrides.containsValue(o) || this.bakedCache.containsValue(o);
    }

    private static boolean isVanillaTopLevelModel(ResourceLocation location) {
        if (location instanceof ModelResourceLocation) {
            try {
                ModelResourceLocation mrl = (ModelResourceLocation)location;
                ResourceLocation registryKey = new ResourceLocation(mrl.func_110624_b(), mrl.func_110623_a());
                if (mrl.func_177518_c().equals("inventory") && Registry.field_212630_s.func_212607_c(registryKey)) {
                    return true;
                }
                Optional blockOpt = Registry.field_212618_g.func_241873_b(registryKey);
                if (blockOpt.isPresent()) {
                    return ModelBakeryHelpers.getBlockStatesForMRL((StateContainer<Block, BlockState>)((Block)blockOpt.get()).func_176194_O(), mrl).size() > 0;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return location.func_110624_b().equals("minecraft") && location.func_110623_a().equals("builtin/missing");
    }

    @Override
    public IBakedModel get(Object o) {
        IBakedModel model = this.permanentOverrides.getOrDefault(o, SENTINEL);
        if (model != SENTINEL) {
            return model;
        }
        try {
            model = BAKE_SKIPPED_TOPLEVEL.contains((Object)((ResourceLocation)o)) ? this.missingModel : this.bakery.func_217845_a((ResourceLocation)o, (IModelTransform)ModelRotation.X0_Y0);
        }
        catch (RuntimeException e) {
            ModernFix.LOGGER.error("Exception baking {}: {}", o, (Object)e);
            model = this.missingModel;
        }
        if (model == this.missingModel) {
            model = DynamicBakedModelProvider.isVanillaTopLevelModel((ResourceLocation)o) ? model : null;
            this.permanentOverrides.put((ResourceLocation)o, model);
        }
        return model;
    }

    @Override
    public IBakedModel put(ResourceLocation resourceLocation, IBakedModel bakedModel) {
        IBakedModel m = this.permanentOverrides.put(resourceLocation, bakedModel);
        if (m != null) {
            return m;
        }
        return this.bakedCache.get(DynamicBakedModelProvider.vanillaKey(resourceLocation));
    }

    @Override
    public IBakedModel remove(Object o) {
        IBakedModel m = this.permanentOverrides.remove(o);
        if (m != null) {
            return m;
        }
        return this.bakedCache.remove(DynamicBakedModelProvider.vanillaKey(o));
    }

    @Override
    public void putAll(@NotNull Map<? extends ResourceLocation, ? extends IBakedModel> map) {
        this.permanentOverrides.putAll(map);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<ResourceLocation> keySet() {
        return this.bakedCache.keySet().stream().map(Triple::getLeft).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<IBakedModel> values() {
        return this.bakedCache.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<ResourceLocation, IBakedModel>> entrySet() {
        return this.bakedCache.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<ResourceLocation, IBakedModel>((ResourceLocation)((Triple)entry.getKey()).getLeft(), (IBakedModel)entry.getValue())).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public IBakedModel replace(ResourceLocation key, IBakedModel value) {
        IBakedModel existingOverride = this.permanentOverrides.get(key);
        if (existingOverride == null) {
            return this.put(key, value);
        }
        return existingOverride;
    }

    @Override
    public void replaceAll(BiFunction<? super ResourceLocation, ? super IBakedModel, ? extends IBakedModel> function) {
        Set<ResourceLocation> overridenLocations = this.permanentOverrides.keySet();
        this.permanentOverrides.replaceAll(function);
        boolean uvLock = ModelRotation.X0_Y0.func_188049_c();
        TransformationMatrix rotation = ModelRotation.X0_Y0.func_225615_b_();
        this.bakedCache.replaceAll((? super K loc, ? super V oldModel) -> {
            if (loc.getMiddle() != rotation || (Boolean)loc.getRight() != uvLock || overridenLocations.contains(loc.getLeft())) {
                return oldModel;
            }
            return (IBakedModel)function.apply((ResourceLocation)loc.getLeft(), (IBakedModel)oldModel);
        });
    }
}

