/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.cache_strongholds;

import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.duck.IServerLevel;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.world.StrongholdLocationCache;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkGenerator.class})
public class ChunkGeneratorMixin {
    @Shadow
    @Final
    private List<ChunkPos> field_235951_f_;

    @Inject(method={"generateStrongholds"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList()Ljava/util/ArrayList;", ordinal=0, remap=false)}, cancellable=true)
    private void useCachedDataIfAvailable(CallbackInfo ci) {
        ServerWorld level = this.searchLevel();
        if (level == null) {
            ModernFix.LOGGER.error("Can't find server level for " + this);
            return;
        }
        StrongholdLocationCache cache = ((IServerLevel)level).mfix$getStrongholdCache();
        List<ChunkPos> positions = cache.getChunkPosList();
        if (positions.isEmpty()) {
            return;
        }
        ModernFix.LOGGER.debug("Loaded stronghold cache for dimension {} with {} positions", (Object)level.func_234923_W_().func_240901_a_(), (Object)positions.size());
        this.field_235951_f_.addAll(positions);
        ci.cancel();
    }

    private ServerWorld searchLevel() {
        MinecraftServer server = ModernFixPlatformHooks.INSTANCE.getCurrentServer();
        if (server != null) {
            ServerWorld ourLevel = null;
            for (ServerWorld level : server.func_212370_w()) {
                if (level.func_72863_F().func_201711_g() != (ChunkGenerator)this) continue;
                ourLevel = level;
                break;
            }
            return ourLevel;
        }
        return null;
    }

    @Inject(method={"generateStrongholds"}, at={@At(value="TAIL")})
    private void saveCachedData(CallbackInfo ci) {
        ServerWorld level;
        if (this.field_235951_f_.size() > 0 && (level = this.searchLevel()) != null) {
            StrongholdLocationCache cache = ((IServerLevel)level).mfix$getStrongholdCache();
            cache.setChunkPosList(this.field_235951_f_);
            ModernFix.LOGGER.debug("Saved stronghold cache for dimension {}", (Object)level.func_234923_W_().func_240901_a_());
        }
    }
}

