/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.network;

import com.mrcrayfish.obfuscate.common.data.SyncedDataKey;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class HandshakeMessages {

    public static class S2CSyncedPlayerData
    extends LoginIndexedMessage {
        private Map<ResourceLocation, Integer> keyMap;

        public S2CSyncedPlayerData() {
            this.keyMap = new HashMap<ResourceLocation, Integer>();
            List<SyncedDataKey<?>> keys = SyncedPlayerData.instance().getKeys();
            keys.forEach(syncedDataKey -> this.keyMap.put(syncedDataKey.getKey(), syncedDataKey.getId()));
        }

        private S2CSyncedPlayerData(Map<ResourceLocation, Integer> keyMap) {
            this.keyMap = keyMap;
        }

        void encode(PacketBuffer output) {
            List<SyncedDataKey<?>> keys = SyncedPlayerData.instance().getKeys();
            keys.forEach(syncedDataKey -> {
                output.func_192572_a(syncedDataKey.getKey());
                output.func_150787_b(syncedDataKey.getId());
            });
        }

        static S2CSyncedPlayerData decode(PacketBuffer input) {
            HashMap<ResourceLocation, Integer> keyMap = new HashMap<ResourceLocation, Integer>();
            List<SyncedDataKey<?>> keys = SyncedPlayerData.instance().getKeys();
            keys.forEach(syncedDataKey -> keyMap.put(input.func_192575_l(), input.func_150792_a()));
            return new S2CSyncedPlayerData(keyMap);
        }

        public Map<ResourceLocation, Integer> getKeyMap() {
            return this.keyMap;
        }
    }

    static class C2SAcknowledge
    extends LoginIndexedMessage {
        C2SAcknowledge() {
        }

        void encode(PacketBuffer buf) {
        }

        static C2SAcknowledge decode(PacketBuffer buf) {
            return new C2SAcknowledge();
        }
    }

    static class LoginIndexedMessage
    implements IntSupplier {
        private int loginIndex;

        LoginIndexedMessage() {
        }

        void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }

        int getLoginIndex() {
            return this.loginIndex;
        }

        @Override
        public int getAsInt() {
            return this.getLoginIndex();
        }
    }
}

