/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Supplier;
import net.minecraftforge.fml.loading.FMLPaths;

public class JsonConfig<T> {
    private static final Gson DEFAULT_GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File configFile;
    private final CachedSupplier<T> configGetter;
    private Gson gson = DEFAULT_GSON;

    public JsonConfig(String fileName, Class<T> configClass, Supplier<T> defaultFactory) {
        this.configFile = new File(FMLPaths.CONFIGDIR.get().toFile(), fileName + (fileName.endsWith(".json") ? "" : ".json"));
        this.configGetter = new CachedSupplier<Object>(() -> {
            if (!this.configFile.exists()) {
                Object def = defaultFactory.get();
                this.write(def, false);
                return def;
            }
            try (FileReader reader = new FileReader(this.configFile);){
                Object object = this.gson.fromJson((Reader)reader, configClass);
                return object;
            }
            catch (IOException e) {
                e.printStackTrace();
                return defaultFactory.get();
            }
        });
    }

    public JsonConfig(String fileName, Class<T> configClass) {
        this(fileName, configClass, () -> {
            try {
                return configClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to create new config instance", e);
            }
        });
    }

    public JsonConfig<T> withGson(Gson gson) {
        this.gson = gson;
        return this;
    }

    public T get() {
        return this.configGetter.get();
    }

    public void save() {
        this.write(this.get(), false);
    }

    public void write(T t, boolean invalidate) {
        if (!this.configFile.getParentFile().exists()) {
            this.configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(this.configFile);){
            writer.write(this.gson.toJson(t));
            if (invalidate) {
                this.invalidate();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void invalidate() {
        this.configGetter.invalidate();
    }

    static class CachedSupplier<T> {
        private final Supplier<T> supplier;
        private T value;

        public CachedSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public T get() {
            return this.value == null ? (this.value = this.supplier.get()) : this.value;
        }

        public void invalidate() {
            this.value = null;
        }
    }
}

