/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl;

import com.mrcrayfish.configured.api.IConfigValue;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeValue<T>
implements IConfigValue<T> {
    public final ForgeConfigSpec.ConfigValue<T> configValue;
    public final ForgeConfigSpec.ValueSpec valueSpec;
    private final T initialValue;
    protected T value;

    public ForgeValue(ForgeConfigSpec.ConfigValue<T> configValue, ForgeConfigSpec.ValueSpec valueSpec) {
        this.configValue = configValue;
        this.valueSpec = valueSpec;
        this.initialValue = configValue.get();
        this.set(configValue.get());
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void set(T value) {
        this.value = value;
    }

    @Override
    public boolean isDefault() {
        return Objects.equals(this.get(), this.valueSpec.getDefault());
    }

    @Override
    public boolean isChanged() {
        return !Objects.equals(this.get(), this.initialValue);
    }

    @Override
    public void restore() {
        this.set(this.getDefault());
    }

    @Override
    public T getDefault() {
        return (T)this.valueSpec.getDefault();
    }

    @Override
    public boolean isValid(T value) {
        return this.valueSpec.test(value);
    }

    @Override
    public String getComment() {
        return this.valueSpec.getComment();
    }

    @Override
    public String getTranslationKey() {
        return this.valueSpec.getTranslationKey();
    }

    @Override
    public String getPath() {
        return ForgeValue.lastValue(this.configValue.getPath(), "");
    }

    @Override
    public void cleanCache() {
        this.configValue.clearCache();
    }

    public static <V> V lastValue(List<V> list, V defaultValue) {
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return defaultValue;
    }
}

