/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.ILabelProvider;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ChangeEnumScreen
extends Screen
implements IBackgroundTexture {
    private final Screen parent;
    private final Consumer<Enum<?>> onSave;
    private final ResourceLocation background;
    private Enum<?> selectedValue;
    private EnumList list;
    private List<Entry> entries;
    private TextFieldWidget searchTextField;
    private List<IReorderingProcessor> activeTooltip;

    protected ChangeEnumScreen(Screen parent, ITextComponent title, ResourceLocation background, Enum<?> value, Consumer<Enum<?>> onSave) {
        super(title);
        this.parent = parent;
        this.onSave = onSave;
        this.background = background;
        this.selectedValue = value;
    }

    protected void func_231160_c_() {
        this.constructEntries();
        this.list = new EnumList(this.entries);
        this.list.func_244605_b(!ListMenuScreen.isPlayingGame());
        this.list.func_241215_a_(this.list.func_231039_at__().stream().filter(entry -> entry.getEnumValue() == this.selectedValue).findFirst().orElse(null));
        this.field_230705_e_.add(this.list);
        this.searchTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 110, 22, 220, 20, (ITextComponent)new StringTextComponent("Search"));
        this.searchTextField.func_212954_a(s -> {
            ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, s, this.entries);
            this.list.func_230942_a_(s.isEmpty() ? this.entries : (Collection)this.entries.stream().filter(entry -> entry.getFormattedLabel().getString().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList()));
            if (!s.isEmpty()) {
                this.list.func_230932_a_(0.0);
            }
        });
        this.field_230705_e_.add(this.searchTextField);
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, "", this.entries);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 29, 150, 20, DialogTexts.field_240632_c_, button -> {
            if (this.list.func_230958_g_() != null) {
                this.onSave.accept(((Entry)this.list.func_230958_g_()).enumValue);
            }
            this.field_230706_i_.func_147108_a(this.parent);
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155 + 160, this.field_230709_l_ - 29, 150, 20, DialogTexts.field_240633_d_, button -> this.field_230706_i_.func_147108_a(this.parent)));
    }

    private void constructEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        Enum<?> value = this.selectedValue;
        if (value != null) {
            ?[] enums;
            for (Object e : enums = value.getDeclaringClass().getEnumConstants()) {
                entries.add(new Entry((Enum)e));
            }
        }
        entries.sort(Comparator.comparing(entry -> entry.getFormattedLabel().getString()));
        this.entries = ImmutableList.copyOf(entries);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.func_230446_a_(matrixStack);
        this.list.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchTextField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ChangeEnumScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)7, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.field_230706_i_.func_110434_K().func_110577_a(ListMenuScreen.CONFIGURED_LOGO);
        ChangeEnumScreen.func_238464_a_((MatrixStack)matrixStack, (int)10, (int)13, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)23, (int)23, (int)32, (int)32);
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.activeTooltip = this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("configured.gui.info"), 200);
        }
        if (this.activeTooltip != null) {
            this.func_238654_b_(matrixStack, this.activeTooltip, mouseX, mouseY);
        }
    }

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    public class Entry
    extends ExtendedList.AbstractListEntry<Entry>
    implements ILabelProvider {
        private final Enum<?> enumValue;
        private final StringTextComponent label;

        public Entry(Enum<?> enumValue) {
            this.enumValue = enumValue;
            this.label = new StringTextComponent(ConfigScreen.createLabel(enumValue.name().toLowerCase(Locale.ENGLISH)));
        }

        public Enum<?> getEnumValue() {
            return this.enumValue;
        }

        @Override
        public String getLabel() {
            return this.label.func_150261_e();
        }

        public StringTextComponent getFormattedLabel() {
            return this.label;
        }

        public void func_230432_a_(MatrixStack matrixStack, int index, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            IFormattableTextComponent label = new StringTextComponent(this.label.func_150261_e()).func_240699_a_(ChangeEnumScreen.this.list.func_230958_g_() == this ? TextFormatting.YELLOW : TextFormatting.WHITE);
            AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)((ChangeEnumScreen)ChangeEnumScreen.this).field_230706_i_.field_71466_p, (ITextComponent)label, (int)(left + 5), (int)(top + 4), (int)0xFFFFFF);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            ChangeEnumScreen.this.list.func_241215_a_((AbstractList.AbstractListEntry)this);
            ChangeEnumScreen.this.selectedValue = this.enumValue;
            return true;
        }
    }

    public class EnumList
    extends ExtendedList<Entry>
    implements IBackgroundTexture {
        public EnumList(List<Entry> entries) {
            super(ChangeEnumScreen.this.field_230706_i_, ChangeEnumScreen.this.field_230708_k_, ChangeEnumScreen.this.field_230709_l_, 50, ChangeEnumScreen.this.field_230709_l_ - 36, 20);
            entries.forEach(arg_0 -> ((EnumList)this).func_230513_b_(arg_0));
        }

        public void func_230942_a_(Collection<Entry> entries) {
            super.func_230942_a_(entries);
        }

        @Override
        public ResourceLocation getBackgroundTexture() {
            return ChangeEnumScreen.this.background;
        }
    }
}

