/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured;

import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    static final ForgeConfigSpec testSpec;
    public static final Test TEST;

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        Pair testSpecPair = new ForgeConfigSpec.Builder().configure(Test::new);
        testSpec = (ForgeConfigSpec)testSpecPair.getRight();
        TEST = (Test)testSpecPair.getLeft();
    }

    public static class Test {
        public final ForgeConfigSpec.ConfigValue<String> stringValue;
        public final ForgeConfigSpec.BooleanValue booleanValue;
        public final ForgeConfigSpec.IntValue intValue;
        public final ForgeConfigSpec.DoubleValue doubleValue;
        public final ForgeConfigSpec.LongValue longValue;
        public final ForgeConfigSpec.EnumValue<TextFormatting> enumValue;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> stringList;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> listOfItems;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> intList;
        public final ForgeConfigSpec.ConfigValue<List<? extends Long>> longList;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> doubleList;

        public Test(ForgeConfigSpec.Builder builder) {
            this.stringValue = builder.comment("This is an String value").define("stringValue", (Object)"YEP");
            this.booleanValue = builder.comment("This is a Boolean value").define("booleanValue", false);
            builder.comment("YEP").push("more_properties");
            this.intValue = builder.comment("This is an Integer value").defineInRange("int_Value", 0, 0, 10);
            this.doubleValue = builder.comment("This is a Double value").defineInRange("doubleValue", 0.0, 0.0, 10.0);
            this.longValue = builder.comment("This is a Long value").defineInRange("longValue", 0L, 0L, 10L);
            this.enumValue = builder.comment("This is an Enum value").defineEnum("enumValue", (Enum)TextFormatting.BLACK);
            builder.pop();
            builder.push("lists");
            this.intList = builder.comment("This is an Integer list").defineList("intList", Arrays.asList(5, 10), o -> o instanceof Integer);
            this.longList = builder.comment("This is an Long list").defineList("longList", Arrays.asList(5L, 10L), o -> o instanceof Long);
            this.doubleList = builder.comment("This is an Double list").defineList("doubleList", Arrays.asList(0.5, 1.0), o -> o instanceof Double);
            this.stringList = builder.comment("This is a String list").defineList("stringList", Arrays.asList("test", "yo"), o -> o instanceof String);
            this.listOfItems = builder.comment("This is a List of Item Locations").defineList("listOfItems", Arrays.asList("minecraft:apple", "minecraft:iron_ingot"), o -> o instanceof String && ResourceLocation.func_217855_b((String)o.toString()) && !new ResourceLocation(o.toString()).func_110623_a().isEmpty());
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue forceConfiguredMenu;

        public Client(ForgeConfigSpec.Builder builder) {
            this.forceConfiguredMenu = builder.comment("Forces all config menus to be overridden and generated by Configured. This requires the game to be restarted for the changes to apply.").translation("configured.config.client.force_configured_menu").define("forceConfiguredMenu", false);
        }
    }
}

