/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.biome.BiomeMetadata;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.world.BOPLayerUtil;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.ICastleTransformer;

public enum BOPShoreLayer implements ICastleTransformer
{
    INSTANCE;

    private static final int BEACH;
    private static final int SNOWY_BEACH;
    private static final int DESERT;
    private static final int MOUNTAINS;
    private static final int WOODED_MOUNTAINS;
    private static final int FOREST;
    private static final int JUNGLE;
    private static final int JUNGLE_EDGE;
    private static final int JUNGLE_HILLS;
    private static final int BADLANDS;
    private static final int WOODED_BADLANDS_PLATEAU;
    private static final int BADLANDS_PLATEAU;
    private static final int ERODED_BADLANDS;
    private static final int MODIFIED_WOODED_BADLANDS_PLATEAU;
    private static final int MODIFIED_BADLANDS_PLATEAU;
    private static final int MUSHROOM_FIELDS;
    private static final int MUSHROOM_FIELD_SHORE;
    private static final int RIVER;
    private static final int MOUNTAIN_EDGE;
    private static final int STONE_SHORE;
    private static final int SWAMP;
    private static final int TAIGA;

    public int func_202748_a(INoiseRandom context, int northBiomeId, int eastBiomeId, int southBiomeId, int westBiomeId, int biomeId) {
        Biome biome = BiomeUtil.getBiome(biomeId);
        RegistryKey<Biome> key = BiomeUtil.createKey(biome);
        if (biomeId == MUSHROOM_FIELDS) {
            if (BOPLayerUtil.isShallowOcean(northBiomeId) || BOPLayerUtil.isShallowOcean(eastBiomeId) || BOPLayerUtil.isShallowOcean(southBiomeId) || BOPLayerUtil.isShallowOcean(westBiomeId)) {
                return MUSHROOM_FIELD_SHORE;
            }
        } else if (biome != null && biome.func_201856_r() == Biome.Category.JUNGLE && biomeId != BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.rainforest, biomeId) && biomeId != BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.rainforest_floodplain, biomeId) && biomeId != BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.rainforest_cliffs, biomeId) && biomeId != BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.fungal_jungle, biomeId) && biomeId != BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.fungal_field, biomeId)) {
            if (!(BOPShoreLayer.isJungleCompatible(northBiomeId) && BOPShoreLayer.isJungleCompatible(eastBiomeId) && BOPShoreLayer.isJungleCompatible(southBiomeId) && BOPShoreLayer.isJungleCompatible(westBiomeId))) {
                return JUNGLE_EDGE;
            }
        } else if (biomeId != MOUNTAINS && biomeId != WOODED_MOUNTAINS && biomeId != MOUNTAIN_EDGE) {
            if (biome != null && biome.func_201851_b() == Biome.RainType.SNOW) {
                if (!BOPLayerUtil.isOcean(biomeId) && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
                    BiomeMetadata meta;
                    if (BiomeUtil.hasMetadata(biome) && (meta = BiomeUtil.getMetadata(biome)).getBeachBiome() == null) {
                        return biomeId;
                    }
                    return SNOWY_BEACH;
                }
            } else if (biomeId != BADLANDS && biomeId != WOODED_BADLANDS_PLATEAU) {
                if (!BOPLayerUtil.isOcean(biomeId) && biomeId != RIVER && biomeId != SWAMP && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
                    if (BiomeUtil.hasMetadata(biome)) {
                        BiomeMetadata meta = BiomeUtil.getMetadata(biome);
                        return BOPShoreLayer.getBiomeIdIfPresent(meta.getBeachBiome(), biomeId);
                    }
                    if (key == Biomes.field_76768_g || key == Biomes.field_150590_f || key == Biomes.field_76784_u || key == Biomes.field_150578_U || key == Biomes.field_185432_ad || key == Biomes.field_150581_V || key == Biomes.field_185433_ae || key == Biomes.field_150582_Q || key == Biomes.field_150583_P || key == Biomes.field_185429_aa || key == Biomes.field_185448_Z || key == Biomes.field_185430_ab || key == Biomes.field_150585_R) {
                        return BOPShoreLayer.getBiomeIdIfPresent(BOPBiomes.gravel_beach, biomeId);
                    }
                    return BEACH;
                }
            } else if (!(BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId) || BOPShoreLayer.isMesa(northBiomeId) && BOPShoreLayer.isMesa(eastBiomeId) && BOPShoreLayer.isMesa(southBiomeId) && BOPShoreLayer.isMesa(westBiomeId))) {
                return DESERT;
            }
        } else if (!BOPLayerUtil.isOcean(biomeId) && (BOPLayerUtil.isOcean(northBiomeId) || BOPLayerUtil.isOcean(eastBiomeId) || BOPLayerUtil.isOcean(southBiomeId) || BOPLayerUtil.isOcean(westBiomeId))) {
            return STONE_SHORE;
        }
        return biomeId;
    }

    private static int getBiomeIdIfPresent(RegistryKey<Biome> biome, int fallbackId) {
        return biome != null && BiomeUtil.exists(biome) ? BiomeUtil.getBiomeId(biome) : fallbackId;
    }

    private static boolean isJungleCompatible(int biomeId) {
        Biome biome = BiomeUtil.getBiome(biomeId);
        if (biome != null && biome.func_201856_r() == Biome.Category.JUNGLE) {
            return true;
        }
        return biomeId == JUNGLE_EDGE || biomeId == JUNGLE || biomeId == JUNGLE_HILLS || biomeId == FOREST || biomeId == TAIGA || BOPLayerUtil.isOcean(biomeId);
    }

    private static boolean isMesa(int biomeId) {
        return biomeId == BADLANDS || biomeId == WOODED_BADLANDS_PLATEAU || biomeId == BADLANDS_PLATEAU || biomeId == ERODED_BADLANDS || biomeId == MODIFIED_WOODED_BADLANDS_PLATEAU || biomeId == MODIFIED_BADLANDS_PLATEAU;
    }

    static {
        BEACH = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76787_r);
        SNOWY_BEACH = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150577_O);
        DESERT = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76769_d);
        MOUNTAINS = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76770_e);
        WOODED_MOUNTAINS = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150580_W);
        FOREST = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76767_f);
        JUNGLE = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76782_w);
        JUNGLE_EDGE = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150574_L);
        JUNGLE_HILLS = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76792_x);
        BADLANDS = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150589_Z);
        WOODED_BADLANDS_PLATEAU = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150607_aa);
        BADLANDS_PLATEAU = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150608_ab);
        ERODED_BADLANDS = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_185437_ai);
        MODIFIED_WOODED_BADLANDS_PLATEAU = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_185438_aj);
        MODIFIED_BADLANDS_PLATEAU = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_185439_ak);
        MUSHROOM_FIELDS = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76789_p);
        MUSHROOM_FIELD_SHORE = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76788_q);
        RIVER = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76781_i);
        MOUNTAIN_EDGE = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76783_v);
        STONE_SHORE = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_150576_N);
        SWAMP = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76780_h);
        TAIGA = BiomeUtil.getBiomeId((RegistryKey<Biome>)Biomes.field_76768_g);
    }
}

