/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.mixin;

import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.common.morph.MorphHandler;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin {
    @Inject(method={"getHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getHurtSound(DamageSource source, CallbackInfoReturnable<SoundEvent> cir) {
        MorphInfo info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)this);
        if (info.isMorphed()) {
            cir.setReturnValue((Object)info.getHurtSound(source));
        }
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        MorphInfo info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)this);
        if (info.isMorphed()) {
            cir.setReturnValue((Object)info.getDeathSound());
        }
    }

    @Inject(method={"getFallSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFallSound(int height, CallbackInfoReturnable<SoundEvent> cir) {
        MorphInfo info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)this);
        if (info.isMorphed()) {
            cir.setReturnValue((Object)info.getFallSound(height));
        }
    }

    @Inject(method={"getSize"}, at={@At(value="HEAD")}, cancellable=true)
    private void getSize(Pose pose, CallbackInfoReturnable<EntitySize> cir) {
        MorphInfo info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)this);
        if (info.isMorphed()) {
            cir.setReturnValue((Object)info.getActiveMorphSizeByPose(pose));
        }
    }
}

