/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.client.render.hand.HandHandler;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.mob.MobDataHandler;
import me.ichun.mods.morph.common.mob.TraitHandler;
import me.ichun.mods.morph.common.morph.nbt.NbtHandler;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class ResourceHandler {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Trait.class, (Object)new TraitHandler.TraitDeserialiser()).setPrettyPrinting().disableHtmlEscaping().create();
    public static final Gson GSON_MINIFY = new GsonBuilder().disableHtmlEscaping().create();
    public static final int MOB_SUPPORT_VERSION = 2;
    private static Path morphDir;
    private static boolean init;

    public static synchronized boolean setupEnv() {
        if (!init) {
            init = true;
            try {
                Path extractedMarker;
                morphDir = FMLPaths.CONFIGDIR.get().resolve("morph");
                if (!Files.exists(morphDir, new LinkOption[0])) {
                    Files.createDirectory(morphDir, new FileAttribute[0]);
                }
                if (!Files.exists(extractedMarker = morphDir.resolve("2.extracted"), new LinkOption[0])) {
                    ResourceHandler.extractFiles(extractedMarker);
                }
            }
            catch (IOException e) {
                Morph.LOGGER.fatal("Error initialising Morph resources!", (Throwable)e);
                return false;
            }
        }
        return init;
    }

    public static synchronized void extractFiles(Path extractedMarker) throws IOException {
        InputStream in = Morph.class.getResourceAsStream("/mobsupport.zip");
        if (in != null) {
            Morph.LOGGER.info("Extracted {} Morph-related files.", (Object)IOUtil.extractFiles((Path)morphDir, (InputStream)in, (boolean)true));
        } else {
            Morph.LOGGER.error("Error loading mobsupport.zip. InputStream was null.");
        }
        FileUtils.writeStringToFile((File)extractedMarker.toFile(), (String)"", (Charset)StandardCharsets.UTF_8);
    }

    public static synchronized void loadResources() {
        NbtHandler.loadNbtModifiers();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> HandHandler::loadHandInfos);
        MobDataHandler.loadMobData();
    }

    public static Path getMorphDir() {
        return morphDir;
    }

    public static void reloadAllResources() {
        ResourceHandler.loadResources();
    }
}

