/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.packet;

import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.morph.api.morph.MorphVariant;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.morph.MorphHandler;
import me.ichun.mods.morph.common.morph.save.PlayerMorphData;
import me.ichun.mods.morph.common.packet.PacketUpdateMorph;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketMorphInput
extends AbstractPacket {
    public String identifier;
    public boolean inputFavourite;
    public boolean isFavourite;
    public boolean isDelete;

    public PacketMorphInput() {
    }

    public PacketMorphInput(String identifier, boolean inputFavourite, boolean isFavourite, boolean isDelete) {
        this.identifier = identifier;
        this.inputFavourite = inputFavourite;
        this.isFavourite = isFavourite;
        this.isDelete = isDelete;
    }

    public void writeTo(PacketBuffer buf) {
        buf.func_180714_a(this.identifier);
        buf.writeBoolean(this.inputFavourite);
        buf.writeBoolean(this.isFavourite);
        buf.writeBoolean(this.isDelete);
    }

    public void readFrom(PacketBuffer buf) {
        this.identifier = this.readString(buf);
        this.inputFavourite = buf.readBoolean();
        this.isFavourite = buf.readBoolean();
        this.isDelete = buf.readBoolean();
    }

    public void process(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            PlayerMorphData morphData = MorphHandler.INSTANCE.getPlayerMorphData((PlayerEntity)context.getSender());
            for (MorphVariant morph : morphData.morphs) {
                MorphVariant.Variant variant = morph.getVariantById(this.identifier);
                if (variant == null) continue;
                if (this.inputFavourite) {
                    variant.isFavourite = this.isFavourite;
                    MorphHandler.INSTANCE.getSaveData().func_76185_a();
                } else if (this.isDelete) {
                    if (MorphHandler.INSTANCE.getMorphModeName().equals("classic") && morph.removeVariant(variant)) {
                        MorphHandler.INSTANCE.getSaveData().func_76185_a();
                        Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorph(morph.write(new CompoundNBT())), context.getSender());
                    }
                } else if (MorphHandler.INSTANCE.canMorph((PlayerEntity)context.getSender())) {
                    MorphHandler.INSTANCE.morphTo(context.getSender(), morph.getAsVariant(variant));
                }
                return;
            }
        });
    }
}

