/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.morph.save;

import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import me.ichun.mods.morph.api.biomass.BiomassUpgrade;
import me.ichun.mods.morph.api.morph.MorphVariant;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class PlayerMorphData {
    public UUID owner;
    public ArrayList<MorphVariant> morphs;
    public double biomass;
    public ArrayList<BiomassUpgrade> upgrades;

    public PlayerMorphData() {
        this.morphs = new ArrayList();
        this.upgrades = new ArrayList();
    }

    public PlayerMorphData(UUID owner) {
        String[] defaultUpgrades;
        this.owner = owner;
        this.morphs = new ArrayList();
        MorphVariant variant = MorphVariant.createPlayerMorph(owner, false);
        variant.variants.get((int)0).identifier = "default_player_state";
        this.morphs.add(variant);
        this.upgrades = new ArrayList();
        for (String id : defaultUpgrades = new String[]{"biomass_capacity", "biomass_efficiency", "biomass_reach"}) {
            BiomassUpgrade upgrade = new BiomassUpgrade(null, id);
            upgrade.setLevel(1);
            this.upgrades.add(upgrade);
        }
    }

    public boolean containsVariant(MorphVariant variant) {
        for (MorphVariant morph : this.morphs) {
            if (!morph.id.equals((Object)variant.id)) continue;
            return morph.containsVariant(variant);
        }
        return false;
    }

    public MorphVariant addVariant(MorphVariant variant) {
        for (MorphVariant morph : this.morphs) {
            if (!morph.combineVariants(variant)) continue;
            return morph;
        }
        MorphVariant varClone = MorphVariant.createFromNBT(variant.write(new CompoundNBT()));
        varClone.variants.add(variant.thisVariant);
        varClone.thisVariant = null;
        this.morphs.add(varClone);
        return varClone;
    }

    @Nullable
    public BiomassUpgrade getBiomassUpgrade(String id) {
        for (BiomassUpgrade upgrade : this.upgrades) {
            if (!upgrade.getId().equals(id)) continue;
            return upgrade;
        }
        return null;
    }

    public double getBiomassUpgradeValue(String id) {
        BiomassUpgrade biomassUpgrade = this.getBiomassUpgrade(id);
        if (biomassUpgrade != null) {
            return biomassUpgrade.getValue();
        }
        return 0.0;
    }

    public CompoundNBT write(CompoundNBT tag) {
        int i;
        tag.func_186854_a("owner", this.owner);
        tag.func_74768_a("morphCount", this.morphs.size());
        for (i = 0; i < this.morphs.size(); ++i) {
            tag.func_218657_a("morph_" + i, (INBT)this.morphs.get(i).write(new CompoundNBT()));
        }
        tag.func_74780_a("biomass", this.biomass);
        tag.func_74768_a("upgradeCount", this.upgrades.size());
        for (i = 0; i < this.upgrades.size(); ++i) {
            tag.func_218657_a("upgrade_" + i, (INBT)this.upgrades.get(i).write(new CompoundNBT()));
        }
        return tag;
    }

    public void read(CompoundNBT tag) {
        int i;
        this.owner = tag.func_186857_a("owner");
        this.morphs.clear();
        int count = tag.func_74762_e("morphCount");
        for (i = 0; i < count; ++i) {
            this.morphs.add(MorphVariant.createFromNBT(tag.func_74775_l("morph_" + i)));
        }
        this.biomass = tag.func_74769_h("biomass");
        this.upgrades.clear();
        count = tag.func_74762_e("upgradeCount");
        for (i = 0; i < count; ++i) {
            this.upgrades.add(BiomassUpgrade.createFromNBT(tag.func_74775_l("upgrade_" + i)));
        }
    }
}

