/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.morph.nbt;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import me.ichun.mods.morph.api.event.MorphLoadResourceEvent;
import me.ichun.mods.morph.api.mob.nbt.NbtModifier;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.resource.ResourceHandler;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.io.FileUtils;

public class NbtHandler {
    public static final HashMap<Class<? extends LivingEntity>, NbtModifier> NBT_MODIFIERS = new HashMap();
    public static final HashMap<Class<?>, NbtModifier> NBT_MODIFIERS_INTERFACES = new HashMap();

    public static void loadNbtModifiers() {
        NBT_MODIFIERS.clear();
        NBT_MODIFIERS_INTERFACES.clear();
        try {
            IOUtil.scourDirectoryForFiles((Path)ResourceHandler.getMorphDir().resolve("nbt"), p -> {
                if (p.getFileName().toString().endsWith(".json")) {
                    File file = p.toFile();
                    try {
                        String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                        if (NbtHandler.readNbtJson(json)) {
                            return true;
                        }
                        Morph.LOGGER.error("Error reading NBT Modifier file, no forClass: {}", (Object)file);
                        return false;
                    }
                    catch (JsonSyntaxException | IOException | IllegalStateException e) {
                        Morph.LOGGER.error("Error reading NBT Modifier file: {}", (Object)file);
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return false;
            });
        }
        catch (IOException e) {
            Morph.LOGGER.error("Error loading NBT Modifier files.", (Throwable)e);
        }
        Morph.LOGGER.info("Loaded {} NBT Modifier(s)", (Object)(NBT_MODIFIERS.size() + NBT_MODIFIERS_INTERFACES.size()));
        NbtHandler.setupInterfaceModifiers();
        MinecraftForge.EVENT_BUS.post((Event)new MorphLoadResourceEvent(MorphLoadResourceEvent.Type.NBT));
    }

    private static boolean readNbtJson(String json) throws ClassNotFoundException, JsonSyntaxException, IllegalStateException {
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(json).getAsJsonObject();
        if (jsonObject.has("forClass")) {
            boolean forInterface;
            String className = jsonObject.get("forClass").getAsString();
            Class<?> clz = Class.forName(className);
            boolean bl = forInterface = jsonObject.has("isInterface") && jsonObject.get("isInterface").getAsBoolean();
            if (!forInterface && NBT_MODIFIERS.containsKey(clz) || forInterface && NBT_MODIFIERS_INTERFACES.containsKey(clz)) {
                Morph.LOGGER.warn("We already have another NBT Modifier for {}", (Object)clz.getName());
            }
            try {
                NbtModifier nbtModifier = (NbtModifier)ResourceHandler.GSON.fromJson(json, NbtModifier.class);
                if (forInterface) {
                    NBT_MODIFIERS_INTERFACES.put(clz, nbtModifier);
                } else {
                    NBT_MODIFIERS.put(clz, nbtModifier);
                }
            }
            catch (Throwable t) {
                Morph.LOGGER.error("Error deserialising NBT Modifier for {}", (Object)clz.getName());
                t.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private static void serialiseModifiers() {
        String[] strip;
        Path file = ResourceHandler.getMorphDir().resolve("nbt").resolve("LivingEntity.json");
        NbtModifier modifier = new NbtModifier();
        modifier.forClass = LivingEntity.class.getName();
        for (String s : strip = new String[]{"Health", "HurtTime", "HurtByTimestamp", "DeathTime", "AbsorptionAmount", "FallFlying", "SleepingX", "SleepingY", "SleepingZ", "Brain"}) {
            NbtModifier.Modifier mod = new NbtModifier.Modifier();
            mod.key = s;
            mod.keep = true;
            modifier.modifiers.add(mod);
        }
        NbtModifier.Modifier hatsMod = new NbtModifier.Modifier();
        hatsMod.key = "ForgeCaps";
        NbtModifier.Modifier partMod = new NbtModifier.Modifier();
        partMod.key = "hats:capability_hat";
        partMod.keep = true;
        hatsMod.nestedModifiers = new ArrayList();
        hatsMod.nestedModifiers.add(partMod);
        ArrayList<NbtModifier.Modifier> list = new ArrayList<NbtModifier.Modifier>();
        list.add(hatsMod);
        modifier.modSpecificModifiers.put("hats", list);
        try {
            String json = ResourceHandler.GSON.toJson((Object)modifier);
            FileUtils.writeStringToFile((File)file.toFile(), (String)json, (String)"UTF-8");
        }
        catch (IOException json) {
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
    }

    public static NbtModifier getModifierFor(LivingEntity living) {
        NbtModifier modifier = NbtHandler.getModifierFor(living.getClass());
        modifier.setupValues();
        return modifier;
    }

    public static NbtModifier getModifierFor(Class clz) {
        NbtModifier modifier;
        if (NBT_MODIFIERS.containsKey(clz)) {
            modifier = NBT_MODIFIERS.get(clz);
            if (modifier.toKeep != null) {
                return modifier;
            }
        } else {
            modifier = new NbtModifier();
            NBT_MODIFIERS.put(clz, modifier);
        }
        modifier.toKeep = new HashSet();
        modifier.keyToModifier = new HashMap();
        if (clz != LivingEntity.class) {
            NbtModifier parentModifier = NbtHandler.getModifierFor(clz.getSuperclass());
            modifier.toKeep.addAll(parentModifier.toKeep);
            modifier.keyToModifier.putAll(parentModifier.keyToModifier);
        }
        for (Map.Entry<Class<?>, NbtModifier> e : NBT_MODIFIERS_INTERFACES.entrySet()) {
            if (!e.getKey().isAssignableFrom(clz)) continue;
            modifier.toKeep.addAll(e.getValue().toKeep);
            modifier.keyToModifier.putAll(e.getValue().keyToModifier);
        }
        modifier.setup();
        return modifier;
    }

    private static void setupInterfaceModifiers() {
        for (Map.Entry<Class<?>, NbtModifier> e : NBT_MODIFIERS_INTERFACES.entrySet()) {
            e.getValue().toKeep = new HashSet();
            e.getValue().keyToModifier = new HashMap();
            e.getValue().setup();
        }
    }

    public static void removeEmptyCompoundTags(CompoundNBT tag) {
        tag.field_74784_a.entrySet().removeIf(e -> e.getValue() instanceof CompoundNBT && ((CompoundNBT)e.getValue()).field_74784_a.isEmpty());
        tag.field_74784_a.entrySet().stream().filter(e -> e.getValue() instanceof CompoundNBT).forEach(e -> NbtHandler.removeEmptyCompoundTags((CompoundNBT)e.getValue()));
    }
}

