/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.morph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.client.entity.EntityBiomassAbility;
import me.ichun.mods.morph.client.render.MorphRenderHandler;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.packet.PacketInvalidateClientHealth;
import me.ichun.mods.morph.mixin.EntityInvokerMixin;
import me.ichun.mods.morph.mixin.LivingEntityInvokerMixin;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class MorphInfoImpl
extends MorphInfo {
    private final Random rand = new Random();
    @OnlyIn(value=Dist.CLIENT)
    public MorphRenderHandler.MorphTransitionState transitionState;
    @OnlyIn(value=Dist.CLIENT)
    public EntityBiomassAbility entityBiomassAbility;

    public MorphInfoImpl(PlayerEntity player) {
        super(player);
    }

    @Override
    public void tick() {
        if (!this.isMorphed()) {
            return;
        }
        float transitionProgress = this.getTransitionProgressLinear(1.0f);
        if (this.firstTick) {
            this.firstTick = false;
            this.player.func_213323_x_();
            this.applyAttributeModifiers(transitionProgress);
        }
        if (transitionProgress < 1.0f) {
            if (!this.player.field_70170_p.field_72995_K) {
                if (this.playSoundTime < 0) {
                    this.playSoundTime = Math.max(0, (int)((float)(this.morphingTime - 60) / 2.0f));
                }
                if (this.morphTime == this.playSoundTime) {
                    this.player.field_70170_p.func_217384_a(null, (Entity)this.player, (SoundEvent)Morph.Sounds.MORPH.get(), this.player.func_184176_by(), 1.0f, 1.0f);
                }
            }
            this.prevState.tick(this.player, transitionProgress > 0.0f);
            this.nextState.tick(this.player, true);
            float prevStateTraitStrength = 1.0f - MathHelper.func_76131_a((float)(transitionProgress / 0.5f), (float)0.0f, (float)1.0f);
            float nextStateTraitStrength = MathHelper.func_76131_a((float)((transitionProgress - 0.5f) / 0.5f), (float)0.0f, (float)1.0f);
            ArrayList prevTraits = new ArrayList(this.prevState.traits);
            for (Trait<?> trait : this.nextState.traits) {
                boolean foundTranslatableTrait = false;
                for (int i = prevTraits.size() - 1; i >= 0; --i) {
                    Trait<?> prevTrait = prevTraits.get(i);
                    if (!prevTrait.canTransitionTo(trait)) continue;
                    prevTraits.remove(i);
                    foundTranslatableTrait = true;
                    trait.doTransitionalTick(prevTrait, transitionProgress);
                    break;
                }
                if (foundTranslatableTrait) continue;
                trait.doTick(nextStateTraitStrength);
            }
            for (Trait<?> value : prevTraits) {
                value.doTick(prevStateTraitStrength);
            }
        } else {
            this.nextState.tick(this.player, false);
            this.nextState.tickTraits();
        }
        ++this.morphTime;
        if (this.morphTime <= this.morphingTime) {
            this.player.func_213323_x_();
            this.applyAttributeModifiers(transitionProgress);
        } else if (Morph.configServer.aggressiveSizeRecalculation) {
            this.player.func_213323_x_();
        }
        if (this.morphTime == this.morphingTime) {
            this.removeAttributeModifiersFromPrevState();
            this.setPrevState(null);
            if (this.player.field_70170_p.field_72995_K) {
                this.endMorphOnClient();
            }
            if (this.nextState.variant.id.equals((Object)EntityType.field_200729_aH.getRegistryName()) && this.nextState.variant.thisVariant.identifier.equals("default_player_state")) {
                this.setNextState(null);
            }
        }
        if (this.player.field_70170_p.field_72995_K && this.entityBiomassAbility != null && this.entityBiomassAbility.field_70128_L) {
            this.entityBiomassAbility = null;
        }
    }

    public void applyAttributeModifiers(float transitionProgress) {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        HashMap<Attribute, Double> attributeModifierAmount = new HashMap<Attribute, Double>();
        for (Map.Entry e : this.nextState.variant.nbtMorph.field_74784_a.entrySet()) {
            ModifiableAttributeInstance playerAttribute;
            ResourceLocation id;
            Attribute attribute;
            String string = (String)e.getKey();
            if (!string.startsWith("attr_") || (attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(id = new ResourceLocation(string.substring(5)))) == null || (playerAttribute = this.player.func_110148_a(attribute)) == null) continue;
            double baseValue = this.player.func_233638_c_(attribute);
            double modifierValue = this.nextState.variant.nbtMorph.func_74769_h(string) - baseValue;
            attributeModifierAmount.put(attribute, modifierValue);
        }
        if (transitionProgress < 1.0f) {
            HashSet<Attribute> prevStateAttrs = new HashSet<Attribute>();
            for (Map.Entry entry : this.prevState.variant.nbtMorph.field_74784_a.entrySet()) {
                ModifiableAttributeInstance playerAttribute;
                ResourceLocation id;
                Attribute attribute;
                String key = (String)entry.getKey();
                if (!key.startsWith("attr_") || (attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(id = new ResourceLocation(key.substring(5)))) == null || (playerAttribute = this.player.func_110148_a(attribute)) == null) continue;
                double baseValue = this.player.func_233638_c_(attribute);
                double modifierValue = this.prevState.variant.nbtMorph.func_74769_h(key) - baseValue;
                if (attributeModifierAmount.containsKey(attribute)) {
                    double val = modifierValue + ((Double)attributeModifierAmount.get(attribute) - modifierValue) * (double)transitionProgress;
                    attributeModifierAmount.put(attribute, val);
                } else {
                    attributeModifierAmount.put(attribute, modifierValue * (double)(1.0f - transitionProgress));
                }
                prevStateAttrs.add(attribute);
            }
            for (Map.Entry entry : attributeModifierAmount.entrySet()) {
                if (prevStateAttrs.contains(entry.getKey())) continue;
                entry.setValue((Double)entry.getValue() * (double)transitionProgress);
            }
        }
        for (Map.Entry e : attributeModifierAmount.entrySet()) {
            double currentRatio;
            ModifiableAttributeInstance modifiableAttributeInstance = this.player.func_110148_a((Attribute)e.getKey());
            if (modifiableAttributeInstance == null) continue;
            this.rand.setSeed(Math.abs("MorphAttr".hashCode() * 1231543 + ((Attribute)e.getKey()).getRegistryName().toString().hashCode() * 268));
            UUID uuid = MathHelper.func_180182_a((Random)this.rand);
            double lastRatio = 0.0;
            if (!this.player.field_70170_p.field_72995_K && modifiableAttributeInstance.func_111123_a().equals(Attributes.field_233818_a_)) {
                lastRatio = this.player.func_110143_aJ() / this.player.func_110138_aP();
            }
            modifiableAttributeInstance.func_233770_c_(uuid);
            if ((Double)e.getValue() == 0.0) continue;
            modifiableAttributeInstance.func_233769_c_(new AttributeModifier(uuid, "MorphAttributeModifier:" + ((Attribute)e.getKey()).getRegistryName().toString(), ((Double)e.getValue()).doubleValue(), AttributeModifier.Operation.ADDITION));
            if (!(lastRatio > 0.0) || (currentRatio = (double)(this.player.func_110143_aJ() / this.player.func_110138_aP())) == lastRatio) continue;
            double targetHealth = lastRatio * (double)this.player.func_110138_aP();
            double extraHealth = targetHealth - (double)this.player.func_110143_aJ();
            Morph.channel.sendTo((AbstractPacket)new PacketInvalidateClientHealth(), (ServerPlayerEntity)this.player);
            this.player.func_70606_j(this.player.func_110143_aJ() + (float)extraHealth);
        }
    }

    public void removeAttributeModifiersFromPrevState() {
        if (this.prevState != null) {
            ResourceLocation id;
            Attribute attribute;
            String key;
            HashSet<Attribute> attributesToRemove = new HashSet<Attribute>();
            for (Map.Entry e : this.prevState.variant.nbtMorph.field_74784_a.entrySet()) {
                key = (String)e.getKey();
                if (!key.startsWith("attr_") || (attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(id = new ResourceLocation(key.substring(5)))) == null) continue;
                attributesToRemove.add(attribute);
            }
            for (Map.Entry e : this.nextState.variant.nbtMorph.field_74784_a.entrySet()) {
                key = (String)e.getKey();
                if (!key.startsWith("attr_") || (attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(id = new ResourceLocation(key.substring(5)))) == null) continue;
                attributesToRemove.remove(attribute);
            }
            for (Attribute attribute2 : attributesToRemove) {
                ModifiableAttributeInstance playerAttribute = this.player.func_110148_a(attribute2);
                if (playerAttribute == null) continue;
                this.rand.setSeed(Math.abs("MorphAttr".hashCode() * 1231543 + attribute2.getRegistryName().toString().hashCode() * 268));
                UUID uuid = MathHelper.func_180182_a((Random)this.rand);
                playerAttribute.func_233770_c_(uuid);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void endMorphOnClient() {
        if (this.transitionState != null) {
            this.transitionState = null;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected float getAbilitySkinAlpha(float partialTick) {
        if (this.entityBiomassAbility != null) {
            float alpha = this.entityBiomassAbility.age < this.entityBiomassAbility.fadeTime ? EntityHelper.sineifyProgress((float)MathHelper.func_76131_a((float)(((float)this.entityBiomassAbility.age + partialTick) / (float)this.entityBiomassAbility.fadeTime), (float)0.0f, (float)1.0f)) : (this.entityBiomassAbility.age >= this.entityBiomassAbility.fadeTime + this.entityBiomassAbility.solidTime ? EntityHelper.sineifyProgress((float)(1.0f - MathHelper.func_76131_a((float)(((float)(this.entityBiomassAbility.age - (this.entityBiomassAbility.fadeTime + this.entityBiomassAbility.solidTime)) + partialTick) / (float)this.entityBiomassAbility.fadeTime), (float)0.0f, (float)1.0f))) : 1.0f);
            return alpha;
        }
        return 0.0f;
    }

    @Override
    public void playStepSound(BlockPos pos, BlockState blockState) {
        ((EntityInvokerMixin)this.getActiveMorphEntityOrPlayer()).callPlayStepSound(pos, blockState);
    }

    @Override
    public void playSwimSound(float volume) {
        ((EntityInvokerMixin)this.getActiveMorphEntityOrPlayer()).callPlaySwimSound(volume);
    }

    @Override
    public float playFlySound(float volume) {
        return ((EntityInvokerMixin)this.getActiveMorphEntityOrPlayer()).callPlayFlySound(volume);
    }

    @Override
    @Nullable
    public SoundEvent getHurtSound(DamageSource source) {
        return ((LivingEntityInvokerMixin)this.getActiveMorphEntityOrPlayer()).callGetHurtSound(source);
    }

    @Override
    @Nullable
    public SoundEvent getDeathSound() {
        return ((LivingEntityInvokerMixin)this.getActiveMorphEntityOrPlayer()).callGetDeathSound();
    }

    @Override
    public SoundEvent getFallSound(int height) {
        return ((LivingEntityInvokerMixin)this.getActiveMorphEntityOrPlayer()).callGetFallSound(height);
    }

    @Override
    public SoundEvent getDrinkSound(ItemStack stack) {
        return ((LivingEntityInvokerMixin)this.getActiveMorphEntityOrPlayer()).callGetDrinkSound(stack);
    }

    @Override
    public SoundEvent getEatSound(ItemStack stack) {
        return this.getActiveMorphEntityOrPlayer().func_213353_d(stack);
    }

    @Override
    public float getSoundVolume() {
        if (this.nextState != null) {
            if (this.prevState != null) {
                float transitionProg = this.getTransitionProgressLinear(1.0f);
                float prevVolume = ((LivingEntityInvokerMixin)this.prevState.getEntityInstance(this.player.field_70170_p, this.player)).callGetSoundVolume();
                float nextVolume = ((LivingEntityInvokerMixin)this.nextState.getEntityInstance(this.player.field_70170_p, this.player)).callGetSoundVolume();
                return prevVolume + (nextVolume - prevVolume) * transitionProg;
            }
            return ((LivingEntityInvokerMixin)this.nextState.getEntityInstance(this.player.field_70170_p, this.player)).callGetSoundVolume();
        }
        return 1.0f;
    }

    @Override
    public float getSoundPitch() {
        if (this.nextState != null) {
            if (this.prevState != null) {
                float transitionProg = this.getTransitionProgressLinear(1.0f);
                float prevPitch = ((LivingEntityInvokerMixin)this.prevState.getEntityInstance(this.player.field_70170_p, this.player)).callGetSoundPitch();
                float nextPitch = ((LivingEntityInvokerMixin)this.nextState.getEntityInstance(this.player.field_70170_p, this.player)).callGetSoundPitch();
                return prevPitch + (nextPitch - prevPitch) * transitionProg;
            }
            return ((LivingEntityInvokerMixin)this.nextState.getEntityInstance(this.player.field_70170_p, this.player)).callGetSoundPitch();
        }
        return 1.0f;
    }
}

