/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.morph;

import com.google.common.base.Splitter;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.morph.api.IApi;
import me.ichun.mods.morph.api.biomass.BiomassUpgrade;
import me.ichun.mods.morph.api.biomass.BiomassUpgradeInfo;
import me.ichun.mods.morph.api.event.MorphEvent;
import me.ichun.mods.morph.api.mob.MobData;
import me.ichun.mods.morph.api.mob.nbt.NbtModifier;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.api.mob.trait.ability.Ability;
import me.ichun.mods.morph.api.morph.AttributeConfig;
import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.api.morph.MorphState;
import me.ichun.mods.morph.api.morph.MorphVariant;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.biomass.BiomassUpgradeHandler;
import me.ichun.mods.morph.common.mob.MobDataHandler;
import me.ichun.mods.morph.common.mob.TraitHandler;
import me.ichun.mods.morph.common.mode.MorphMode;
import me.ichun.mods.morph.common.mode.MorphModeType;
import me.ichun.mods.morph.common.morph.MorphInfoImpl;
import me.ichun.mods.morph.common.morph.nbt.NbtHandler;
import me.ichun.mods.morph.common.morph.save.MorphSavedData;
import me.ichun.mods.morph.common.morph.save.PlayerMorphData;
import me.ichun.mods.morph.common.packet.PacketAcquisition;
import me.ichun.mods.morph.common.packet.PacketMorphInfo;
import me.ichun.mods.morph.common.packet.PacketUpdateBiomassValue;
import me.ichun.mods.morph.common.packet.PacketUpdateMorph;
import me.ichun.mods.morph.mixin.AbstractHorseEntityInvokerMixin;
import me.ichun.mods.morph.mixin.LlamaEntityInvokerMixin;
import net.minecraft.block.Block;
import net.minecraft.block.CarpetBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;

public final class MorphHandler
implements IApi {
    public static final Splitter ON_SEMI_COLON = Splitter.on((String)";").trimResults().omitEmptyStrings();
    private static final ResourceLocation TEX_MORPH_SKIN = new ResourceLocation("morph", "textures/skin/morphskin.png");
    private static final ArrayList<BiConsumer<LivingEntity, CompoundNBT>> VARIANT_SPECIAL_TAG_SETTERS = (ArrayList)Util.func_200696_a(new ArrayList(), list -> {
        list.add((living, tag) -> {
            if (living instanceof AgeableEntity) {
                tag.func_74768_a("Age", living.func_70631_g_() ? -24000 : 0);
            }
        });
        list.add((living, tag) -> {
            if (living instanceof PandaEntity) {
                PandaEntity panda = (PandaEntity)living;
                if (!panda.func_213549_ef().func_221107_c()) {
                    tag.func_74778_a("HiddenGene", "normal");
                } else if (panda.func_213549_ef() != panda.func_213536_eg()) {
                    tag.func_74778_a("MainGene", "normal");
                    tag.func_74778_a("HiddenGene", "normal");
                }
            }
        });
        list.add((living, tag) -> {
            if (living instanceof WitherEntity) {
                int i = ((WitherEntity)living).func_82212_n();
                tag.func_74768_a("Invul", i > 0 && (i > 80 || i / 5 % 2 != 1) ? 100000000 : 0);
            }
        });
        list.add((living, tag) -> {
            if (living instanceof IAngerable) {
                tag.func_74768_a("AngerTime", ((IAngerable)living).func_233678_J__() ? 100000000 : 0);
            }
        });
    });
    private static final ArrayList<BiConsumer<LivingEntity, CompoundNBT>> VARIANT_SPECIAL_TAG_READERS = (ArrayList)Util.func_200696_a(new ArrayList(), list -> {
        list.add((living, tag) -> {
            if (living.field_70170_p.field_72995_K && living instanceof EnderDragonEntity) {
                ((EnderDragonEntity)living).func_94061_f(false);
                ((EnderDragonEntity)living).func_184670_cT().func_188758_a(PhaseType.field_188741_a);
            }
        });
        list.add((living, tag) -> {
            if (living instanceof IAngerable) {
                ((IAngerable)living).func_230260_a__(tag.func_74762_e("AngerTime"));
            }
        });
        list.add((living, tag) -> {
            if (living instanceof LlamaEntity) {
                ((AbstractHorseEntityInvokerMixin)living).callSetHorseWatchableBoolean(4, !((AbstractHorseEntityInvokerMixin)living).getHorseChest().func_70301_a(0).func_190926_b());
                Block block = Block.func_149634_a((Item)((AbstractHorseEntityInvokerMixin)living).getHorseChest().func_70301_a(1).func_77973_b());
                ((LlamaEntityInvokerMixin)living).callSetColor(block instanceof CarpetBlock ? ((CarpetBlock)block).func_196547_d() : null);
            }
        });
    });
    private static final ArrayList<BiConsumer<LivingEntity, PlayerEntity>> PLAYER_MORPH_SYNC_FUNCTIONS = (ArrayList)Util.func_200696_a(new ArrayList(), list -> {
        list.add((living, player) -> {
            if (Morph.configServer.silentMorphs) {
                living.func_174810_b(true);
            }
        });
        list.add((living, player) -> {
            if (living instanceof AgeableEntity) {
                ((AgeableEntity)living).func_70873_a(living.func_70631_g_() ? -24000 : 0);
            }
        });
        list.add((living, player) -> {
            if (living instanceof EnderDragonEntity) {
                ((EnderDragonEntity)living).field_70995_bG = player.field_70725_aQ * 10;
            }
        });
        list.add((living, player) -> {
            if (living instanceof MobEntity) {
                MobEntity mob = (MobEntity)living;
                mob.func_184641_n(player.func_184591_cq() == HandSide.LEFT);
                mob.func_213395_q(player.func_184587_cr());
            }
        });
        list.add((living, player) -> {
            if (living instanceof PlayerEntity) {
                PlayerEntity playerEntity = (PlayerEntity)living;
                playerEntity.func_184819_a(player.func_184591_cq());
                playerEntity.func_184212_Q().func_187227_b(PlayerEntity.field_184827_bp, player.func_184212_Q().func_187225_a(PlayerEntity.field_184827_bp));
            }
        });
        list.add((living, player) -> {
            if (living instanceof IAngerable) {
                ((IAngerable)living).func_230260_a__(((IAngerable)living).func_233678_J__() ? 1000 : 0);
            }
        });
    });
    private MorphMode currentMode;
    private MorphSavedData saveData;
    public static final MorphHandler INSTANCE = new MorphHandler();

    public void handleMurderEvent(ServerPlayerEntity player, LivingEntity living) {
        this.currentMode.handleMurderEvent(player, living);
    }

    public void setMorphMode(MorphModeType type) {
        this.currentMode = type.createMode();
    }

    public void setSaveData(MorphSavedData data) {
        this.saveData = data;
    }

    public MorphSavedData getSaveData() {
        return this.saveData;
    }

    public PlayerMorphData getPlayerMorphData(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return Morph.eventHandlerClient.morphData;
        }
        return this.saveData.playerMorphs.computeIfAbsent(player.func_146103_bH().getId(), k -> new PlayerMorphData(player.func_146103_bH().getId()));
    }

    @Override
    @Nonnull
    public GameProfile getGameProfile(UUID uuid, String name) {
        GameProfile profile = EntityHelper.getGameProfile((UUID)uuid, (String)name);
        if (profile.getName() == null) {
            profile = new GameProfile(uuid, "No Profile :(");
        }
        return profile;
    }

    @Override
    public String getMorphModeName() {
        return this.currentMode != null ? this.currentMode.getModeName() : IApi.super.getMorphModeName();
    }

    @Override
    public void spawnAnimation(PlayerEntity player, LivingEntity living, boolean isMorphAcquisition) {
        Morph.channel.sendTo((AbstractPacket)new PacketAcquisition(player.func_145782_y(), living.func_145782_y(), isMorphAcquisition), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
    }

    @Override
    @Nonnull
    public MorphInfo getMorphInfo(PlayerEntity player) {
        return (MorphInfo)player.getCapability(MorphInfo.CAPABILITY_INSTANCE).orElse((Object)new MorphInfoImpl(player));
    }

    @Override
    public boolean canShowMorphSelector(PlayerEntity player) {
        return this.currentMode != null ? this.currentMode.canShowMorphSelector(player) : IApi.super.canShowMorphSelector(player);
    }

    @Override
    public boolean canMorph(PlayerEntity player) {
        return this.currentMode != null && this.currentMode.canMorph(player);
    }

    @Override
    public boolean canAcquireMorph(PlayerEntity player, LivingEntity living) {
        return this.currentMode != null ? this.currentMode.canAcquireMorph(player, living, this.createVariant(living)) : IApi.super.canAcquireMorph(player, living);
    }

    @Override
    @Nullable
    public MorphVariant createVariant(LivingEntity living) {
        Object morphInfo;
        boolean isPlayer = living instanceof PlayerEntity;
        if (isPlayer && ((MorphInfo)(morphInfo = this.getMorphInfo((PlayerEntity)living))).isMorphed()) {
            if (((MorphInfo)morphInfo).getMorphProgress(1.0f) < 1.0f) {
                return null;
            }
            living = ((MorphInfo)morphInfo).getActiveMorphEntity();
        }
        for (Pattern p : Morph.configServer.disabledMobsID) {
            Matcher m = p.matcher(living.func_200600_R().getRegistryName().toString());
            if (!m.matches()) continue;
            return null;
        }
        MobData data = MobDataHandler.getMobData(living);
        if (data != null && data.disableAcquiringMorph != null && data.disableAcquiringMorph.booleanValue()) {
            return null;
        }
        isPlayer = living instanceof PlayerEntity;
        if (!living.func_200600_R().func_200715_a() && !isPlayer) {
            return null;
        }
        MorphVariant variant = new MorphVariant(living.func_200600_R().getRegistryName());
        if (isPlayer) {
            variant.thisVariant = new MorphVariant.Variant();
            variant.thisVariant.playerUUID = ((PlayerEntity)living).func_146103_bH().getId();
        } else {
            CompoundNBT tag = new CompoundNBT();
            EnumMap<EquipmentSlotType, ItemStack> livingItems = new EnumMap<EquipmentSlotType, ItemStack>(EquipmentSlotType.class);
            for (EquipmentSlotType value : EquipmentSlotType.values()) {
                ItemStack item = living.func_184582_a(value);
                if (item == ItemStack.field_190927_a) continue;
                livingItems.put(value, item);
                living.func_184201_a(value, ItemStack.field_190927_a);
            }
            living.func_241354_r_();
            variant.writeSupportedAttributes(living);
            livingItems.forEach((arg_0, arg_1) -> ((LivingEntity)living).func_184201_a(arg_0, arg_1));
            living.func_241354_r_();
            MorphVariant.writeDefaults(living, tag);
            living.func_213281_b(tag);
            NbtModifier nbtModifier = NbtHandler.getModifierFor(living);
            nbtModifier.apply(tag);
            this.writeSpecialTags(living, tag);
            NbtHandler.removeEmptyCompoundTags(tag);
            variant.setLiving(tag);
            variant.thisVariant = new MorphVariant.Variant();
        }
        return variant;
    }

    private void writeSpecialTags(LivingEntity living, CompoundNBT tag) {
        for (BiConsumer<LivingEntity, CompoundNBT> consumer : VARIANT_SPECIAL_TAG_SETTERS) {
            consumer.accept(living, tag);
        }
    }

    @Override
    public boolean acquireMorph(ServerPlayerEntity player, MorphVariant variant) {
        PlayerMorphData playerMorphData = INSTANCE.getPlayerMorphData((PlayerEntity)player);
        if (!playerMorphData.containsVariant(variant)) {
            for (Pattern p : Morph.configServer.disabledMobsID) {
                Matcher m = p.matcher(variant.id.toString());
                if (!m.matches()) continue;
                return false;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new MorphEvent.Acquire((PlayerEntity)player, variant))) {
                return false;
            }
            MorphVariant parentVariant = playerMorphData.addVariant(variant);
            Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorph(parentVariant.write(new CompoundNBT())), player);
            this.saveData.func_76185_a();
            return true;
        }
        return false;
    }

    @Override
    public boolean morphTo(ServerPlayerEntity player, MorphVariant variant) {
        MorphInfo info = INSTANCE.getMorphInfo((PlayerEntity)player);
        if (MinecraftForge.EVENT_BUS.post((Event)new MorphEvent.Morph((PlayerEntity)player, variant))) {
            return false;
        }
        info.setNextState(new MorphState(variant, (PlayerEntity)player), Math.max(1, this.currentMode.getMorphingDuration((PlayerEntity)player)));
        Morph.channel.sendTo((AbstractPacket)new PacketMorphInfo(player.func_145782_y(), info.write(new CompoundNBT())), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
        return true;
    }

    @Override
    public boolean demorph(ServerPlayerEntity player) {
        MorphVariant variant = MorphVariant.createPlayerMorph(player.func_146103_bH().getId(), true);
        variant.thisVariant.identifier = "default_player_state";
        return this.morphTo(player, variant);
    }

    @Override
    public Map<ResourceLocation, AttributeConfig> getSupportedAttributes() {
        return Morph.configServer.supportedAttributesMap;
    }

    @Override
    @Nullable
    public LivingEntity getActiveMorphEntity(PlayerEntity player) {
        return this.getMorphInfo(player).getActiveMorphEntity();
    }

    @Override
    public boolean isEntityAMorph(LivingEntity living) {
        return living != null && living.getPersistentData().func_74764_b("Morph_Player_ID");
    }

    @Override
    @Nullable
    public UUID getUuidOfPlayerForMorph(LivingEntity living) {
        return living != null && living.getPersistentData().func_74764_b("Morph_Player_ID") ? living.getPersistentData().func_186857_a("Morph_Player_ID") : null;
    }

    @Override
    @Nonnull
    public ResourceLocation getMorphSkinTexture() {
        return TEX_MORPH_SKIN;
    }

    @Override
    public List<BiConsumer<LivingEntity, PlayerEntity>> getModPlayerMorphSyncConsumers() {
        return PLAYER_MORPH_SYNC_FUNCTIONS;
    }

    @Override
    public List<BiConsumer<LivingEntity, CompoundNBT>> getVariantNbtTagSetters() {
        return VARIANT_SPECIAL_TAG_SETTERS;
    }

    @Override
    public List<BiConsumer<LivingEntity, CompoundNBT>> getVariantNbtTagReaders() {
        return VARIANT_SPECIAL_TAG_READERS;
    }

    @Override
    public void registerMobData(@Nonnull ResourceLocation rl, @Nonnull MobData data) {
        MobDataHandler.registerMobData(rl, data);
    }

    @Override
    public void registerTrait(@Nonnull String type, @Nonnull Class<? extends Trait> clz) {
        TraitHandler.registerTrait(type, clz);
    }

    @Override
    public ArrayList<Trait<?>> getTraitsForVariant(MorphVariant variant, PlayerEntity player) {
        return this.currentMode != null ? this.currentMode.getTraitsForVariant(player, variant) : IApi.super.getTraitsForVariant(variant, player);
    }

    @Override
    public boolean canUseAbility(PlayerEntity player, Ability<?> ability) {
        return this.currentMode != null ? this.currentMode.canUseAbility(player, ability) : IApi.super.canUseAbility(player, ability);
    }

    @Override
    public boolean hasUnlockedBiomass(PlayerEntity player) {
        return this.currentMode != null ? this.currentMode.hasUnlockedBiomass(player) : IApi.super.hasUnlockedBiomass(player);
    }

    @Override
    public boolean canAcquireBiomass(PlayerEntity player, LivingEntity living) {
        return this.currentMode != null ? this.currentMode.canAcquireBiomass(player, living) : IApi.super.canAcquireBiomass(player, living);
    }

    @Override
    public double getBiomassAmount(PlayerEntity player, LivingEntity living) {
        return this.currentMode != null ? this.currentMode.getBiomassAmount(player, living) : IApi.super.getBiomassAmount(player, living);
    }

    @Override
    @Nullable
    public BiomassUpgradeInfo getBiomassUpgradeInfo(@Nullable String entityId, String id) {
        if (entityId == null) {
            return BiomassUpgradeHandler.BIOMASS_UPGRADES.get(id);
        }
        return null;
    }

    @Override
    @Nullable
    public BiomassUpgrade getBiomassUpgrade(PlayerEntity player, String id) {
        return this.getPlayerMorphData(player).getBiomassUpgrade(id);
    }

    public double getBiomassUpgradeValue(PlayerEntity player, String id) {
        BiomassUpgrade biomassUpgrade = this.getBiomassUpgrade(player, id);
        if (biomassUpgrade != null) {
            return biomassUpgrade.getValue();
        }
        return 0.0;
    }

    public void setBiomassAmount(ServerPlayerEntity player, double value) {
        PlayerMorphData playerMorphData = this.getPlayerMorphData((PlayerEntity)player);
        playerMorphData.biomass = value;
        this.saveData.func_76185_a();
        Morph.channel.sendTo((AbstractPacket)new PacketUpdateBiomassValue(playerMorphData.biomass), player);
    }

    public void addBiomassAmount(ServerPlayerEntity player, double value) {
        PlayerMorphData playerMorphData = this.getPlayerMorphData((PlayerEntity)player);
        double cap = this.getBiomassUpgradeValue((PlayerEntity)player, "biomass_capacity") + this.getBiomassUpgradeValue((PlayerEntity)player, "biomass_critical_capacity");
        if (playerMorphData.biomass + value > cap) {
            value = cap - playerMorphData.biomass;
        }
        playerMorphData.biomass += value;
        this.saveData.func_76185_a();
        Morph.channel.sendTo((AbstractPacket)new PacketUpdateBiomassValue(playerMorphData.biomass), player);
    }

    public boolean isPlayerAllowed(@Nonnull PlayerEntity player, @Nonnull ConfigBase.FilterType type, @Nonnull List<String> names) {
        return type == ConfigBase.FilterType.ALLOW == names.contains(player.func_146103_bH().getName());
    }
}

