/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.mode;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.morph.api.event.MorphEvent;
import me.ichun.mods.morph.api.mob.MobData;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.api.mob.trait.ability.Ability;
import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.api.morph.MorphVariant;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.mob.MobDataHandler;
import me.ichun.mods.morph.common.mode.MorphMode;
import me.ichun.mods.morph.common.morph.MorphHandler;
import me.ichun.mods.morph.common.morph.save.PlayerMorphData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class DefaultMode
implements MorphMode {
    @Override
    public void handleMurderEvent(ServerPlayerEntity player, LivingEntity living) {
        MorphVariant variant;
        if (this.canMorph((PlayerEntity)player) && this.canAcquireMorph((PlayerEntity)player, living, variant = MorphHandler.INSTANCE.createVariant(living))) {
            MorphHandler.INSTANCE.addBiomassAmount(player, this.getBiomassAmount((PlayerEntity)player, living));
            MorphHandler.INSTANCE.acquireMorph(player, variant);
            MorphHandler.INSTANCE.spawnAnimation((PlayerEntity)player, living, false);
        }
    }

    @Override
    public boolean canShowMorphSelector(PlayerEntity player) {
        return MorphHandler.INSTANCE.getBiomassUpgrade(player, "morph_ability") != null && MorphHandler.INSTANCE.isPlayerAllowed(player, Morph.configServer.selectorFilterType, Morph.configServer.selectorFilterNames);
    }

    @Override
    public boolean canMorph(PlayerEntity player) {
        MorphInfo info;
        if (!MorphHandler.INSTANCE.isPlayerAllowed(player, Morph.configServer.morphFilterType, Morph.configServer.morphFilterNames)) {
            return false;
        }
        return MorphHandler.INSTANCE.getBiomassUpgrade(player, "morph_ability") != null && (!(info = MorphHandler.INSTANCE.getMorphInfo(player)).isMorphed() || info.getMorphProgress(1.0f) == 1.0f);
    }

    @Override
    public boolean canAcquireMorph(PlayerEntity player, LivingEntity living, @Nullable MorphVariant variant) {
        if (variant == null || MinecraftForge.EVENT_BUS.post((Event)new MorphEvent.CanAcquire(player, variant)) || !MorphHandler.INSTANCE.isPlayerAllowed(player, Morph.configServer.morphFilterType, Morph.configServer.morphFilterNames)) {
            return false;
        }
        PlayerMorphData playerMorphData = MorphHandler.INSTANCE.getPlayerMorphData(player);
        return !playerMorphData.containsVariant(variant);
    }

    @Override
    public int getMorphingDuration(PlayerEntity player) {
        return Morph.configServer.morphTime;
    }

    @Override
    public ArrayList<Trait<?>> getTraitsForVariant(PlayerEntity player, MorphVariant variant) {
        return new ArrayList();
    }

    @Override
    public boolean canUseAbility(PlayerEntity player, Ability<?> ability) {
        return true;
    }

    @Override
    public boolean hasUnlockedBiomass(PlayerEntity player) {
        return (Morph.configServer.biomassBypassAdvancement || EntityHelper.hasCompletedAdvancement((ResourceLocation)Morph.Advancements.UNLOCK_BIOMASS, (PlayerEntity)player)) && MorphHandler.INSTANCE.isPlayerAllowed(player, Morph.configServer.biomassFilterType, Morph.configServer.biomassFilterNames);
    }

    @Override
    public boolean canAcquireBiomass(PlayerEntity player, LivingEntity living) {
        double maxAbsorbable;
        for (Pattern p : Morph.configServer.disabledMobsID) {
            Matcher m = p.matcher(living.func_200600_R().getRegistryName().toString());
            if (!m.matches()) continue;
            return false;
        }
        if (!MorphHandler.INSTANCE.isPlayerAllowed(player, Morph.configServer.biomassFilterType, Morph.configServer.biomassFilterNames)) {
            return false;
        }
        double weight = this.getLivingWeight(living);
        return weight < (maxAbsorbable = 1.0 + MorphHandler.INSTANCE.getBiomassUpgradeValue(player, "biomass_max_mass_absorbable"));
    }

    @Override
    public double getBiomassAmount(PlayerEntity player, LivingEntity living) {
        double playerEfficiency = MorphHandler.INSTANCE.getBiomassUpgradeValue(player, "biomass_efficiency");
        return this.getLivingWeight(living) * playerEfficiency;
    }

    public double getLivingWeight(LivingEntity living) {
        double volume = living.func_213311_cf() * living.func_213311_cf() * living.func_213302_cg();
        double weight = 1000.0 * volume;
        MobData data = MobDataHandler.getMobData(living);
        if (data != null) {
            if (data.biomassMultiplier != null) {
                weight *= data.biomassMultiplier.doubleValue();
            }
            if (data.biomassValueOverride != null) {
                weight = data.biomassValueOverride;
            }
        }
        return weight * Morph.configServer.biomassValue;
    }

    @Override
    public String getModeName() {
        return "default";
    }
}

