/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.mode;

import java.util.ArrayList;
import javax.annotation.Nullable;
import me.ichun.mods.morph.api.event.MorphEvent;
import me.ichun.mods.morph.api.mob.MobData;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.api.mob.trait.ability.Ability;
import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.api.morph.MorphVariant;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.mob.MobDataHandler;
import me.ichun.mods.morph.common.mode.MorphMode;
import me.ichun.mods.morph.common.morph.MorphHandler;
import me.ichun.mods.morph.common.morph.save.PlayerMorphData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ClassicMode
implements MorphMode {
    @Override
    public void handleMurderEvent(ServerPlayerEntity player, LivingEntity living) {
        MorphVariant variant;
        if (this.canMorph((PlayerEntity)player) && this.canAcquireMorph((PlayerEntity)player, living, variant = MorphHandler.INSTANCE.createVariant(living))) {
            MorphHandler.INSTANCE.acquireMorph(player, variant);
            MorphHandler.INSTANCE.spawnAnimation((PlayerEntity)player, living, true);
        }
    }

    @Override
    public boolean canShowMorphSelector(PlayerEntity player) {
        return MorphHandler.INSTANCE.isPlayerAllowed(player, Morph.configServer.selectorFilterType, Morph.configServer.selectorFilterNames);
    }

    @Override
    public boolean canMorph(PlayerEntity player) {
        if (!MorphHandler.INSTANCE.isPlayerAllowed(player, Morph.configServer.morphFilterType, Morph.configServer.morphFilterNames)) {
            return false;
        }
        MorphInfo info = MorphHandler.INSTANCE.getMorphInfo(player);
        return !info.isMorphed() || !(info.getMorphProgress(1.0f) < 1.0f);
    }

    @Override
    public boolean canAcquireMorph(PlayerEntity player, LivingEntity living, @Nullable MorphVariant variant) {
        if (variant == null || MinecraftForge.EVENT_BUS.post((Event)new MorphEvent.CanAcquire(player, variant)) || !MorphHandler.INSTANCE.isPlayerAllowed(player, Morph.configServer.morphFilterType, Morph.configServer.morphFilterNames)) {
            return false;
        }
        PlayerMorphData playerMorphData = MorphHandler.INSTANCE.getPlayerMorphData(player);
        return !playerMorphData.containsVariant(variant);
    }

    @Override
    public int getMorphingDuration(PlayerEntity player) {
        return Morph.configServer.morphTime;
    }

    @Override
    public ArrayList<Trait<?>> getTraitsForVariant(PlayerEntity player, MorphVariant variant) {
        ArrayList traits = new ArrayList();
        MobData mobData = MobDataHandler.getMobData(variant.id);
        if (mobData != null && mobData.traits != null) {
            ArrayList<String> upgradedTraits = new ArrayList<String>();
            for (Trait<Object> trait2 : mobData.traits) {
                if (trait2 == null || Morph.configServer.disabledTraits.contains(trait2.type) || trait2.upgradeFor != null && !Morph.configServer.classicUpgradeTraits) continue;
                traits.add((Trait<?>)trait2.copy());
                if (trait2.upgradeFor == null) continue;
                upgradedTraits.add(trait2.upgradeFor);
            }
            for (String upgradedTrait : upgradedTraits) {
                traits.removeIf(trait -> trait.type.equals(upgradedTrait));
            }
            for (Trait<Object> trait2 : traits) {
                trait2.player = player;
                trait2.stateTraits = traits;
            }
        }
        return traits;
    }

    @Override
    public boolean canUseAbility(PlayerEntity player, Ability<?> ability) {
        return true;
    }

    @Override
    public boolean hasUnlockedBiomass(PlayerEntity player) {
        return false;
    }

    @Override
    public boolean canAcquireBiomass(PlayerEntity player, LivingEntity living) {
        return false;
    }

    @Override
    public double getBiomassAmount(PlayerEntity player, LivingEntity living) {
        return 0.0;
    }

    @Override
    public String getModeName() {
        return "classic";
    }
}

