/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.mob;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import me.ichun.mods.morph.api.mob.trait.DamageSourceImmunityTrait;
import me.ichun.mods.morph.api.mob.trait.EffectResistanceTrait;
import me.ichun.mods.morph.api.mob.trait.ExplosiveImmunityTrait;
import me.ichun.mods.morph.api.mob.trait.FallNegateTrait;
import me.ichun.mods.morph.api.mob.trait.FireImmunityTrait;
import me.ichun.mods.morph.api.mob.trait.FloatTrait;
import me.ichun.mods.morph.api.mob.trait.HostileTrait;
import me.ichun.mods.morph.api.mob.trait.IntimidateTrait;
import me.ichun.mods.morph.api.mob.trait.MagicImmunityTrait;
import me.ichun.mods.morph.api.mob.trait.MoistSkinTrait;
import me.ichun.mods.morph.api.mob.trait.SinkTrait;
import me.ichun.mods.morph.api.mob.trait.StepHeightTrait;
import me.ichun.mods.morph.api.mob.trait.SunburnTrait;
import me.ichun.mods.morph.api.mob.trait.SwimmerTrait;
import me.ichun.mods.morph.api.mob.trait.Trait;
import me.ichun.mods.morph.api.mob.trait.UndeadTrait;
import me.ichun.mods.morph.api.mob.trait.WaterBreatherTrait;
import me.ichun.mods.morph.api.mob.trait.WaterSensitivityTrait;
import me.ichun.mods.morph.api.mob.trait.ability.ClimbAbility;
import me.ichun.mods.morph.api.mob.trait.ability.EffectAttackAbility;
import me.ichun.mods.morph.api.mob.trait.ability.FlightFlapAbility;
import me.ichun.mods.morph.api.mob.trait.ability.FlyAbility;
import me.ichun.mods.morph.api.mob.trait.ability.RideableAbility;
import me.ichun.mods.morph.api.mob.trait.ability.SlowFallAbility;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.resource.ResourceHandler;
import net.minecraft.util.Util;

public class TraitHandler {
    public static final HashMap<String, Class<? extends Trait>> TRAITS = (HashMap)Util.func_200696_a(new HashMap(), m -> {
        m.put("traitFallNegate", FallNegateTrait.class);
        m.put("traitFloat", FloatTrait.class);
        m.put("traitHostile", HostileTrait.class);
        m.put("traitImmunityExplosive", ExplosiveImmunityTrait.class);
        m.put("traitImmunityFire", FireImmunityTrait.class);
        m.put("traitImmunityMagic", MagicImmunityTrait.class);
        m.put("traitSink", SinkTrait.class);
        m.put("traitWaterSensitivity", WaterSensitivityTrait.class);
        m.put("traitUndead", UndeadTrait.class);
        m.put("traitEffectResistance", EffectResistanceTrait.class);
        m.put("traitImmunityDamageSource", DamageSourceImmunityTrait.class);
        m.put("traitIntimidate", IntimidateTrait.class);
        m.put("traitMoistSkin", MoistSkinTrait.class);
        m.put("traitStepHeight", StepHeightTrait.class);
        m.put("traitSwimmer", SwimmerTrait.class);
        m.put("traitSunburn", SunburnTrait.class);
        m.put("traitWaterBreather", WaterBreatherTrait.class);
        m.put("abilityClimb", ClimbAbility.class);
        m.put("abilityEffectAttack", EffectAttackAbility.class);
        m.put("abilityFlight", FlyAbility.class);
        m.put("abilityFlightFlap", FlightFlapAbility.class);
        m.put("abilityRideable", RideableAbility.class);
        m.put("abilitySlowFall", SlowFallAbility.class);
    });

    public static void registerTrait(String type, Class<? extends Trait> clz) {
        if (TRAITS.containsKey(type)) {
            Morph.LOGGER.warn("We already have another Trait of type {} with class {}. This is a mod-level override so we shall acknowledge it. Overriding with class {}", (Object)type, (Object)TRAITS.get(type).getName(), (Object)clz.getName());
        }
        TRAITS.put(type, clz);
    }

    public static class TraitDeserialiser
    implements JsonDeserializer<Trait>,
    JsonSerializer<Trait> {
        public Trait deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return TraitDeserialiser._deserialize(json, typeOfT, context);
        }

        public static Trait _deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            JsonObject jsonObject = (JsonObject)json;
            String type = jsonObject.get("type").getAsString();
            if (TRAITS.containsKey(type)) {
                Trait trait = (Trait)ResourceHandler.GSON.fromJson(jsonObject.toString(), TRAITS.get(type));
                if (trait != null) {
                    return trait;
                }
                Morph.LOGGER.error("Invalid trait: " + jsonObject.toString());
            } else {
                Morph.LOGGER.error("Unknown trait type: " + type);
            }
            return null;
        }

        public JsonElement serialize(Trait src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src);
        }
    }
}

