/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.mob;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import me.ichun.mods.morph.api.event.MorphLoadResourceEvent;
import me.ichun.mods.morph.api.mob.MobData;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.resource.ResourceHandler;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.FileUtils;

public class MobDataHandler {
    private static final HashMap<ResourceLocation, MobData> MOB_DATA = new HashMap();
    private static final HashMap<ResourceLocation, MobData> MOB_DATA_FROM_MODS = new HashMap();

    public static void loadMobData() {
        MOB_DATA.clear();
        int filesProcessed = 0;
        try {
            filesProcessed = IOUtil.scourDirectoryForFiles((Path)ResourceHandler.getMorphDir().resolve("mob"), p -> {
                if (p.getFileName().toString().endsWith(".json")) {
                    File file = p.toFile();
                    try {
                        String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                        if (MobDataHandler.readMobDataJson(json)) {
                            return true;
                        }
                        Morph.LOGGER.error("Error reading Mob Data file, no forEntity: {}", (Object)file);
                        return false;
                    }
                    catch (JsonSyntaxException | IOException | IllegalStateException e) {
                        Morph.LOGGER.error("Error reading Mob Data file: {}", (Object)file);
                        e.printStackTrace();
                    }
                }
                return false;
            });
        }
        catch (IOException e) {
            Morph.LOGGER.error("Error loading Mob Data files.", (Throwable)e);
        }
        Morph.LOGGER.info("Loaded {} Mob Data(s) from {} files", (Object)MOB_DATA.size(), (Object)filesProcessed);
        MobDataHandler.readdModMobData();
        MinecraftForge.EVENT_BUS.post((Event)new MorphLoadResourceEvent(MorphLoadResourceEvent.Type.MOB));
    }

    private static boolean readMobDataJson(String json) throws JsonSyntaxException, IllegalStateException {
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(json).getAsJsonObject();
        if (jsonObject.has("forEntity")) {
            String resourceId = jsonObject.get("forEntity").getAsString();
            ResourceLocation rl = new ResourceLocation(resourceId);
            if (MOB_DATA.containsKey(rl)) {
                Morph.LOGGER.warn("We already have another Mob Data for {}", (Object)resourceId);
            }
            try {
                if (ForgeRegistries.ENTITIES.containsKey(rl)) {
                    MobData mobData = (MobData)ResourceHandler.GSON.fromJson(json, MobData.class);
                    MOB_DATA.put(rl, mobData);
                }
            }
            catch (Throwable t) {
                Morph.LOGGER.error("Error deserialising Mob Data for {}", (Object)resourceId);
                t.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public static void registerMobData(ResourceLocation rl, MobData data) {
        MOB_DATA_FROM_MODS.put(rl, data);
        if (MOB_DATA.containsKey(rl)) {
            Morph.LOGGER.warn("We already have another Mob Data for {}. This is a mod-level override so we shall acknowledge it.", (Object)rl.toString());
        }
        MOB_DATA.put(rl, data);
    }

    private static void readdModMobData() {
        MOB_DATA.putAll(MOB_DATA_FROM_MODS);
    }

    @Nullable
    public static MobData getMobData(ResourceLocation rl) {
        return MOB_DATA.get(rl);
    }

    @Nullable
    public static MobData getMobData(LivingEntity living) {
        return MobDataHandler.getMobData(living.func_200600_R().getRegistryName());
    }
}

