/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.core;

import com.mojang.brigadier.CommandDispatcher;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.morph.api.morph.MorphInfo;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.biomass.BiomassUpgradeHandler;
import me.ichun.mods.morph.common.command.CommandMorph;
import me.ichun.mods.morph.common.morph.MorphHandler;
import me.ichun.mods.morph.common.morph.MorphInfoImpl;
import me.ichun.mods.morph.common.morph.save.MorphSavedData;
import me.ichun.mods.morph.common.packet.PacketPlayerData;
import me.ichun.mods.morph.common.packet.PacketSessionSync;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;

public class EventHandlerServer {
    @SubscribeEvent
    public void onAttachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity && !(entity instanceof FakePlayer)) {
            event.addCapability(MorphInfo.CAPABILITY_IDENTIFIER, (ICapabilityProvider)new MorphInfo.CapProvider(new MorphInfoImpl((PlayerEntity)entity)));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().getPersistentData().func_74764_b("Morph_Player_ID")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g().getPersistentData().func_74764_b("Morph_Player_ID")) {
            event.setCanceled(true);
        }
        if (event.getEntityLiving().getPersistentData().func_74764_b("Morph_Player_ID") && (event.getSource() != DamageSource.field_76380_i || event.getAmount() != Float.MAX_VALUE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().getPersistentData().func_74764_b("Morph_Player_ID")) {
            event.setCanceled(true);
            return;
        }
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && event.getSource().func_76346_g() instanceof ServerPlayerEntity && !(event.getSource().func_76346_g() instanceof FakePlayer) && !event.getSource().func_76346_g().field_70128_L && event.getEntity().func_145782_y() > 0) {
            MorphHandler.INSTANCE.handleMurderEvent((ServerPlayerEntity)event.getSource().func_76346_g(), event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onEntitySize(EntityEvent.Size event) {
        MorphInfo info;
        if (event.getEntity() instanceof PlayerEntity && !event.getEntity().field_70128_L && event.getEntity().func_145782_y() > 0 && event.getEntity().field_70173_aa >= 0 && (info = MorphHandler.INSTANCE.getMorphInfo((PlayerEntity)event.getEntity())).isMorphed()) {
            event.setNewSize(info.getMorphSize(1.0f));
            event.setNewEyeHeight(info.getMorphEyeHeight(1.0f));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.field_70128_L && event.player.func_145782_y() > 0) {
            MorphInfo info = MorphHandler.INSTANCE.getMorphInfo(event.player);
            info.tick();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().func_184102_h().func_71264_H() || !event.getPlayer().func_146103_bH().getName().equals(event.getPlayer().func_184102_h().func_71214_G())) {
            Morph.channel.sendTo((AbstractPacket)new PacketSessionSync(BiomassUpgradeHandler.BIOMASS_UPGRADES.values()), (ServerPlayerEntity)event.getPlayer());
        }
        Morph.channel.sendTo((AbstractPacket)new PacketPlayerData(MorphHandler.INSTANCE.getPlayerMorphData(event.getPlayer()).write(new CompoundNBT())), (ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        MorphHandler.INSTANCE.getMorphInfo(event.getPlayer()).read(MorphHandler.INSTANCE.getMorphInfo(event.getOriginal()).write(new CompoundNBT()));
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d() && ((ServerWorld)event.getWorld()).func_234923_W_().equals(World.field_234918_g_)) {
            MorphHandler.INSTANCE.setSaveData((MorphSavedData)((ServerWorld)event.getWorld()).func_217481_x().func_215752_a(MorphSavedData::new, "morph_save"));
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandMorph.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        BiomassUpgradeHandler.loadBiomassUpgrades();
    }

    @SubscribeEvent
    public void onServerStopped(FMLServerStoppedEvent event) {
        MorphHandler.INSTANCE.setSaveData(null);
    }
}

